/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.components.BlockColorComponent;
import appeng.bootstrap.components.RenderTypeComponent;
import appeng.client.render.model.AutoRotatingBakedModel;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class BlockRendering
implements IBlockRendering {
    @OnlyIn(value=Dist.CLIENT)
    private BiFunction<ResourceLocation, IBakedModel, IBakedModel> modelCustomizer;
    @OnlyIn(value=Dist.CLIENT)
    private IBlockColor blockColor;
    @OnlyIn(value=Dist.CLIENT)
    private RenderType renderType;
    @OnlyIn(value=Dist.CLIENT)
    private Predicate<RenderType> renderTypes;

    BlockRendering() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IBlockRendering modelCustomizer(BiFunction<ResourceLocation, IBakedModel, IBakedModel> customizer) {
        this.modelCustomizer = customizer;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IBlockRendering blockColor(IBlockColor blockColor) {
        this.blockColor = blockColor;
        return this;
    }

    @Override
    public IBlockRendering renderType(RenderType type) {
        this.renderType = type;
        return this;
    }

    @Override
    public IBlockRendering renderType(Predicate<RenderType> typePredicate) {
        this.renderTypes = typePredicate;
        return this;
    }

    void apply(FeatureFactory factory, Block block) {
        if (this.modelCustomizer != null) {
            factory.addModelOverride(block.getRegistryName().func_110623_a(), this.modelCustomizer);
        } else if (block instanceof AEBaseTileBlock) {
            factory.addModelOverride(block.getRegistryName().func_110623_a(), (l, m) -> new AutoRotatingBakedModel((IBakedModel)m));
        }
        if (this.blockColor != null) {
            factory.addBootstrapComponent(new BlockColorComponent(block, this.blockColor));
        }
        if (this.renderType != null || this.renderTypes != null) {
            factory.addBootstrapComponent(new RenderTypeComponent(block, this.renderType, this.renderTypes));
        }
    }
}

