/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.bootstrap.BlockDefinitionBuilder;
import appeng.bootstrap.EntityBuilder;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemDefinitionBuilder;
import appeng.bootstrap.TileEntityBuilder;
import appeng.bootstrap.components.ModelOverrideComponent;
import appeng.tile.AEBaseTileEntity;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FeatureFactory {
    private final AEFeature[] defaultFeatures;
    private final Map<Class<? extends IBootstrapComponent>, List<IBootstrapComponent>> bootstrapComponents;
    @OnlyIn(value=Dist.CLIENT)
    private ModelOverrideComponent modelOverrideComponent;

    public FeatureFactory() {
        this.defaultFeatures = new AEFeature[]{AEFeature.CORE};
        this.bootstrapComponents = new HashMap<Class<? extends IBootstrapComponent>, List<IBootstrapComponent>>();
        if (Platform.hasClientClasses()) {
            this.modelOverrideComponent = new ModelOverrideComponent();
            this.addBootstrapComponent(this.modelOverrideComponent);
        }
    }

    private FeatureFactory(FeatureFactory parent, AEFeature ... defaultFeatures) {
        this.defaultFeatures = (AEFeature[])defaultFeatures.clone();
        this.bootstrapComponents = parent.bootstrapComponents;
        if (Platform.hasClientClasses()) {
            this.modelOverrideComponent = parent.modelOverrideComponent;
        }
    }

    public IBlockBuilder block(String id, Supplier<Block> block) {
        return new BlockDefinitionBuilder(this, id, block).features(this.defaultFeatures);
    }

    public IItemBuilder item(String id, Function<Item.Properties, Item> itemFactory) {
        return new ItemDefinitionBuilder(this, id, itemFactory).features(this.defaultFeatures);
    }

    public <T extends Entity> EntityBuilder<T> entity(String id, EntityType.IFactory<T> factory, EntityClassification classification) {
        return new EntityBuilder<T>(this, id, factory, classification).features(this.defaultFeatures);
    }

    public <T extends AEBaseTileEntity> TileEntityBuilder<T> tileEntity(String id, Class<T> teClass, Function<TileEntityType<T>, T> factory) {
        return new TileEntityBuilder<T>(this, id, teClass, factory).features(this.defaultFeatures);
    }

    public FeatureFactory features(AEFeature ... features) {
        return new FeatureFactory(this, features);
    }

    public void addBootstrapComponent(IBootstrapComponent component) {
        Arrays.stream(component.getClass().getInterfaces()).filter(i -> IBootstrapComponent.class.isAssignableFrom((Class<?>)i)).forEach(i -> this.addBootstrapComponent((Class<? extends IBootstrapComponent>)i, (IBootstrapComponent)component));
    }

    private <T extends IBootstrapComponent> void addBootstrapComponent(Class<? extends IBootstrapComponent> eventType, T component) {
        this.bootstrapComponents.computeIfAbsent(eventType, c -> new ArrayList()).add(component);
    }

    @OnlyIn(value=Dist.CLIENT)
    void addModelOverride(String resourcePath, BiFunction<ResourceLocation, IBakedModel, IBakedModel> customizer) {
        this.modelOverrideComponent.addOverride(resourcePath, customizer);
    }

    public <T extends IBootstrapComponent> Iterator<T> getBootstrapComponents(Class<T> eventType) {
        return this.bootstrapComponents.getOrDefault(eventType, Collections.emptyList()).iterator();
    }
}

