/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.container.implementations.InterfaceContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigButtonPacket;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class InterfaceScreen
extends UpgradeableScreen<InterfaceContainer> {
    private final SettingToggleButton<YesNo> blockMode;
    private final ToggleButton interfaceMode;

    public InterfaceScreen(InterfaceContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.widgets.addOpenPriorityButton();
        this.blockMode = new ServerSettingToggleButton<YesNo>(Settings.BLOCK, YesNo.NO);
        this.addToLeftToolbar(this.blockMode);
        this.interfaceMode = new ToggleButton(Icon.INTERFACE_TERMINAL_SHOW, Icon.INTERFACE_TERMINAL_HIDE, GuiText.InterfaceTerminal.text(), GuiText.InterfaceTerminalHint.text(), btn -> this.selectNextInterfaceMode());
        this.addToLeftToolbar(this.interfaceMode);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.blockMode.set(((InterfaceContainer)this.field_147002_h).getBlockingMode());
        this.interfaceMode.setState(((InterfaceContainer)this.field_147002_h).getInterfaceTerminalMode() == YesNo.YES);
    }

    private void selectNextInterfaceMode() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigButtonPacket(Settings.INTERFACE_TERMINAL, backwards));
    }
}

