/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.AbstractTableRenderer;
import appeng.container.me.crafting.CraftingPlanSummaryEntry;
import appeng.core.localization.GuiText;
import appeng.util.ReadableNumberConverter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class CraftConfirmTableRenderer
extends AbstractTableRenderer<CraftingPlanSummaryEntry> {
    public CraftConfirmTableRenderer(AEBaseScreen<?> screen, int x, int y) {
        super(screen, x, y);
    }

    @Override
    protected List<ITextComponent> getEntryDescription(CraftingPlanSummaryEntry entry) {
        String amount;
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>(3);
        if (entry.getStoredAmount() > 0L) {
            amount = ReadableNumberConverter.INSTANCE.toWideReadableForm(entry.getStoredAmount());
            lines.add((ITextComponent)GuiText.FromStorage.text(amount));
        }
        if (entry.getMissingAmount() > 0L) {
            amount = ReadableNumberConverter.INSTANCE.toWideReadableForm(entry.getMissingAmount());
            lines.add((ITextComponent)GuiText.Missing.text(amount));
        }
        if (entry.getCraftAmount() > 0L) {
            amount = ReadableNumberConverter.INSTANCE.toWideReadableForm(entry.getCraftAmount());
            lines.add((ITextComponent)GuiText.ToCraft.text(amount));
        }
        return lines;
    }

    @Override
    protected ItemStack getEntryItem(CraftingPlanSummaryEntry entry) {
        return entry.getItem();
    }

    @Override
    protected List<ITextComponent> getEntryTooltip(CraftingPlanSummaryEntry entry) {
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>(this.screen.func_231151_a_(entry.getItem()));
        if (entry.getStoredAmount() > 0L) {
            lines.add((ITextComponent)GuiText.FromStorage.text(entry.getStoredAmount()));
        }
        if (entry.getMissingAmount() > 0L) {
            lines.add((ITextComponent)GuiText.Missing.text(entry.getMissingAmount()));
        }
        if (entry.getCraftAmount() > 0L) {
            lines.add((ITextComponent)GuiText.ToCraft.text(entry.getCraftAmount()));
        }
        return lines;
    }

    @Override
    protected int getEntryOverlayColor(CraftingPlanSummaryEntry entry) {
        return entry.getMissingAmount() > 0L ? 452919296 : 0;
    }
}

