/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.fluids;

import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.core.AEConfig;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class FluidStackSizeRenderer
extends StackSizeRenderer {
    private static final String[] NUMBER_FORMATS = new String[]{"#.000", "#.00", "#.0", "#"};

    @Override
    protected String getToBeRenderedStackSize(long originalSize) {
        if (originalSize < 100000L && AEConfig.instance().isUseLargeFonts()) {
            return this.getSlimRenderedStacksize(originalSize);
        }
        if (originalSize < 1000000L && !AEConfig.instance().isUseLargeFonts()) {
            return this.getWideRenderedStacksize(originalSize);
        }
        return super.getToBeRenderedStackSize(originalSize / 1000L);
    }

    private String getSlimRenderedStacksize(long originalSize) {
        int log = 1 + (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private String getWideRenderedStacksize(long originalSize) {
        int log = (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private String getRenderedFluidStackSize(long originalSize, int log) {
        int index = Math.max(0, Math.min(3, log));
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(NUMBER_FORMATS[index]);
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        return format.format((double)originalSize / 1000.0);
    }
}

