/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.me.common.MEMonitorableScreen;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.items.ItemRepo;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.IScrollSource;
import appeng.container.me.common.GridInventoryEntry;
import appeng.container.me.common.MEMonitorableContainer;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.util.prioritylist.IPartitionList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class ItemTerminalScreen<C extends MEMonitorableContainer<IAEItemStack>>
extends MEMonitorableScreen<IAEItemStack, C> {
    public ItemTerminalScreen(C container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
    }

    @Override
    protected Repo<IAEItemStack> createRepo(IScrollSource scrollSource) {
        return new ItemRepo(scrollSource, this);
    }

    @Override
    protected IPartitionList<IAEItemStack> createPartitionList(List<ItemStack> viewCells) {
        return ViewCellItem.createFilter(viewCells);
    }

    @Override
    protected void renderGridInventoryEntry(MatrixStack matrices, int x, int y, GridInventoryEntry<IAEItemStack> entry) {
        ItemStack displayStack = entry.getStack().asItemStackRepresentation();
        Inventory displayInv = new Inventory(new ItemStack[]{displayStack});
        super.func_238746_a_(matrices, new Slot((IInventory)displayInv, 0, x, y));
    }

    @Override
    protected void handleGridInventoryEntryMouseClick(@Nullable GridInventoryEntry<IAEItemStack> entry, int mouseButton, ClickType clickType) {
        if (entry == null) {
            if (clickType == ClickType.PICKUP && !this.field_213127_e.func_70445_o().func_190926_b()) {
                InventoryAction action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                ((MEMonitorableContainer)this.field_147002_h).handleInteraction(-1L, action);
            }
            return;
        }
        long serial = entry.getSerial();
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32)) {
            ((MEMonitorableContainer)this.field_147002_h).handleInteraction(serial, InventoryAction.MOVE_REGION);
        } else {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    if (action != InventoryAction.PICKUP_OR_SET_DOWN || !this.shouldCraftOnClick(entry) || !this.field_213127_e.func_70445_o().func_190926_b()) break;
                    ((MEMonitorableContainer)this.field_147002_h).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                    return;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (entry.isCraftable()) {
                        ((MEMonitorableContainer)this.field_147002_h).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                        return;
                    }
                    if (!this.field_213127_e.field_70458_d.field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((MEMonitorableContainer)this.field_147002_h).handleInteraction(serial, action);
            }
        }
    }

    private boolean shouldCraftOnClick(GridInventoryEntry<IAEItemStack> entry) {
        if (this.isViewOnlyCraftable()) {
            return true;
        }
        return entry.getStoredAmount() == 0L && entry.isCraftable();
    }
}

