/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.container.slot.OptionalTypeOnlyFakeSlot;
import appeng.core.Api;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.misc.StorageBusPart;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class StorageBusContainer
extends UpgradeableContainer {
    public static final ContainerType<StorageBusContainer> TYPE = ContainerTypeBuilder.create(StorageBusContainer::new, StorageBusPart.class).requirePermission(SecurityPermissions.BUILD).build("storagebus");
    private final StorageBusPart storageBus;
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;

    public StorageBusContainer(int id, PlayerInventory ip, StorageBusPart te) {
        super(TYPE, id, ip, te);
        this.storageBus = te;
    }

    @Override
    protected void setupConfig() {
        IItemHandler config = this.getUpgradeable().getInventoryByName("config");
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                int invSlot = y * 9 + x;
                if (y < 2) {
                    this.addSlot(new FakeTypeOnlySlot(config, invSlot), SlotSemantic.CONFIG);
                    continue;
                }
                this.addSlot(new OptionalTypeOnlyFakeSlot(config, this, invSlot, y - 2), SlotSemantic.CONFIG);
            }
        }
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return true;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.setFuzzyMode((FuzzyMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FUZZY_MODE));
            this.setReadWriteMode((AccessRestriction)this.getUpgradeable().getConfigManager().getSetting(Settings.ACCESS));
            this.setStorageFilter((StorageFilter)this.getUpgradeable().getConfigManager().getSetting(Settings.STORAGE_FILTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return upgrades > idx;
    }

    public void clear() {
        ItemHandlerUtil.clear(this.getUpgradeable().getInventoryByName("config"));
        this.func_75142_b();
    }

    public void partition() {
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        MEInventoryHandler<IAEItemStack> cellInv = this.storageBus.getInternalHandler();
        Iterator i = new NullIterator();
        if (cellInv != null) {
            IItemList list = cellInv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.getSlots(); ++x) {
            if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                ItemStack g = ((IAEItemStack)i.next()).asItemStackRepresentation();
                ItemHandlerUtil.setStackInSlot(inv, x, g);
                continue;
            }
            ItemHandlerUtil.setStackInSlot(inv, x, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }
}

