/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.util.IConfigManager;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalFakeSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.tools.NetworkToolItem;
import appeng.parts.automation.ExportBusPart;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;

public abstract class UpgradeableContainer
extends AEBaseContainer
implements IOptionalSlotHost {
    private final IUpgradeableHost upgradeable;
    @GuiSync(value=0)
    public RedstoneMode rsMode = RedstoneMode.IGNORE;
    @GuiSync(value=1)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;
    @GuiSync(value=5)
    public YesNo cMode = YesNo.NO;
    @GuiSync(value=6)
    public SchedulingMode schedulingMode = SchedulingMode.DEFAULT;
    private int tbSlot;
    private NetworkToolViewer tbInventory;

    public UpgradeableContainer(ContainerType<?> containerType, int id, PlayerInventory ip, IUpgradeableHost te) {
        super(containerType, id, ip, te);
        this.upgradeable = te;
        PlayerInventory pi = this.getPlayerInventory();
        for (int x = 0; x < pi.func_70302_i_(); ++x) {
            ItemStack pii = pi.func_70301_a(x);
            if (pii.func_190926_b() || !(pii.func_77973_b() instanceof NetworkToolItem)) continue;
            this.lockPlayerInventorySlot(x);
            this.tbSlot = x;
            this.tbInventory = ((NetworkToolItem)pii.func_77973_b()).getGuiObject(pii, x, this.getPlayerInventory().field_70458_d.field_70170_p, null);
            break;
        }
        if (this.hasToolbox()) {
            for (int i = 0; i < 9; ++i) {
                RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, this.tbInventory.getInternalInventory(), i);
                this.addSlot(slot, SlotSemantic.TOOLBOX);
            }
        }
        this.setupConfig();
        this.createPlayerInventorySlots(ip);
    }

    public boolean hasToolbox() {
        return this.tbInventory != null;
    }

    @Nonnull
    public ITextComponent getToolboxName() {
        return this.tbInventory != null ? this.tbInventory.getItemStack().func_200301_q() : StringTextComponent.field_240750_d_;
    }

    protected abstract void setupConfig();

    protected final void setupUpgrades() {
        IItemHandler upgrades = this.getUpgradeable().getUpgradeInventory();
        for (int i = 0; i < this.availableUpgrades(); ++i) {
            RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, i);
            slot.setNotDraggable();
            this.addSlot(slot, SlotSemantic.UPGRADE);
        }
    }

    protected boolean supportCapacity() {
        return true;
    }

    public int availableUpgrades() {
        return 4;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            IConfigManager cm = this.getUpgradeable().getConfigManager();
            this.loadSettingsFromHost(cm);
        }
        this.checkToolbox();
        for (Object o : this.field_75151_b) {
            OptionalFakeSlot fs;
            if (!(o instanceof OptionalFakeSlot) || (fs = (OptionalFakeSlot)o).isSlotEnabled() || fs.getDisplayStack().func_190926_b()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED));
        if (this.getUpgradeable() instanceof ExportBusPart) {
            this.setCraftingMode((YesNo)cm.getSetting(Settings.CRAFT_ONLY));
            this.setSchedulingMode((SchedulingMode)cm.getSetting(Settings.SCHEDULING_MODE));
        }
    }

    protected void checkToolbox() {
        ItemStack currentItem;
        if (this.hasToolbox() && (currentItem = this.getPlayerInventory().func_70301_a(this.tbSlot)) != this.tbInventory.getItemStack()) {
            if (!currentItem.func_190926_b()) {
                if (ItemStack.func_179545_c((ItemStack)this.tbInventory.getItemStack(), (ItemStack)currentItem)) {
                    this.getPlayerInventory().func_70299_a(this.tbSlot, this.tbInventory.getItemStack());
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    protected void standardDetectAndSendChanges() {
        super.func_75142_b();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        int capacityUpgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        return idx == 1 && capacityUpgrades >= 1 || idx == 2 && capacityUpgrades >= 2;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fzMode;
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        this.fzMode = fzMode;
    }

    public YesNo getCraftingMode() {
        return this.cMode;
    }

    public void setCraftingMode(YesNo cMode) {
        this.cMode = cMode;
    }

    public RedstoneMode getRedStoneMode() {
        return this.rsMode;
    }

    public void setRedStoneMode(RedstoneMode rsMode) {
        this.rsMode = rsMode;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    private void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    public IUpgradeableHost getUpgradeable() {
        return this.upgradeable;
    }

    public final boolean hasUpgrade(Upgrades upgrade) {
        return this.upgradeable.getInstalledUpgrades(upgrade) > 0;
    }
}

