/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class CraftingStatusEntry {
    private final long serial;
    private final ItemStack item;
    private final long storedAmount;
    private final long activeAmount;
    private final long pendingAmount;

    public CraftingStatusEntry(long serial, ItemStack item, long storedAmount, long activeAmount, long pendingAmount) {
        this.serial = serial;
        this.item = item;
        this.storedAmount = storedAmount;
        this.activeAmount = activeAmount;
        this.pendingAmount = pendingAmount;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getActiveAmount() {
        return this.activeAmount;
    }

    public long getStoredAmount() {
        return this.storedAmount;
    }

    public long getPendingAmount() {
        return this.pendingAmount;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179254_b(this.serial);
        buffer.func_179254_b(this.activeAmount);
        buffer.func_179254_b(this.storedAmount);
        buffer.func_179254_b(this.pendingAmount);
        buffer.writeItemStack(this.item, true);
    }

    public static CraftingStatusEntry read(PacketBuffer buffer) {
        long serial = buffer.func_179260_f();
        long missingAmount = buffer.func_179260_f();
        long storedAmount = buffer.func_179260_f();
        long craftAmount = buffer.func_179260_f();
        ItemStack item = buffer.func_150791_c();
        return new CraftingStatusEntry(serial, item, storedAmount, missingAmount, craftAmount);
    }

    public boolean isDeleted() {
        return this.storedAmount == 0L && this.activeAmount == 0L && this.pendingAmount == 0L;
    }
}

