/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IWorldGen;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public final class WorldGenRegistry
implements IWorldGen {
    public static final WorldGenRegistry INSTANCE = new WorldGenRegistry();
    private final Map<IWorldGen.WorldGenType, TypeSet> settings = new EnumMap<IWorldGen.WorldGenType, TypeSet>(IWorldGen.WorldGenType.class);

    public WorldGenRegistry() {
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            this.settings.put(type, new TypeSet());
        }
    }

    @Override
    public void enableWorldGenForDimension(IWorldGen.WorldGenType type, ResourceLocation dimID) {
    }

    @Override
    public void disableWorldGenForDimension(IWorldGen.WorldGenType type, ResourceLocation dimID) {
    }

    @Override
    public boolean isWorldGenEnabled(IWorldGen.WorldGenType type, ServerWorld w) {
        return true;
    }

    @Override
    public void disableWorldGenForBiome(IWorldGen.WorldGenType type, ResourceLocation biomeId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(biomeId);
        this.settings.get((Object)((Object)type)).modBiomeBlacklist.add(biomeId);
    }

    @Override
    public boolean isWorldGenDisabledForBiome(IWorldGen.WorldGenType type, ResourceLocation biomeId) {
        TypeSet typeSettings = this.settings.get((Object)type);
        return typeSettings.configBiomeBlacklist.contains(biomeId) || typeSettings.modBiomeBlacklist.contains(biomeId);
    }

    public void setConfigBlacklists(List<ResourceLocation> quartzBiomeBlacklist, List<ResourceLocation> meteoriteBiomeBlacklist) {
        this.settings.get((Object)((Object)IWorldGen.WorldGenType.CERTUS_QUARTZ)).configBiomeBlacklist.clear();
        this.settings.get((Object)((Object)IWorldGen.WorldGenType.CERTUS_QUARTZ)).configBiomeBlacklist.addAll(quartzBiomeBlacklist);
        this.settings.get((Object)((Object)IWorldGen.WorldGenType.CHARGED_CERTUS_QUARTZ)).configBiomeBlacklist.clear();
        this.settings.get((Object)((Object)IWorldGen.WorldGenType.CHARGED_CERTUS_QUARTZ)).configBiomeBlacklist.addAll(quartzBiomeBlacklist);
        this.settings.get((Object)((Object)IWorldGen.WorldGenType.METEORITES)).configBiomeBlacklist.clear();
        this.settings.get((Object)((Object)IWorldGen.WorldGenType.METEORITES)).configBiomeBlacklist.addAll(meteoriteBiomeBlacklist);
    }

    private static class TypeSet {
        final Set<ResourceLocation> modBiomeBlacklist = new HashSet<ResourceLocation>();
        final Set<ResourceLocation> configBiomeBlacklist = new HashSet<ResourceLocation>();

        private TypeSet() {
        }
    }
}

