/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class InventoryActionPacket
extends BasePacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final ItemStack slotItem;

    public InventoryActionPacket(PacketBuffer stream) {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        this.slotItem = stream.func_150791_c();
    }

    public InventoryActionPacket(InventoryAction action, int slot, ItemStack slotItem) {
        if (Platform.isClient() && action != InventoryAction.SET_FILTER) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem.func_77946_l();
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        data.func_150788_a(this.slotItem);
        this.configureWrite(data);
    }

    public InventoryActionPacket(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.func_150788_a(ItemStack.field_190927_a);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        ServerPlayerEntity sender = (ServerPlayerEntity)player;
        if (sender.field_71070_bA instanceof AEBaseContainer) {
            AEBaseContainer baseContainer = (AEBaseContainer)sender.field_71070_bA;
            if (this.action == InventoryAction.SET_FILTER) {
                baseContainer.setFilter(this.slot, this.slotItem);
            } else {
                baseContainer.doAction(sender, this.action, this.slot, this.id);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            player.field_71071_by.func_70437_b(this.slotItem);
        }
    }
}

