/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.helper;

import appeng.core.Api;
import appeng.fluids.items.FluidDummyItem;
import appeng.items.contents.CellConfig;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidCellConfig
extends CellConfig {
    public FluidCellConfig(ItemStack is) {
        super(is);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        Optional fluidOpt;
        if (stack.func_190926_b() || stack.func_77973_b() instanceof FluidDummyItem) {
            super.insertItem(slot, stack, simulate);
        }
        if (!(fluidOpt = FluidUtil.getFluidContained((ItemStack)stack)).isPresent() || !Api.instance().definitions().items().dummyFluidItem().maybeStack(1).isPresent()) {
            return stack;
        }
        FluidStack fluid = fluidOpt.orElse(null);
        fluid.setAmount(1000);
        ItemStack is = Api.instance().definitions().items().dummyFluidItem().maybeStack(1).get();
        FluidDummyItem item = (FluidDummyItem)is.func_77973_b();
        item.setFluidStack(is, fluid);
        return super.insertItem(slot, is, simulate);
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        Optional fluidOpt;
        if (stack.func_190926_b() || stack.func_77973_b() instanceof FluidDummyItem) {
            super.setStackInSlot(slot, stack);
        }
        if (!(fluidOpt = FluidUtil.getFluidContained((ItemStack)stack)).isPresent() || !Api.instance().definitions().items().dummyFluidItem().maybeStack(1).isPresent()) {
            return;
        }
        FluidStack fluid = fluidOpt.orElse(null);
        fluid.setAmount(1000);
        ItemStack is = Api.instance().definitions().items().dummyFluidItem().maybeStack(1).get();
        FluidDummyItem item = (FluidDummyItem)is.func_77973_b();
        item.setFluidStack(is, fluid);
        super.setStackInSlot(slot, is);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        Optional fluidOpt;
        if (stack.func_190926_b() || stack.func_77973_b() instanceof FluidDummyItem) {
            super.isItemValid(slot, stack);
        }
        if (!(fluidOpt = FluidUtil.getFluidContained((ItemStack)stack)).isPresent() || !Api.instance().definitions().items().dummyFluidItem().maybeStack(1).isPresent()) {
            return false;
        }
        FluidStack fluid = fluidOpt.orElse(null);
        fluid.setAmount(1000);
        ItemStack is = Api.instance().definitions().items().dummyFluidItem().maybeStack(1).get();
        FluidDummyItem item = (FluidDummyItem)is.func_77973_b();
        item.setFluidStack(is, fluid);
        return super.isItemValid(slot, is);
    }
}

