/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.mixins.unlitquad.BakedQuadAccessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class UnlitQuadHooks {
    private static final int LIGHT_OFFSET = UnlitQuadHooks.getLightOffset();
    private static final int UNLIT_LIGHT_UV = LightTexture.func_228451_a_((int)15, (int)15);
    private static final ThreadLocal<Boolean> ENABLE_UNLIT_EXTENSIONS = new ThreadLocal();

    public static void beginDeserializingModel(ResourceLocation location) {
        String namespace = location.func_110624_b();
        if (namespace.equals("appliedenergistics2")) {
            ENABLE_UNLIT_EXTENSIONS.set(true);
        }
    }

    public static void endDeserializingModel() {
        ENABLE_UNLIT_EXTENSIONS.set(false);
    }

    public static boolean isUnlitExtensionEnabled() {
        Boolean b = ENABLE_UNLIT_EXTENSIONS.get();
        return b != null && b != false;
    }

    public static BlockPartFace enhanceModelElementFace(BlockPartFace modelElement, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (JSONUtils.func_151209_a((JsonObject)jsonObject, (String)"unlit", (boolean)false)) {
            return new UnlitBlockPartFace(modelElement.field_178244_b, modelElement.field_178245_c, modelElement.field_178242_d, modelElement.field_178243_e);
        }
        return modelElement;
    }

    public static BakedQuad makeUnlit(BakedQuad quad) {
        int[] vertexData = (int[])quad.func_178209_a().clone();
        int stride = DefaultVertexFormats.field_176600_a.func_181719_f();
        for (int i = 0; i < 4; ++i) {
            vertexData[stride * i + UnlitQuadHooks.LIGHT_OFFSET] = UNLIT_LIGHT_UV;
        }
        TextureAtlasSprite sprite = ((BakedQuadAccessor)quad).getSprite();
        return new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), sprite, false);
    }

    private static int getLightOffset() {
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        int offset = 0;
        for (VertexFormatElement element : format.func_227894_c_()) {
            if (element == DefaultVertexFormats.field_227848_e_) {
                if (element.func_177367_b() != VertexFormatElement.Type.SHORT) {
                    throw new UnsupportedOperationException("Expected light map format to be of type SHORT");
                }
                if (offset % 4 != 0) {
                    throw new UnsupportedOperationException("Expected light map offset to be 4-byte aligned");
                }
                return offset / 4;
            }
            offset += element.func_177368_f();
        }
        throw new UnsupportedOperationException("Failed to find the lightmap index in the block vertex format");
    }

    public static class UnlitBlockPartFace
    extends BlockPartFace {
        public UnlitBlockPartFace(Direction cullFaceIn, int tintIndexIn, String textureIn, BlockFaceUV blockFaceUVIn) {
            super(cullFaceIn, tintIndexIn, textureIn, blockFaceUVIn);
        }
    }
}

