/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.helpers;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MEMonitorHandler<T extends IAEStack<T>>
implements IMEMonitor<T> {
    private final IMEInventoryHandler<T> internalHandler;
    private final IItemList<T> cachedList;
    private final HashMap<IMEMonitorHandlerReceiver<T>, Object> listeners = new HashMap();
    protected boolean hasChanged = true;

    public MEMonitorHandler(IMEInventoryHandler<T> t) {
        this.internalHandler = t;
        this.cachedList = t.getChannel().createList();
    }

    public MEMonitorHandler(IMEInventoryHandler<T> t, IStorageChannel<T> chan) {
        this.internalHandler = t;
        this.cachedList = chan.createList();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<T> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<T> l) {
        this.listeners.remove(l);
    }

    @Override
    public T injectItems(T input, Actionable mode, IActionSource src) {
        if (mode == Actionable.SIMULATE) {
            return this.getHandler().injectItems(input, mode, src);
        }
        return this.monitorDifference(input.copy(), this.getHandler().injectItems(input, mode, src), false, src);
    }

    protected IMEInventoryHandler<T> getHandler() {
        return this.internalHandler;
    }

    private T monitorDifference(T original, T leftOvers, boolean extraction, IActionSource src) {
        Object diff = original.copy();
        if (extraction) {
            diff.setStackSize(leftOvers == null ? 0L : -leftOvers.getStackSize());
        } else if (leftOvers != null) {
            diff.decStackSize(leftOvers.getStackSize());
        }
        if (diff.getStackSize() != 0L) {
            this.postChangesToListeners((Iterable<T>)ImmutableList.of(diff), src);
        }
        return leftOvers;
    }

    protected void postChangesToListeners(Iterable<T> changes, IActionSource src) {
        this.notifyListenersOfChange(changes, src);
    }

    protected void notifyListenersOfChange(Iterable<T> diff, IActionSource src) {
        this.hasChanged = true;
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> i = this.getListeners();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<T>, Object> o = i.next();
            IMEMonitorHandlerReceiver<T> receiver = o.getKey();
            if (receiver.isValid(o.getValue())) {
                receiver.postChange(this, diff, src);
                continue;
            }
            i.remove();
        }
    }

    protected Iterator<Map.Entry<IMEMonitorHandlerReceiver<T>, Object>> getListeners() {
        return this.listeners.entrySet().iterator();
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        if (mode == Actionable.SIMULATE) {
            return this.getHandler().extractItems(request, mode, src);
        }
        return this.monitorDifference(request.copy(), this.getHandler().extractItems(request, mode, src), true, src);
    }

    @Override
    public IStorageChannel<T> getChannel() {
        return this.getHandler().getChannel();
    }

    @Override
    public AccessRestriction getAccess() {
        return this.getHandler().getAccess();
    }

    @Override
    public IItemList<T> getStorageList() {
        if (this.hasChanged) {
            this.hasChanged = false;
            this.cachedList.resetStatus();
            return this.getAvailableItems(this.cachedList);
        }
        return this.cachedList;
    }

    @Override
    public boolean isPrioritized(T input) {
        return this.getHandler().isPrioritized(input);
    }

    @Override
    public boolean canAccept(T input) {
        return this.getHandler().canAccept(input);
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return this.getHandler().getAvailableItems(out);
    }

    @Override
    public int getPriority() {
        return this.getHandler().getPriority();
    }

    @Override
    public int getSlot() {
        return this.getHandler().getSlot();
    }

    @Override
    public boolean validForPass(int i) {
        return this.getHandler().validForPass(i);
    }
}

