/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.block.networking.ControllerBlock;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTileEntity;
import appeng.util.inv.InvOperation;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ControllerTileEntity
extends AENetworkPowerTileEntity {
    private boolean isValid = false;

    public ControllerTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setInternalMaxPower(8000.0);
        this.setInternalPublicPowerStorage(true);
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY, GridFlags.DENSE_CAPACITY);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    @Override
    public void onReady() {
        this.onNeighborChange(true);
        super.onReady();
    }

    public void onNeighborChange(boolean force) {
        boolean xx = this.checkController(this.field_174879_c.func_177972_a(Direction.EAST)) && this.checkController(this.field_174879_c.func_177972_a(Direction.WEST));
        boolean yy = this.checkController(this.field_174879_c.func_177972_a(Direction.UP)) && this.checkController(this.field_174879_c.func_177972_a(Direction.DOWN));
        boolean zz = this.checkController(this.field_174879_c.func_177972_a(Direction.NORTH)) && this.checkController(this.field_174879_c.func_177972_a(Direction.SOUTH));
        boolean oldValid = this.isValid;
        boolean bl = xx && !yy && !zz || !xx && yy && !zz || !xx && !yy && zz || (xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) <= 1 ? true : (this.isValid = false);
        if (oldValid != this.isValid || force) {
            if (this.isValid) {
                this.getProxy().setValidSides(EnumSet.allOf(Direction.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
            }
            this.updateMeta();
        }
    }

    private void updateMeta() {
        if (!this.getProxy().isReady()) {
            return;
        }
        ControllerBlock.ControllerBlockState metaState = ControllerBlock.ControllerBlockState.offline;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                metaState = ControllerBlock.ControllerBlockState.online;
                if (this.getProxy().getPath().getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    metaState = ControllerBlock.ControllerBlockState.conflicted;
                }
            }
        }
        catch (GridAccessException e) {
            metaState = ControllerBlock.ControllerBlockState.offline;
        }
        if (this.checkController(this.field_174879_c) && this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(ControllerBlock.CONTROLLER_STATE) != metaState) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(ControllerBlock.CONTROLLER_STATE, (Comparable)((Object)metaState)));
        }
    }

    @Override
    protected double getFunnelPowerDemand(double maxReceived) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            return grid.getEnergyDemand(maxReceived);
        }
        catch (GridAccessException e) {
            return super.getFunnelPowerDemand(maxReceived);
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double leftOver = grid.injectPower(power, mode);
            return leftOver;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(power, mode);
        }
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        try {
            this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, x));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onControllerChange(MENetworkControllerChange status) {
        this.updateMeta();
    }

    @MENetworkEventSubscribe
    public void onPowerChange(MENetworkPowerStatusChange status) {
        this.updateMeta();
    }

    @Override
    public IItemHandler getInternalInventory() {
        return EmptyHandler.INSTANCE;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    private boolean checkController(BlockPos pos) {
        if (this.field_145850_b.func_72863_F().func_222866_a(pos)) {
            return this.field_145850_b.func_175625_s(pos) instanceof ControllerTileEntity;
        }
        return false;
    }
}

