/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.lib.entity.AbstractMinecartEntityCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.locomotion.init.TLocReferences;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class UnderwaterMinecartEntity
extends AbstractMinecartEntityCoFH {
    public static final int AIR_SUPPLY_MAX = 4800;
    protected int airSupply = 4800;
    protected int respirationFactor = 1;

    public UnderwaterMinecartEntity(EntityType<? extends UnderwaterMinecartEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public UnderwaterMinecartEntity(World worldIn, double posX, double posY, double posZ) {
        super(TLocReferences.UNDERWATER_CART_ENTITY, worldIn, posX, posY, posZ);
    }

    public UnderwaterMinecartEntity setEnchantments(ListNBT enchantments) {
        super.setEnchantments(enchantments);
        Map enchantMap = EnchantmentHelper.func_226652_a_((ListNBT)enchantments);
        if (enchantMap.containsKey(Enchantments.field_185298_f)) {
            int encRespiration = (Integer)enchantMap.get(Enchantments.field_185298_f);
            this.respirationFactor = Math.max(1, encRespiration + 1);
        }
        return this;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            if (!this.field_70171_ac) {
                this.airSupply = Math.min(this.airSupply + 40, 4800);
            } else {
                List passengers = this.func_184188_bt();
                if (!passengers.isEmpty() && this.airSupply > 0) {
                    passengers.forEach(e -> {
                        if (e.func_70086_ai() < e.func_205010_bg()) {
                            e.func_70050_g(e.func_70086_ai() + 1);
                            if (this.field_70146_Z.nextInt(this.respirationFactor) <= 0) {
                                --this.airSupply;
                            }
                        }
                    });
                }
            }
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.respirationFactor = compound.func_74762_e("CartData");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("CartData", this.respirationFactor);
    }

    protected boolean func_233566_aG_() {
        if (this.func_184187_bx() instanceof BoatEntity) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b((ITag)FluidTags.field_206959_a, 0.014)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType ret = super.func_184230_a(player, hand);
        if (ret.func_226246_a_()) {
            return ret;
        }
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.func_184207_aI()) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
        if (receivingPower) {
            if (this.func_184207_aI()) {
                this.func_184226_ay();
            }
            if (this.func_70496_j() == 0) {
                this.func_70494_i(-this.func_70493_k());
                this.func_70497_h(10);
                this.func_70492_c(50.0f);
                this.func_70018_K();
            }
        }
    }

    public ItemStack getCartItem() {
        return new ItemStack((IItemProvider)TLocReferences.UNDERWATER_CART_ITEM);
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.RIDEABLE;
    }
}

