/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells.boundary;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.TangibleBoundaryMahoujinTileEntity;

public class InvisibleBarrierBlock
extends BlockTileEntity<InvisibleBarrierBlockTileEntity> {
    AxisAlignedBB collisionCaster = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    VoxelShape castershape = VoxelShapes.func_197881_a((AxisAlignedBB)this.collisionCaster);
    AxisAlignedBB collisionElse = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    VoxelShape elseshape = VoxelShapes.func_197881_a((AxisAlignedBB)this.collisionElse);

    public InvisibleBarrierBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_226896_b_().func_200948_a(5.0f, 10.0f), "invisible_barrier_block");
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return new ArrayList<ItemStack>();
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult result, ProjectileEntity entityIn) {
        this.func_196262_a(state, worldIn, result.func_216350_a(), (Entity)entityIn);
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.INVISIBLE;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn != null && entityIn.func_70089_S()) {
            UUID entUUID = entityIn.func_110124_au();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)worldIn.func_175625_s(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID)) {
                    return;
                }
                Direction side = Direction.NORTH;
                if (entityIn.func_226277_ct_() < (double)pos.func_177958_n()) {
                    side = Direction.WEST;
                } else if (entityIn.func_226277_ct_() > (double)(pos.func_177958_n() + 1)) {
                    side = Direction.EAST;
                } else if (entityIn.func_226278_cu_() < (double)pos.func_177956_o()) {
                    side = Direction.DOWN;
                } else if (entityIn.func_226278_cu_() > (double)(pos.func_177956_o() + 1)) {
                    side = Direction.UP;
                } else if (entityIn.func_226281_cx_() < (double)pos.func_177952_p()) {
                    side = Direction.NORTH;
                } else if (entityIn.func_226281_cx_() > (double)(pos.func_177952_p() + 1)) {
                    side = Direction.SOUTH;
                }
                te.setTimeOfCollision(worldIn.func_82737_E(), side);
            }
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Entity e = context.getEntity();
        if (context instanceof EntitySelectionContext && e != null && e.func_70089_S()) {
            UUID entUUID = e.func_110124_au();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)reader.func_175625_s(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (!(te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID))) {
                    return this.elseshape;
                }
            }
        }
        return this.castershape;
    }

    public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    public boolean func_149653_t(BlockState p_149653_1_) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        TileEntity te;
        if (world.func_82737_E() % 100L == 0L && (te = world.func_175625_s(pos)) instanceof InvisibleBarrierBlockTileEntity) {
            try {
                TileEntity tte = world.func_175625_s(((InvisibleBarrierBlockTileEntity)te).boundaryCircle);
                if (tte instanceof TangibleBoundaryMahoujinTileEntity) {
                    int radius;
                    TangibleBoundaryMahoujinTileEntity mte = (TangibleBoundaryMahoujinTileEntity)tte;
                    if (!mte.shouldIPerformBarrier()) {
                        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                    if ((radius = mte.getBarrierRadius()) != Math.abs(pos.func_177958_n() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.func_177958_n()) || radius != Math.abs(pos.func_177956_o() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.func_177956_o()) || radius != Math.abs(pos.func_177952_p() - ((InvisibleBarrierBlockTileEntity)te).boundaryCircle.func_177952_p())) {
                        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                } else {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            }
            catch (Exception e) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    @Override
    public Class<InvisibleBarrierBlockTileEntity> getTileEntityClass() {
        return InvisibleBarrierBlockTileEntity.class;
    }

    @Override
    @Nullable
    public InvisibleBarrierBlockTileEntity createTileEntity(BlockState state, IBlockReader reader) {
        return new InvisibleBarrierBlockTileEntity();
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return this.castershape;
    }

    public boolean func_208619_r() {
        return true;
    }
}

