/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class LightningEntity
extends Entity {
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_TARGET = "MAHOUTSUKAI_TARGET";
    private static final String TAG_HAS_BALL = "MAHOUTSUKAI_HAS_BALL";
    private static final String TAG_ZAP = "MAHOUTSUKAI_ZAP";
    public boolean rolled = false;
    private static final DataParameter<Float> BEAM_SIZE = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CASTER_ID = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_BALL = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ZAP = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public LivingEntity target;
    public LivingEntity caster;
    public double prev_x;
    public double prev_y;
    public double prev_z;
    public float[] segmentlengths;
    public float[] offshootlengths;
    public float[] pitchs;
    public float[] reallengths;
    public float[] prevpitchs;
    public float[] prevreallengths;
    public int segments = 0;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public static final String entityName = "lightning_entity";

    public LightningEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public LightningEntity(World world) {
        super(ModEntities.LIGHTNING, world);
        this.field_70158_ak = true;
    }

    public LightningEntity(World world, LivingEntity caster, LivingEntity target, float r, float g, float b, float a, float size, boolean zap) {
        this(world);
        this.setColor(r, g, b, a);
        this.sizer(size);
        this.caster = caster;
        this.target = target;
        this.field_70180_af.func_187227_b(TARGET_ID, (Object)target.func_145782_y());
        this.field_70180_af.func_187227_b(CASTER_ID, (Object)caster.func_145782_y());
        this.setZap(zap);
        this.setLookPos(world.field_72995_K);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CASTER_ID, (Object)-1);
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)-1);
        this.field_70180_af.func_187214_a(HAS_BALL, (Object)false);
        this.field_70180_af.func_187214_a(ZAP, (Object)false);
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void func_70071_h_() {
        if (this.caster != null && this.target != null) {
            Vector3d targeteye = this.target.func_174824_e(1.0f).func_72441_c(0.0, this.getZap() ? (double)(-this.target.func_213302_cg() / 2.0f) : 0.0, 0.0);
            Vector3d start = this.setLookPos(this.field_70170_p.field_72995_K);
            if (!this.field_70170_p.field_72995_K) {
                if (!this.target.func_70089_S() || !this.caster.func_70089_S()) {
                    this.func_70106_y();
                } else {
                    if (targeteye.func_178788_d(start).func_72433_c() > (double)(MTConfig.EMRYS_MAX_RANGE * 2) || !this.getZap() && this.caster.func_184607_cu().func_77973_b() != ModItems.emrysStaff) {
                        this.func_70106_y();
                    } else if (!this.getZap() && this.field_70170_p.func_82737_E() % 20L == 0L) {
                        this.target.func_70097_a(DamageSource.field_180137_b, (float)MTConfig.EMRYS_DAMAGE_FOCUSED_PER_SECOND);
                        this.target.field_70718_bc = 100;
                        if (this.caster instanceof PlayerEntity) {
                            StaffEmrys.zap(this.target, false, (PlayerEntity)this.caster);
                        }
                    }
                    if (this.getZap() && this.field_70173_aa > 8) {
                        EffectUtil.magicAttack(this.target, (float)MTConfig.EMRYS_DAMAGE_ZAP);
                        EffectUtil.buff(this.target, ModEffects.ZAP_COOLDOWN, false, 60);
                        StaffEmrys.zap(this.target, false, null);
                        this.func_70106_y();
                    }
                }
            } else {
                this.prev_x = this.func_226277_ct_();
                this.prev_y = this.func_226278_cu_();
                this.prev_z = this.func_226281_cx_();
                Vector3d v2 = targeteye.func_178788_d(start);
                Vector3d v = v2.func_72432_b();
                this.pitch = 90.0f - EffectUtil.toDegrees((float)Math.asin(-v.field_72448_b));
                this.yaw = 180.0f + EffectUtil.toDegrees((float)Math.atan2(v.field_72450_a, v.field_72449_c));
                float len = (float)v2.func_72433_c();
                if (!this.rolled) {
                    this.rerollLightningShape(len);
                }
                if (this.segments > 0) {
                    this.copyPrevSegments();
                    this.randomLightningMovement();
                    this.shrink();
                    this.correct(len);
                    this.calculateLightningAnglesAndLengths();
                }
            }
        } else if (this.field_70170_p.field_72995_K) {
            Entity t = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ID)).intValue());
            Entity c = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(CASTER_ID)).intValue());
            if (t instanceof LivingEntity) {
                this.target = (LivingEntity)t;
            }
            if (c instanceof LivingEntity) {
                this.caster = (LivingEntity)c;
            }
        }
    }

    public void randomLightningMovement() {
        float sidegrowth = 1.0f / (float)this.segments;
        int i = 0;
        while (i < this.offshootlengths.length - 2) {
            int n = i;
            this.offshootlengths[n] = this.offshootlengths[n] + this.field_70146_Z.nextFloat() * sidegrowth;
            int n2 = i++;
            this.offshootlengths[n2] = this.offshootlengths[n2] % 0.4f;
        }
        i = 0;
        while (i < this.segmentlengths.length - 1) {
            int n = i++;
            this.segmentlengths[n] = this.segmentlengths[n] + Math.max(0.0f, this.field_70146_Z.nextFloat() * sidegrowth * 3.0f - sidegrowth / 1.5f);
        }
    }

    public void shrink() {
        if (this.segmentlengths[this.segmentlengths.length - 1] < 0.7f) {
            if (this.offshootlengths[this.offshootlengths.length - 2] < 0.7f) {
                int i;
                for (i = this.segmentlengths.length - 1; i > 0; --i) {
                    this.segmentlengths[i] = this.segmentlengths[i - 1];
                }
                this.segmentlengths[0] = 1.0E-4f;
                for (i = this.offshootlengths.length - 2; i > 0; --i) {
                    this.offshootlengths[i] = this.offshootlengths[i - 1];
                }
                this.offshootlengths[0] = 1.0E-4f;
            } else {
                int n = this.offshootlengths.length - 2;
                this.offshootlengths[n] = this.offshootlengths[n] - (0.1f + this.field_70146_Z.nextFloat() * 0.1f);
            }
        }
    }

    public void correct(float totallen) {
        float t;
        float z = 0.0f;
        for (int i = 0; i < this.segmentlengths.length; ++i) {
            z += this.segmentlengths[i];
        }
        float overflow = z - totallen;
        for (int i = this.segmentlengths.length - 1; i >= 0 && overflow > 0.0f; overflow -= t, --i) {
            t = this.segmentlengths[i];
            this.segmentlengths[i] = t > overflow ? t - overflow : 0.0f;
        }
    }

    public void copyPrevSegments() {
        int i;
        this.prevpitchs = new float[this.pitchs.length];
        for (i = 0; i < this.prevpitchs.length; ++i) {
            this.prevpitchs[i] = this.pitchs[i];
        }
        this.prevreallengths = new float[this.reallengths.length];
        for (i = 0; i < this.prevreallengths.length; ++i) {
            this.prevreallengths[i] = this.reallengths[i];
        }
    }

    public Vector3d setLookPos(boolean client) {
        Vector3d look = this.caster.func_70676_i(1.0f);
        Vector3d oldlook = look.func_72432_b();
        look = oldlook.func_186678_a((double)1.9f);
        look = look.func_178787_e(oldlook.func_178785_b(EffectUtil.toRad(-90.0f)).func_186678_a((double)0.3f)).func_178787_e(oldlook.func_178789_a(EffectUtil.toRad(-90.0f)).func_186678_a((double)0.3f));
        if (this.getZap()) {
            look = new Vector3d(0.0, (double)(-this.caster.func_213302_cg() / 2.0f), 0.0);
        }
        Vector3d start = look.func_178787_e(this.caster.func_174824_e(1.0f));
        if (!client) {
            this.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        }
        return start;
    }

    public void rerollLightningShape(float totalLenToTarget) {
        float remaining = totalLenToTarget;
        this.segments = this.field_70146_Z.nextInt(4) + 6;
        this.segmentlengths = new float[this.segments];
        this.offshootlengths = new float[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            this.segmentlengths[i] = i == this.segments - 1 ? remaining : this.field_70146_Z.nextFloat() * remaining * 1.0f / (float)this.segments;
            this.offshootlengths[i] = this.field_70146_Z.nextFloat() * (this.getZap() ? 0.9f : 1.5f);
            remaining -= this.segmentlengths[i];
        }
        this.offshootlengths[this.segments - 1] = 0.0f;
        this.calculateLightningAnglesAndLengths();
        this.rolled = true;
    }

    public void calculateLightningAnglesAndLengths() {
        this.pitchs = new float[this.segments];
        this.reallengths = new float[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            float c;
            float prevb = i == 0 ? 0.0f : this.offshootlengths[i - 1];
            float a = this.segmentlengths[i];
            float b = this.offshootlengths[i] - prevb;
            this.reallengths[i] = c = (float)Math.sqrt(a * a + b * b);
            this.pitchs[i] = EffectUtil.toDegrees((float)Math.asin(b / c));
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void func_145775_I() {
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setBeamSize(s);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setBeamSize(compound.func_74760_g(TAG_BEAM_SIZE));
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
        this.setHasBall(compound.func_74767_n(TAG_HAS_BALL));
        this.setTargetId(compound.func_74762_e(TAG_TARGET));
        this.setCasterId(compound.func_74762_e(TAG_CASTER));
        this.setZap(compound.func_74767_n(TAG_ZAP));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        compound.func_74757_a(TAG_HAS_BALL, ((Boolean)this.field_70180_af.func_187225_a(HAS_BALL)).booleanValue());
        if (this.caster != null) {
            compound.func_74776_a(TAG_CASTER, (float)this.getCasterId());
        }
        if (this.target != null) {
            compound.func_74776_a(TAG_TARGET, (float)this.getTargetId());
        }
        compound.func_74757_a(TAG_ZAP, this.getZap());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getBeamSize() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float s) {
        this.field_70180_af.func_187227_b(BEAM_SIZE, (Object)Float.valueOf(s));
    }

    public boolean getHasBall() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BALL);
    }

    public void setHasBall(boolean s) {
        this.field_70180_af.func_187227_b(HAS_BALL, (Object)s);
    }

    public boolean getZap() {
        return (Boolean)this.field_70180_af.func_187225_a(ZAP);
    }

    public void setZap(boolean s) {
        this.field_70180_af.func_187227_b(ZAP, (Object)s);
    }

    public int getTargetId() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ID);
    }

    public void setTargetId(int id) {
        this.field_70180_af.func_187227_b(TARGET_ID, (Object)id);
    }

    public int getCasterId() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ID);
    }

    public void setCasterId(int id) {
        this.field_70180_af.func_187227_b(CASTER_ID, (Object)id);
    }
}

