/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BeamPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaffBeamMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_SPHERE_SIZE = "MAHOUTSUKAI_SPHERE_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_DYING = "MAHOUTSUKAI_DYING";
    public float prev_beam_size;
    public float prev_beam_len;
    public float prev_sphere_size;
    public float prev_mini_roll;
    public static int dyingticks = 6;
    public double prevx;
    public double prevy;
    public double prevz;
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB bb = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final DataParameter<Float> ROTATION_YAW = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_ROLL = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_PITCH = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_SPEED = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CIRCLE_SIZE = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BEAM_SIZE = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BEAM_LENGTH = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SPHERE_SIZE = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> CASTER = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> DYING = EntityDataManager.func_187226_a(MysticStaffBeamMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String entityName = "mahoujin_beam_entity";
    PlayerEntity caster = null;

    public MysticStaffBeamMahoujinEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.BEAM_MAHOUJIN, worldIn);
        this.field_70158_ak = true;
    }

    public MysticStaffBeamMahoujinEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public MysticStaffBeamMahoujinEntity(World world) {
        super(ModEntities.BEAM_MAHOUJIN, world);
        this.field_70158_ak = true;
    }

    public MysticStaffBeamMahoujinEntity(World world, PlayerEntity caster, float r, float g, float b) {
        this(world);
        this.caster = caster;
        this.setCaster(caster.func_110124_au());
        this.setColor(r, g, b, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPHERE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CASTER, Optional.of(UUID.randomUUID()));
        this.field_70180_af.func_187214_a(DYING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70126_B = this.field_70177_z;
        boolean circle_size_min_time = false;
        int circle_size_max_time = 15;
        int mini_speed_min_time = 15;
        int mini_speed_max_time = 35;
        int sphere_size_min_time = 25;
        int sphere_size_max_time = 35;
        int beam_size_min_time = 40;
        int beam_size_max_time = 45;
        int beam_len_min_time = 40;
        int beam_len_max_time = 45;
        float goal_circle_size = 1.5f;
        float goal_mini_speed = 6.0f;
        float goal_beam_size = 0.7f;
        float goal_beam_len = 64.0f;
        float goal_sphere_size = 0.7f;
        this.prev_beam_size = this.getBeamSize();
        this.prev_beam_len = this.getBeamLength();
        this.prev_sphere_size = this.getSphereSize();
        this.prev_mini_roll = this.getRotationRoll();
        if (this.getLife() == sphere_size_min_time - 3 && !this.field_70170_p.field_72995_K) {
            for (ServerPlayerEntity p : ((ServerWorld)this.field_70170_p).func_217369_A()) {
                if (p.field_70170_p != this.field_70170_p) continue;
                PacketHandler.sendTo(p, new BeamPacket(this.func_145782_y()));
            }
        }
        if (this.getCaster() != null && this.caster == null) {
            this.caster = this.field_70170_p.func_217371_b(this.getCaster());
        }
        if (this.caster != null && this.getDying() <= 0) {
            this.casterPosition(false);
            if (!(this.caster.func_184607_cu().func_77973_b() instanceof MysticStaff)) {
                this.setDying(1);
                MahouTsukaiMod.proxy.speedUp();
            }
            if (this.getLife() == beam_len_min_time + 1) {
                this.boopCaster();
                if (this.caster instanceof ServerPlayerEntity) {
                    ModTriggers.BEAM.trigger((ServerPlayerEntity)this.caster);
                }
            } else if (this.getLife() < beam_len_min_time + 1 || this.getLife() > beam_len_max_time + 4) {
                this.holdCaster();
            }
        } else if (this.getDying() <= 0) {
            this.setDying(1);
        }
        int life = this.getLife();
        this.setCircleSize(goal_circle_size);
        if (this.getDying() <= 0) {
            this.setRotationSpeed(life < mini_speed_min_time ? 0.0f : (life > mini_speed_max_time ? goal_mini_speed : goal_mini_speed * ((float)life - (float)mini_speed_min_time) / ((float)mini_speed_max_time - (float)mini_speed_min_time)));
            this.setBeamSize(life < beam_size_min_time ? 0.0f : (life > beam_size_max_time ? goal_beam_size : goal_beam_size * ((float)life - (float)beam_size_max_time) / ((float)beam_size_max_time - (float)beam_size_min_time)));
            this.setSphereSize(life < sphere_size_min_time ? 0.0f : (life > sphere_size_max_time ? goal_sphere_size : goal_sphere_size * ((float)life - (float)sphere_size_min_time) / ((float)sphere_size_max_time - (float)sphere_size_min_time)));
            this.setBeamLength(life < beam_len_min_time ? 0.0f : (life > beam_len_max_time ? goal_beam_len : goal_beam_len * ((float)life - (float)beam_len_min_time) / ((float)beam_len_max_time - (float)beam_len_min_time)));
            this.setRotationSpeed(Math.max(this.getRotationSpeed(), 0.0f));
            this.setBeamSize(Math.max(this.getBeamSize(), 0.0f));
            this.setSphereSize(Math.max(this.getSphereSize(), 0.0f));
            this.setBeamLength(Math.max(this.getBeamLength(), 0.0f));
        } else {
            float factor = ((float)dyingticks - 1.0f) / (float)dyingticks;
            this.setRotationSpeed(factor * this.getRotationSpeed());
            this.setBeamSize(factor * this.getBeamSize());
            this.setSphereSize(factor * this.getSphereSize());
            if (this.getDying() > dyingticks * 3) {
                this.func_70106_y();
            }
            this.setDying(this.getDying() + 1);
        }
        this.setRotationYaw(this.getRotationYaw() % 360.0f);
        if (this.getRotationYaw() < 0.0f) {
            this.setRotationYaw(this.getRotationYaw() + 360.0f);
        }
        if (this.getRotationYaw() > 360.0f) {
            this.setRotationYaw(this.getRotationYaw() - 360.0f);
        }
        this.setLife(this.getLife() + 1);
        this.setRotationRoll(this.getRotationRoll() + this.getRotationSpeed());
        if (!this.field_70170_p.field_72995_K && this.getDying() <= 0 && this.getLife() > beam_len_min_time) {
            this.bakuretsu(beam_len_min_time);
        }
    }

    public void holdCaster() {
        this.caster.func_213293_j(0.0, 0.0, 0.0);
        this.caster.field_70133_I = true;
    }

    public void boopCaster() {
        double strength = 0.03;
        this.caster.field_70160_al = true;
        Vector3d v = this.caster.func_70040_Z();
        float f = MathHelper.func_76133_a((double)(v.field_72450_a * v.field_72450_a + v.field_72449_c * v.field_72449_c + v.field_72448_b * v.field_72448_b));
        double motionX = 0.0;
        double motionZ = 0.0;
        double motionY = 0.0;
        motionX -= v.field_72450_a / (double)f * strength;
        motionZ -= v.field_72449_c / (double)f * strength;
        motionY -= v.field_72448_b / (double)f * strength;
        if (this.caster.func_233570_aj_()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.1) {
                motionY = 0.1;
            }
        }
        this.caster.func_213293_j(motionX, motionY, motionZ);
        this.caster.field_70133_I = true;
    }

    public void bakuretsu(int beam_start) {
        IMahou mahou;
        int mana = MTConfig.MYSTIC_STAFF_BEAM_MANA_PER_TICK;
        int seconds = (this.getLife() - beam_start) / 20;
        double damage = MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_FACTOR;
        if (MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_SCALES && (mahou = Utils.getPlayerMahou((LivingEntity)this.caster)) != null) {
            damage *= (double)mahou.getMaxMana();
        }
        for (int i = 0; i < seconds; ++i) {
            damage *= MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_ACCELERATION;
        }
        if (PlayerManaManager.drainMana(this.caster, mana, false, false) == mana) {
            HashSet<BlockPos> blocks = new HashSet<BlockPos>();
            int blockspertick = MTConfig.MYSTIC_STAFF_BEAM_MAX_BLOCK_BREAK_PER_TICK;
            float pt = this.getRotationPitch();
            float yw = this.getRotationYaw();
            Vector3d direction = Vector3d.func_189986_a((float)(90.0f - pt), (float)(360.0f - yw + 180.0f)).func_72432_b();
            Vector3d pos = this.func_213303_ch();
            boolean keepbreaking = true;
            for (float i = 0.0f; i < this.getBeamLength(); i += 1.0f) {
                Vector3d diskcenter = pos.func_178787_e(direction.func_186678_a((double)i));
                AxisAlignedBB aabb = new AxisAlignedBB(new BlockPos(diskcenter).func_177982_a(-2, -2, -2), new BlockPos(diskcenter).func_177982_a(2, 2, 2));
                for (Entity e : this.field_70170_p.func_175674_a(null, aabb, null)) {
                    if (e == this.caster || e instanceof MysticStaffBeamMahoujinEntity || !(e instanceof LivingEntity) || ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCaster(), e)) continue;
                    EffectUtil.magicAttack((LivingEntity)e, (float)damage);
                }
                if (blocks.size() >= blockspertick) {
                    keepbreaking = false;
                }
                if (!keepbreaking) continue;
                for (int j = -3; j <= 3; ++j) {
                    for (int k = -3; k <= 3; ++k) {
                        for (int m = -3; m <= 3; ++m) {
                            BlockState bs;
                            BlockPos p = new BlockPos((double)j + diskcenter.field_72450_a, (double)k + diskcenter.field_72448_b, (double)m + diskcenter.field_72449_c);
                            if (!(p.func_218140_a(diskcenter.field_72450_a, diskcenter.field_72448_b, diskcenter.field_72449_c, true) <= 7.0) || (bs = this.field_70170_p.func_180495_p(p)).func_177230_c().isAir(bs, (IBlockReader)this.field_70170_p, p)) continue;
                            blocks.add(p);
                        }
                    }
                }
            }
            EffectUtil.tryFakeExplosion(new ArrayList<BlockPos>(blocks), this.caster, "mahou_beam", false);
        } else {
            this.setDying(1);
        }
    }

    public void casterPosition(boolean casterpos) {
        this.prevx = this.func_226277_ct_();
        this.prevy = this.func_226278_cu_();
        this.prevz = this.func_226281_cx_();
        this.field_70127_C = this.getRotationPitch();
        this.field_70126_B = this.getRotationYaw();
        this.setRotationPitch(90.0f - this.caster.field_70125_A);
        this.setRotationYaw(360.0f - this.caster.field_70177_z + 180.0f);
        this.field_70177_z = this.getRotationYaw();
        this.field_70125_A = this.getRotationPitch();
        if (casterpos) {
            Vector3d v = this.caster.func_70040_Z().func_186678_a((double)1.4f).func_178787_e(this.caster.func_174824_e(1.0f));
            this.func_70107_b(v.field_72450_a, v.field_72448_b, v.field_72449_c);
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setRotationYaw(compound.func_74760_g(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.func_74760_g(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.func_74760_g(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.func_74760_g("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.func_74760_g("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setBeamSize(compound.func_74760_g(TAG_BEAM_SIZE));
        this.setBeamLength(compound.func_74760_g(TAG_BEAM_LENGTH));
        this.setCaster(compound.func_186857_a(TAG_CASTER));
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
        this.setDying(compound.func_74762_e(TAG_DYING));
        this.setSphereSize(compound.func_74760_g(TAG_SPHERE_SIZE));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.func_74776_a(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.func_74776_a(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.func_74776_a("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.func_74776_a("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_186854_a(TAG_CASTER, this.getCaster());
        compound.func_74776_a(TAG_BEAM_LENGTH, this.getBeamLength());
        compound.func_74776_a(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[0]);
        compound.func_74776_a(TAG_COLOR_B, colors[0]);
        compound.func_74776_a(TAG_COLOR_A, colors[0]);
        compound.func_74776_a(TAG_SPHERE_SIZE, this.getSphereSize());
        compound.func_74768_a(TAG_DYING, this.getDying());
    }

    protected void func_145775_I() {
    }

    @Nullable
    public AxisAlignedBB func_174813_aQ() {
        return ZERO_AABB;
    }

    public void func_70108_f(Entity p_70108_1_) {
    }

    public AxisAlignedBB func_184177_bl() {
        return ZERO_AABB;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getRotationYaw() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.field_70180_af.func_187227_b(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.field_70180_af.func_187227_b(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.field_70180_af.func_187227_b(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.field_70180_af.func_187227_b(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.field_70180_af.func_187225_a(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.field_70180_af.func_187227_b(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public float getBeamSize() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.field_70180_af.func_187227_b(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public float getBeamLength() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float b) {
        this.field_70180_af.func_187227_b(BEAM_LENGTH, (Object)Float.valueOf(b));
    }

    public UUID getCaster() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER)).orElse(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER, Optional.of(uuid));
    }

    public int getDying() {
        return (Integer)this.field_70180_af.func_187225_a(DYING);
    }

    public void setDying(int d) {
        this.field_70180_af.func_187227_b(DYING, (Object)d);
    }

    public float getSphereSize() {
        return ((Float)this.field_70180_af.func_187225_a(SPHERE_SIZE)).floatValue();
    }

    public void setSphereSize(float d) {
        this.field_70180_af.func_187227_b(SPHERE_SIZE, (Object)Float.valueOf(d));
    }
}

