/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaffMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_BEAM = "MAHOUTSUKAI_BEAM";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    private static final String TAG_BEAM_OFFSET = "MAHOUTSUKAI_BEAM_OFFSET";
    private static final String TAG_SHOOTING_TICKS = "MAHOUTSUKAI_SHOOTING_TICKS";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final int loadUpTime = 20;
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final DataParameter<Float> ROTATION_YAW = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_ROLL = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_PITCH = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_SPEED = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CIRCLE_SIZE = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BEAM_SIZE = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> BEAM = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> BEAM_LENGTH = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BEAM_OFFSET = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SHOOTING_TICKS = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DISTANCE = EntityDataManager.func_187226_a(MysticStaffMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    Vector3d target;
    public UUID casterUUID = null;
    public static final String entityName = "mahoujin_entity";

    public MysticStaffMahoujinEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.EXPLOSION_MAHOUJIN, worldIn);
        this.field_70158_ak = true;
    }

    public MysticStaffMahoujinEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public MysticStaffMahoujinEntity(World world) {
        super(ModEntities.EXPLOSION_MAHOUJIN, world);
        this.field_70158_ak = true;
    }

    public MysticStaffMahoujinEntity(World world, PlayerEntity caster) {
        this(world);
        this.casterUUID = caster.func_110124_au();
    }

    public MysticStaffMahoujinEntity(World world, PlayerEntity caster, boolean hasBeam, float r, float g, float b, float a) {
        this(world);
        this.casterUUID = caster.func_110124_au();
        this.setHasBeam(hasBeam);
        this.setColor(r, g, b, a);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(BEAM, (Object)false);
        this.field_70180_af.func_187214_a(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BEAM_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SHOOTING_TICKS, (Object)-1);
        this.field_70180_af.func_187214_a(DISTANCE, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(0.0, 0.0, 0.0);
        if (this.getLife() < 20) {
            this.setLife(this.getLife() + 1);
        }
        this.field_70126_B = this.field_70177_z;
        if (this.field_70126_B < 0.0f) {
            this.field_70126_B += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.field_70177_z = this.getRotationYaw();
        this.field_70125_A = this.getRotationPitch();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (!this.field_70170_p.field_72995_K) {
            if (this.casterUUID == null) {
                this.func_70106_y();
            } else {
                PlayerEntity caster = this.field_70170_p.func_217371_b(this.casterUUID);
                if (caster == null || !caster.func_70089_S()) {
                    this.func_70106_y();
                } else {
                    if (!(caster.func_184607_cu().func_77973_b() instanceof MysticStaff && this.getShootingTicks() < 0 || this.target != null)) {
                        this.func_70106_y();
                    }
                    if (this.target != null) {
                        int shooting = this.getShootingTicks();
                        int shootFinish = 12;
                        int maxBeamLength = 6;
                        if (shooting >= 0 && shooting < shootFinish + maxBeamLength) {
                            this.setBeamOffset(this.getBeamOffset() - this.getDistance() / (float)shootFinish);
                            this.setBeamSize(this.getBeamSize() + 0.03f);
                            if (shooting < maxBeamLength) {
                                this.setBeamLength(this.getBeamLength() + this.getDistance() / (float)shootFinish);
                            }
                            if (shooting > shootFinish) {
                                this.setBeamLength(this.getBeamLength() - this.getDistance() / (float)shootFinish);
                            }
                            this.setShootingTicks(this.getShootingTicks() + 1);
                        } else if (shooting >= shootFinish + maxBeamLength) {
                            double x = this.target.field_72450_a;
                            double y = this.target.field_72448_b;
                            double z = this.target.field_72449_c;
                            int radius = MTConfig.MYSTIC_STAFF_AOE_SIZE;
                            Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y, (float)z, MysticStaff.getExplosionDamage(true, Utils.getPlayerMahou((LivingEntity)caster)));
                            explosion.explosionA(this.field_70170_p, caster);
                            for (PlayerEntity entityplayer : this.field_70170_p.func_217369_A()) {
                                if (!(entityplayer.func_70092_e(x, y, z) < 16384.0)) continue;
                                Vector3d vec = null;
                                if (explosion.knockback.containsKey(caster)) {
                                    vec = explosion.knockback.get(caster);
                                }
                                if (vec == null) {
                                    PacketHandler.sendTo((ServerPlayerEntity)caster, new BakuretsuPacket(x, y, z, radius, 0.0f, 0.0f, 0.0f));
                                    continue;
                                }
                                PacketHandler.sendTo((ServerPlayerEntity)caster, new BakuretsuPacket(x, y, z, radius, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c));
                            }
                            this.func_70106_y();
                        }
                    }
                }
            }
        }
    }

    public void startShoot(Vector3d target) {
        this.setShootingTicks(0);
        this.target = target;
    }

    public AxisAlignedBB func_174813_aQ() {
        return ZERO_AABB;
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public void angleCircleAroundBlock(float circleDegrees, float groundDegrees, float distance, Vector3d pos) {
        double height = (double)distance * Math.cos(MysticStaffMahoujinEntity.toRad(groundDegrees));
        double radius = Math.sqrt((double)(distance * distance) - height * height);
        double zplus = radius * Math.sin(MysticStaffMahoujinEntity.toRad(circleDegrees));
        double xplus = -radius * Math.cos(MysticStaffMahoujinEntity.toRad(circleDegrees));
        this.setRotationPitch(groundDegrees);
        this.setRotationRoll(circleDegrees - 90.0f);
        this.func_70107_b(pos.field_72450_a + xplus, pos.field_72448_b + height, pos.field_72449_c + zplus);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float f) {
        this.setCircleSize(f);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setRotationYaw(compound.func_74760_g(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.func_74760_g(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.func_74760_g(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.func_74760_g("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.func_74760_g("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setHasBeam(compound.func_74767_n(TAG_BEAM));
        this.setBeamSize(compound.func_74760_g(TAG_BEAM_SIZE));
        this.setBeamLength(compound.func_74760_g(TAG_BEAM_LENGTH));
        this.setBeamOffset(compound.func_74760_g(TAG_BEAM_OFFSET));
        this.casterUUID = compound.func_186857_a(TAG_CASTER);
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
        this.setShootingTicks(compound.func_74762_e(TAG_SHOOTING_TICKS));
        this.setDistance(compound.func_74760_g(TAG_DISTANCE));
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.func_74776_a(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.func_74776_a(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.func_74776_a("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.func_74776_a("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_186854_a(TAG_CASTER, this.casterUUID);
        compound.func_74776_a(TAG_BEAM_OFFSET, this.getBeamOffset());
        compound.func_74776_a(TAG_BEAM_LENGTH, this.getBeamLength());
        compound.func_74757_a(TAG_BEAM, this.hasBeam());
        compound.func_74776_a(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[0]);
        compound.func_74776_a(TAG_COLOR_B, colors[0]);
        compound.func_74776_a(TAG_COLOR_A, colors[0]);
        compound.func_74768_a(TAG_SHOOTING_TICKS, this.getShootingTicks());
        compound.func_74776_a(TAG_DISTANCE, this.getDistance());
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public float getRotationYaw() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.field_70180_af.func_187227_b(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.field_70180_af.func_187227_b(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.field_70180_af.func_187227_b(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.field_70180_af.func_187227_b(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.field_70180_af.func_187225_a(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.field_70180_af.func_187227_b(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public boolean hasBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(BEAM);
    }

    public void setHasBeam(boolean b) {
        this.field_70180_af.func_187227_b(BEAM, (Object)b);
    }

    public float getBeamSize() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.field_70180_af.func_187227_b(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public float getBeamLength() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float b) {
        this.field_70180_af.func_187227_b(BEAM_LENGTH, (Object)Float.valueOf(b));
    }

    public float getBeamOffset() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_OFFSET)).floatValue();
    }

    public void setBeamOffset(float b) {
        this.field_70180_af.func_187227_b(BEAM_OFFSET, (Object)Float.valueOf(b));
    }

    public int getShootingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOTING_TICKS);
    }

    public void setShootingTicks(int t) {
        this.field_70180_af.func_187227_b(SHOOTING_TICKS, (Object)t);
    }

    public float getDistance() {
        return ((Float)this.field_70180_af.func_187225_a(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.field_70180_af.func_187227_b(DISTANCE, (Object)Float.valueOf(d));
    }
}

