/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.morgan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.MorganRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class Morgan
extends SwordItem {
    protected String name = "morgan";
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_morgan_attack";
    public static HashMap<UUID, MorganStorage> staffs = new HashMap();

    public Morgan() {
        super((IItemTier)ItemTier.IRON, 3, -2.4f, new Item.Properties().func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB).func_200918_c(MTConfig.POWER_CONSOLIDATION_DURABILITY).setISTER(() -> MorganRenderer::new));
        this.setRegistryName(this.name);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Morgan.setattacktonbt(stack, worldIn);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CaliburnMahouProvider();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.POWER_CONSOLIDATION_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            return (CompoundNBT)CaliburnMahouProvider.MAHOU.getStorage().writeNBT(CaliburnMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, World world) {
        if (stack != null && !world.field_72995_K) {
            ICaliburnMahou mahou;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if ((mahou = Utils.getCaliburnMahou(stack)) != null) {
                nbt.func_74776_a(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
            }
            stack.func_77982_d(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        ICaliburnMahou mahou;
        CompoundNBT nbt;
        if (stack != null && stack.func_77942_o() && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(MT_ATTACK_DAMAGE) && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            mahou.setAttackDamage(Math.max(nbt.func_74760_g(MT_ATTACK_DAMAGE), mahou.getAttackDamage()));
        }
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        if (nbtt != null) {
            ICaliburnMahou caliburnMahou = Utils.getCaliburnMahou(stack);
            CaliburnMahou serverCaliburnMahou = new CaliburnMahou();
            CaliburnMahouProvider.MAHOU.getStorage().readNBT(CaliburnMahouProvider.MAHOU, (Object)serverCaliburnMahou, null, (INBT)nbtt);
            if (caliburnMahou != null) {
                caliburnMahou.setAttackDamage(serverCaliburnMahou.getAttackDamage());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        if (handIn == Hand.MAIN_HAND) {
            player.func_184598_c(Hand.MAIN_HAND);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        ICaliburnMahou mahou;
        MorganStorage storage = null;
        if (staffs.containsKey(player.func_110124_au())) {
            storage = staffs.get(player.func_110124_au());
        } else {
            storage = new MorganStorage();
            staffs.put(player.func_110124_au(), storage);
        }
        if (!player.field_70170_p.field_72995_K && (mahou = Utils.getCaliburnMahou(stack)) != null && player instanceof PlayerEntity && storage.ball == null && !EffectUtil.hasBuff(player, ModEffects.CM_COOLDOWN) && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST, false, false) == MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST) {
            storage.ball = new MorganBallEntity(player.field_70170_p, player, 150.0f, 0.0f, 0.0f, 0.3f, 0.0f, mahou.getAttackDamage());
            Vector3d eye = player.func_174824_e(1.0f);
            storage.ball.func_70107_b(eye.field_72450_a, eye.field_72448_b, eye.field_72449_c);
            storage.ball.func_213317_d(player.func_70040_Z().func_72432_b().func_186678_a((double)0.3f));
            player.field_70170_p.func_217376_c((Entity)storage.ball);
            EffectUtil.buff(player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity player, int useTicks) {
        MorganStorage storage;
        if (staffs.containsKey(player.func_110124_au())) {
            storage = staffs.get(player.func_110124_au());
        } else {
            storage = new MorganStorage();
            staffs.put(player.func_110124_au(), storage);
        }
        storage.ball = null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        HashMultimap multimapret = HashMultimap.create();
        float damage = 3.0f;
        Morgan.getattackfromnbt(stack);
        if (slot == EquipmentSlotType.MAINHAND && multimap != null) {
            ICaliburnMahou mahou;
            if (stack != null && (mahou = Utils.getCaliburnMahou(stack)) != null) {
                damage = mahou.getAttackDamage();
            }
            if (Attributes.field_233823_f_ != null && Attributes.field_233825_h_ != null) {
                for (Attribute k : multimap.keySet()) {
                    if (k.equals(Attributes.field_233823_f_) || k.equals(Attributes.field_233825_h_)) continue;
                    multimapret.putAll((Object)k, (Iterable)multimap.get((Object)k));
                }
                multimapret.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
                multimapret.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.600000095367432, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimapret;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public class MorganStorage {
        public MorganBallEntity ball = null;
    }
}

