/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.tile.mystic.CupOfHeavenMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class CupOfHeavenSpellScroll
extends SpellScroll {
    public CupOfHeavenSpellScroll() {
        super("cup_of_heaven");
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.HEAVENS_CUP_MANA_COST;
    }

    @Override
    public void useAction(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.field_72995_K && entityLiving instanceof PlayerEntity) {
            PlayerEntity user = (PlayerEntity)entityLiving;
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (scrollMahou != null && (user.func_110124_au().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.func_184812_l_())) {
                if (this.shouldConsume(user, scrollMahou, consume)) {
                    stack.func_190918_g(1);
                }
                stack.func_77982_d((CompoundNBT)ScrollMahouProvider.MAHOU.getStorage().writeNBT(ScrollMahouProvider.MAHOU, (Object)scrollMahou, null));
            }
        }
    }

    @Override
    public boolean doSpell(PlayerEntity user, IScrollMahou scrollMahou) {
        IMahou mahou;
        if (scrollMahou != null && (mahou = Utils.getPlayerMahou((LivingEntity)user)) != null) {
            double d = MTConfig.HEAVENS_CUP_START_DISTANCE;
            Stream lst = BlockPos.func_218281_b((BlockPos)user.func_233580_cy_().func_177963_a(-d, (double)(-user.func_233580_cy_().func_177956_o()), -d), (BlockPos)user.func_233580_cy_().func_177963_a(d, (double)user.field_70170_p.func_217301_I(), d));
            ArrayList lst2 = new ArrayList();
            double minD = d * d * 4.0;
            CupOfHeavenMahoujinTileEntity start = null;
            Vector3d v = user.func_213303_ch();
            lst.forEach(tmp -> lst2.add(new BlockPos(tmp.func_177958_n(), tmp.func_177956_o(), tmp.func_177952_p())));
            for (BlockPos p : lst2) {
                double curr;
                CupOfHeavenMahoujinTileEntity mte;
                TileEntity te = user.field_70170_p.func_175625_s(p);
                if (!(te instanceof CupOfHeavenMahoujinTileEntity) || (mte = (CupOfHeavenMahoujinTileEntity)te).getCasterUUID() == null || !mte.getCasterUUID().equals(user.func_110124_au()) || !((curr = CupOfHeavenSpellScroll.distanceTo(p, v, d * d * 4.0)) < minD)) continue;
                minD = curr;
                start = mte;
            }
            if (start != null) {
                HashSet<BlockPos> network = start.buildNetwork(null, user.func_110124_au());
                if (network.size() > 2) {
                    final List<BlockPos> hull = CupOfHeavenSpellScroll.convexHull(network);
                    int internal = network.size() - hull.size();
                    BlockPos minZ = null;
                    BlockPos minX = null;
                    BlockPos maxX = null;
                    BlockPos maxZ = null;
                    for (BlockPos p : network) {
                        if (minX == null || minX.func_177958_n() > p.func_177958_n()) {
                            minX = p;
                        }
                        if (maxX == null || maxX.func_177958_n() < p.func_177958_n()) {
                            maxX = p;
                        }
                        if (minZ == null || minZ.func_177952_p() > p.func_177952_p()) {
                            minZ = p;
                        }
                        if (maxZ != null && maxZ.func_177952_p() >= p.func_177952_p()) continue;
                        maxZ = p;
                    }
                    final double maxx = maxX.func_177958_n();
                    AxisAlignedBB aabb = new AxisAlignedBB(new BlockPos(minX.func_177958_n(), 0, minZ.func_177952_p()), new BlockPos(maxX.func_177958_n(), user.field_70170_p.func_217301_I(), maxZ.func_177952_p()));
                    List affected = user.field_70170_p.func_175647_a(LivingEntity.class, aabb, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                        public boolean apply(@Nullable LivingEntity input) {
                            return input != null && CupOfHeavenSpellScroll.isInside(hull, input.func_213303_ch(), maxx);
                        }
                    });
                    int duration = MTConfig.HEAVENS_CUP_DURATION;
                    int a2 = 0;
                    int a3 = 0;
                    int a5 = 0;
                    int a7 = 0;
                    int a11 = 0;
                    int a13 = 0;
                    int g = internal;
                    int external = hull.size();
                    while (internal % 2 == 0 && internal > 0) {
                        ++a2;
                        internal /= 2;
                    }
                    while (internal % 3 == 0 && internal > 0) {
                        ++a3;
                        internal /= 3;
                    }
                    while (internal % 5 == 0 && internal > 0) {
                        ++a5;
                        internal /= 5;
                    }
                    while (internal % 7 == 0 && internal > 0) {
                        ++a7;
                        internal /= 7;
                    }
                    while (internal % 11 == 0 && internal > 0) {
                        ++a11;
                        internal /= 11;
                    }
                    while (internal % 13 == 0 && internal > 0) {
                        ++a13;
                        internal /= 13;
                    }
                    while (external % 2 == 0 && external > 0) {
                        ++a2;
                        external /= 2;
                    }
                    while (external % 3 == 0 && external > 0) {
                        ++a3;
                        external /= 3;
                    }
                    while (external % 5 == 0 && external > 0) {
                        ++a5;
                        external /= 5;
                    }
                    while (external % 7 == 0 && external > 0) {
                        ++a7;
                        external /= 7;
                    }
                    while (external % 11 == 0 && external > 0) {
                        ++a11;
                        external /= 11;
                    }
                    while (external % 13 == 0 && external > 0) {
                        ++a13;
                        external /= 13;
                    }
                    int manacost = 2 * a2 + 3 * a3 + 5 * a5 + 7 * a7 + 11 * a11 + 13 * a13;
                    manacost = (int)((double)manacost * Math.ceil(Math.sqrt((maxZ.func_177952_p() - minZ.func_177952_p()) * (maxX.func_177958_n() - minX.func_177958_n()))));
                    if (PlayerManaManager.drainMana(user, manacost *= MTConfig.HEAVENS_CUP_MANA_COST, false, false) == manacost) {
                        for (LivingEntity a : affected) {
                            if (a2 > 0) {
                                a.func_195064_c(new EffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_TWO_EFFECT), duration, a2 - 1));
                            }
                            if (a3 > 0) {
                                a.func_195064_c(new EffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_THREE_EFFECT), duration, a3 - 1));
                            }
                            if (a5 > 0) {
                                a.func_195064_c(new EffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_FIVE_EFFECT), duration, a5 - 1));
                            }
                            if (a7 > 0) {
                                a.func_195064_c(new EffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_SEVEN_EFFECT), duration, a7 - 1));
                            }
                            if (a11 > 0) {
                                a.func_195064_c(new EffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_ELEVEN_EFFECT), duration, a11 - 1));
                            }
                            if (a13 <= 0) continue;
                            a.func_195064_c(new EffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_THIRTEEN_EFFECT), duration, a13 - 1));
                        }
                        if (a2 > 0 && a3 > 0 && a5 > 0 && a7 > 0 && a11 > 0 && a13 > 0) {
                            ModTriggers.GREATER_GRAIL.trigger((ServerPlayerEntity)user);
                            user.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "Greater Grail found. External size: " + hull.size() + ". Internal size: " + g), true);
                        } else {
                            if (a2 <= 0 && a3 <= 0 && a5 <= 0 && a7 <= 0 && a11 <= 0 && a13 <= 0) {
                                user.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Lesser Grail found, but internal count is imbalanced. External size: " + hull.size() + ". Internal size: " + g), true);
                                return false;
                            }
                            ModTriggers.LESSER_GRAIL.trigger((ServerPlayerEntity)user);
                            user.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Lesser Grail found. External size: " + hull.size() + ". Internal size: " + g), true);
                        }
                        return true;
                    }
                    user.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Not enough mana to activate grail. External size: " + hull.size() + ". Internal size: " + g + ". Mana needed: " + manacost + "."), true);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean onSegment(BlockPos p, Vector3d q, BlockPos r) {
        BlockPos bpq = new BlockPos(q);
        return bpq.func_177958_n() <= Math.max(p.func_177958_n(), r.func_177958_n()) && bpq.func_177958_n() >= Math.min(p.func_177958_n(), r.func_177958_n()) && bpq.func_177952_p() <= Math.max(p.func_177952_p(), r.func_177952_p()) && bpq.func_177952_p() >= Math.min(p.func_177952_p(), r.func_177952_p());
    }

    static boolean isInside(List<BlockPos> polygon, Vector3d p, double maxX) {
        int next;
        if (polygon.size() < 2) {
            return false;
        }
        if (polygon.size() == 2) {
            return CupOfHeavenSpellScroll.onSegment(polygon.get(0), p, polygon.get(1).func_177982_a(1, 0, 1));
        }
        Vector3d extreme = new Vector3d(maxX + 5000000.0, 0.0, p.field_72449_c);
        int count = 0;
        int i = 0;
        do {
            next = (i + 1) % polygon.size();
            if (!CupOfHeavenSpellScroll.doIntersect(EffectUtil.fromBlockPos(polygon.get(i)), EffectUtil.fromBlockPos(polygon.get(next)), p, extreme)) continue;
            if (CupOfHeavenSpellScroll.orientation(EffectUtil.fromBlockPos(polygon.get(i)), p, EffectUtil.fromBlockPos(polygon.get(next))) == 0) {
                return CupOfHeavenSpellScroll.onSegment(polygon.get(i), p, polygon.get(next));
            }
            ++count;
        } while ((i = next) != 0);
        return count % 2 == 1;
    }

    public static double distanceTo(BlockPos from, Vector3d to, double d) {
        if (from != null && to != null) {
            BlockPos a = new BlockPos(from.func_177958_n(), 0, from.func_177952_p());
            return a.func_218140_a(to.field_72450_a, 0.0, to.field_72449_c, false);
        }
        return d;
    }

    public static List<BlockPos> convexHull(HashSet<BlockPos> ps) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        ArrayList<Vector3d> pts = new ArrayList<Vector3d>();
        Object minV = null;
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        boolean found = false;
        for (BlockPos p : ps) {
            found = false;
            for (BlockPos z : points) {
                if (z.func_177952_p() != p.func_177952_p() || z.func_177958_n() != p.func_177958_n()) continue;
                found = true;
            }
            if (found) continue;
            points.add(p);
        }
        for (BlockPos p : points) {
            Vector3d tmpV = EffectUtil.fromBlockPos(p);
            pts.add(tmpV);
        }
        pts.sort((a, b) -> {
            if (a.field_72449_c == b.field_72449_c) {
                if (a.field_72450_a > b.field_72450_a) {
                    return -1;
                }
                if (a.field_72450_a < b.field_72450_a) {
                    return 1;
                }
                return 0;
            }
            if (a.field_72449_c < b.field_72449_c) {
                return -1;
            }
            if (a.field_72449_c > b.field_72449_c) {
                return 1;
            }
            return 0;
        });
        Vector3d initial = (Vector3d)pts.get(0);
        pts.remove(initial);
        if (initial != null) {
            pts.sort((a, b) -> {
                double cross = (a.field_72450_a - initial.field_72450_a) * (b.field_72449_c - initial.field_72449_c) - (b.field_72450_a - initial.field_72450_a) * (a.field_72449_c - initial.field_72449_c);
                if (cross > 0.0) {
                    return 1;
                }
                if (cross < 0.0) {
                    return -1;
                }
                double adist = (a.field_72450_a - initial.field_72450_a) * (a.field_72450_a - initial.field_72450_a) + (a.field_72449_c - initial.field_72449_c) * (a.field_72449_c - initial.field_72449_c);
                double bdist = (b.field_72450_a - initial.field_72450_a) * (b.field_72450_a - initial.field_72450_a) + (b.field_72449_c - initial.field_72449_c) * (b.field_72449_c - initial.field_72449_c);
                if (adist < bdist) {
                    return 1;
                }
                if (adist > bdist) {
                    return -1;
                }
                return 0;
            });
        }
        for (int m = 1; m < pts.size(); ++m) {
            Vector3d a2 = (Vector3d)pts.get(m);
            Vector3d b2 = (Vector3d)pts.get(m - 1);
            double cross = (a2.field_72450_a - initial.field_72450_a) * (b2.field_72449_c - initial.field_72449_c) - (b2.field_72450_a - initial.field_72450_a) * (a2.field_72449_c - initial.field_72449_c);
            double cotanA = -(a2.field_72450_a - initial.field_72450_a) / (a2.field_72449_c - initial.field_72449_c);
            double cotanB = -(b2.field_72450_a - initial.field_72450_a) / (b2.field_72449_c - initial.field_72449_c);
            if (cross != 0.0) continue;
            pts.remove(m);
            --m;
        }
        Stack<Vector3d> stack = new Stack<Vector3d>();
        stack.push(initial);
        for (Vector3d pt : pts) {
            while (stack.size() > 1 && CupOfHeavenSpellScroll.ccw(CupOfHeavenSpellScroll.nextToTop(stack), stack.peek(), pt) <= 0) {
                stack.pop();
            }
            stack.push(pt);
        }
        while (!stack.empty()) {
            Vector3d tmp = (Vector3d)stack.pop();
            ret.add(new BlockPos(tmp.field_72450_a, tmp.field_72448_b, tmp.field_72449_c));
        }
        return ret;
    }

    public static Vector3d nextToTop(Stack<Vector3d> s) {
        Vector3d tmp = s.pop();
        Vector3d ret = s.peek();
        s.push(tmp);
        return ret;
    }

    public static int ccw(Vector3d a, Vector3d b, Vector3d c) {
        double area2 = (-b.field_72450_a + a.field_72450_a) * (c.field_72449_c - a.field_72449_c) - (b.field_72449_c - a.field_72449_c) * (-c.field_72450_a + a.field_72450_a);
        double ball = 1.0E-7;
        if (area2 < ball && area2 > 0.0) {
            return 0;
        }
        if (area2 > -ball && area2 < 0.0) {
            return 0;
        }
        if (area2 < 0.0) {
            return -1;
        }
        if (area2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public static boolean doIntersect(Vector3d p1, Vector3d q1, Vector3d p2, Vector3d q2) {
        int o1 = CupOfHeavenSpellScroll.orientation(p1, q1, p2);
        int o2 = CupOfHeavenSpellScroll.orientation(p1, q1, q2);
        int o3 = CupOfHeavenSpellScroll.orientation(p2, q2, p1);
        int o4 = CupOfHeavenSpellScroll.orientation(p2, q2, q1);
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p1), p2, new BlockPos(q1))) {
            return true;
        }
        if (o2 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p1), q2, new BlockPos(q1))) {
            return true;
        }
        if (o3 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p2), p1, new BlockPos(q2))) {
            return true;
        }
        return o4 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p2), q1, new BlockPos(q2));
    }

    public static int orientation(Vector3d p, Vector3d q, Vector3d r) {
        double val = (q.field_72449_c - p.field_72449_c) * (-r.field_72450_a + q.field_72450_a) - (-q.field_72450_a + p.field_72450_a) * (r.field_72449_c - q.field_72449_c);
        if (val == 0.0) {
            return 0;
        }
        return val > 0.0 ? 1 : 2;
    }

    private static Effect getRegisteredMobEffect(String id) {
        Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(id));
        if (potion == null) {
            throw new IllegalStateException("Invalid MobEffect requested: " + id);
        }
        return potion;
    }
}

