/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class GandrSpellScroll
extends SpellScroll {
    public static HashMap<UUID, GandrUserStorage> gandrs = new HashMap();

    public GandrSpellScroll() {
        super("gandr");
    }

    @Override
    public int getInitialManaCost() {
        return 0;
    }

    public int getManaCostScaling(IMahou mahou) {
        boolean manascales = MTConfig.GANDR_MANA_SCALES;
        double factor = MTConfig.GANDR_MANA_COST_FACTOR;
        if (manascales) {
            return (int)Math.floor(factor * (double)mahou.getMaxMana());
        }
        return (int)Math.floor(factor);
    }

    public double getDamage(IMahou mahou) {
        boolean scales = MTConfig.GANDR_DAMAGE_SCALES;
        double factor = MTConfig.GANDR_DAMAGE_FACTOR;
        double mindamage = MTConfig.GANDR_MIN_DAMAGE;
        double maxdamage = MTConfig.GANDR_MAX_DAMAGE;
        double ret = 0.0;
        if (mahou != null) {
            ret = scales ? (double)mahou.getMaxMana() * factor : factor;
            ret = Math.max(mindamage, Math.min(ret, maxdamage));
        }
        return ret;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.field_70170_p.field_72995_K) {
            if (gandrs.containsKey(player.func_110124_au())) {
                GandrUserStorage storage = gandrs.get(player.func_110124_au());
            } else {
                GandrUserStorage storage = new GandrUserStorage();
                gandrs.put(player.func_110124_au(), storage);
                storage.gandr = new GandrEntity(player.field_70170_p, player);
                storage.gandr.setLookPos(player.field_70170_p.field_72995_K, player, storage.gandr);
                player.field_70170_p.func_217376_c((Entity)storage.gandr);
            }
        }
    }

    @Override
    public void useAction(ItemStack stack, World worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.field_72995_K) {
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (entityLiving instanceof PlayerEntity && Utils.getPlayerMahou(entityLiving) != null) {
                PlayerEntity user = (PlayerEntity)entityLiving;
                int cost = this.getManaCostScaling(Utils.getPlayerMahou(entityLiving));
                if (scrollMahou != null && (user.func_110124_au().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.func_184812_l_())) {
                    if (PlayerManaManager.drainMana(user, cost, false, false) == cost) {
                        if (this.shouldConsume(user, scrollMahou, consume)) {
                            stack.func_190918_g(1);
                        }
                        stack.func_77982_d((CompoundNBT)ScrollMahouProvider.MAHOU.getStorage().writeNBT(ScrollMahouProvider.MAHOU, (Object)scrollMahou, null));
                    } else if (gandrs.containsKey(user.func_110124_au())) {
                        GandrUserStorage storage = gandrs.get(user.func_110124_au());
                        storage.gandr.func_70106_y();
                        gandrs.remove(user.func_110124_au());
                    }
                }
            }
        }
    }

    @Override
    public boolean doSpell(PlayerEntity user, IScrollMahou scrollMahou) {
        double speed = MTConfig.GANDR_SPEED;
        int launch_particles = MTConfig.GANDR_RED_PARTICLES_LAUNCH;
        if (gandrs.containsKey(user.func_110124_au())) {
            GandrUserStorage storage = gandrs.get(user.func_110124_au());
            if ((float)storage.gandr.getLife() > storage.gandr.getGrowingLife()) {
                storage.gandr.setFired(true);
                storage.gandr.effects = new ArrayList(user.func_70651_bq());
                storage.gandr.damage = (float)this.getDamage(Utils.getPlayerMahou((LivingEntity)user));
                Iterator iter = user.func_70651_bq().iterator();
                ArrayList<Effect> lst = new ArrayList<Effect>();
                while (iter.hasNext()) {
                    EffectInstance ei = (EffectInstance)iter.next();
                    if (!GandrEntity.validEffect(ei)) continue;
                    lst.add(ei.func_188419_a());
                }
                for (Effect e : lst) {
                    user.func_195063_d(e);
                }
                Vector3d v = user.func_70040_Z().func_72432_b().func_186678_a(speed);
                storage.gandr.func_213293_j(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                Vector3d look = storage.gandr.func_70676_i(1.0f);
                PacketHandler.sendTracking(storage.gandr, new MagicCircleBoomParticlePacket(storage.gandr.func_226277_ct_(), storage.gandr.func_226278_cu_(), storage.gandr.func_226281_cx_(), look.field_72450_a, look.field_72448_b, look.field_72449_c, 0.2f, 0, 0, launch_particles, false, false));
                PacketHandler.sendTracking(storage.gandr, new MagicCircleBoomParticlePacket(storage.gandr.func_226277_ct_(), storage.gandr.func_226278_cu_(), storage.gandr.func_226281_cx_(), look.field_72450_a, look.field_72448_b, look.field_72449_c, 0.3f, 0, 0, launch_particles, false, false));
                gandrs.remove(user.func_110124_au());
                return true;
            }
            storage.gandr.func_70106_y();
            gandrs.remove(user.func_110124_au());
            return false;
        }
        return false;
    }

    public class GandrUserStorage {
        GandrEntity gandr;
    }
}

