/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret.ripper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.exchange.ImmunityExchangeSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.FogPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TheRipper
extends ItemBase {
    public TheRipper() {
        super("theripper", ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1, MTConfig.RIPPER_DURABILITY);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        HashMultimap multimapret = HashMultimap.create();
        for (Attribute k : multimap.keySet()) {
            if (k.equals(Attributes.field_233823_f_) || k.equals(Attributes.field_233825_h_)) continue;
            multimapret.putAll((Object)k, (Iterable)multimap.get((Object)k));
        }
        if (slot == EquipmentSlotType.MAINHAND) {
            multimapret.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(UUID.fromString("91AFBB56-376B-4498-945B-2F7FFF070635"), "Weapon modifier", 0.05, AttributeModifier.Operation.ADDITION));
        }
        if (slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND) {
            multimapret.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", MTConfig.RIPPER_DAMAGE, AttributeModifier.Operation.ADDITION));
            multimapret.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", MTConfig.RIPPER_SPEED, AttributeModifier.Operation.ADDITION));
        }
        return multimapret;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player != null) {
            int manafog;
            PlayerEntity target = player;
            ItemStack main = player.func_184582_a(EquipmentSlotType.MAINHAND);
            ItemStack off = player.func_184582_a(EquipmentSlotType.OFFHAND);
            if (!player.field_70170_p.field_72995_K && main.func_77973_b() == off.func_77973_b() && main.func_77973_b() == ModItems.theripper && MTConfig.RIPPER_GIVES_INVIS && PlayerManaManager.drainMana(player, manafog = MTConfig.RIPPER_INVIS_MANA_COST, false, false) == manafog) {
                EffectUtil.buff((LivingEntity)player, ModEffects.RIPPER_INVISIBILITY, false, 2000000000, false);
                RipperInvisPotion.notifyIfInvisible((LivingEntity)player);
            }
            int mana = MTConfig.RIPPER_FOG_MANA_COST;
            if (!player.field_70170_p.field_72995_K && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.RIPPER_COOLDOWN) && PlayerManaManager.drainMana(player, mana, false, false) == mana) {
                LivingEntity look = ImmunityExchangeSpellEffect.getEnemy(player);
                if (look != null) {
                    target = look;
                }
                EffectUtil.buff((LivingEntity)player, ModEffects.RIPPER_COOLDOWN, false, MTConfig.RIPPER_COOLDOWN, false);
                PacketHandler.sendTracking((Entity)target, new FogPacket(target.func_145782_y(), MTConfig.RIPPER_FOG_RANGE, MTConfig.RIPPER_FOG_DISTANCE));
                if (target instanceof ServerPlayerEntity) {
                    PacketHandler.sendTo((ServerPlayerEntity)target, new FogPacket(target.func_145782_y(), 20.0, 5.0));
                }
            }
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226251_d_((Object)ItemStack.field_190927_a);
    }

    public static void ripperOnHit(LivingHurtEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).func_184614_ca().func_77973_b() == living.func_184592_cb().func_77973_b() && living.func_184592_cb().func_77973_b() == ModItems.theripper) {
            if (EffectUtil.hasBuff(living, ModEffects.RIPPER_INVISIBILITY) && MTConfig.RIPPER_GIVES_INVIS) {
                EffectUtil.debuff(living, ModEffects.RIPPER_INVISIBILITY);
                RipperInvisPotion.notifyNotInvisible(living);
                EffectUtil.buff(living, ModEffects.RIPPER_INVIS_COOLDOWN, false, MTConfig.RIPPER_INVIS_COOLDOWN, false);
            }
            if (!EffectUtil.isLookingAtMe(living, event.getEntityLiving())) {
                event.getEntityLiving().field_70172_ad = 0;
                IMahou mahou = Utils.getPlayerMahou(living);
                if (mahou != null) {
                    double d = MTConfig.RIPPER_DAMAGE_BONUS_FROM_BEHIND * (double)(MTConfig.RIPPER_DAMAGE_BONUS_SCALES_WITH_MANA ? mahou.getMaxMana() : 1);
                    d = (double)event.getAmount() + d;
                    event.setAmount((float)d);
                }
            }
        }
    }

    public static void ripperLivingTick(LivingEntity living) {
        if (living != null && (living.func_184614_ca().func_77973_b() != living.func_184592_cb().func_77973_b() || living.func_184614_ca().func_77973_b() != ModItems.theripper) && EffectUtil.hasBuff(living, ModEffects.RIPPER_INVISIBILITY)) {
            EffectUtil.debuff(living, ModEffects.RIPPER_INVISIBILITY);
            RipperInvisPotion.notifyNotInvisible(living);
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.RIPPER_DURABILITY;
    }

    public static void attackTargetEntityWithCurrentItem(Entity targetEntity, PlayerEntity player, Hand hand) {
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)player.func_184586_b(hand), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_184586_b(hand), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float f2 = player.func_184825_o(0.5f);
            f1 *= f2;
            player.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((LivingEntity)player);
                if (player.func_70051_ag() && flag) {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && player.field_70143_R > 0.0f && !player.func_233570_aj_() && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && !player.func_184218_aH() && targetEntity instanceof LivingEntity;
                flag2 = flag2 && !player.func_70051_ag();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)player, (Entity)targetEntity, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                boolean bl = flag2 = hitResult != null;
                if (flag2) {
                    f *= hitResult.getDamageModifier();
                }
                f += f1;
                boolean flag3 = false;
                double d0 = player.field_70140_Q - player.field_70141_P;
                if (flag && !flag2 && !flag1 && player.func_233570_aj_() && d0 < (double)player.func_70689_ay() && (itemstack = player.func_184586_b(hand)).func_77973_b() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((LivingEntity)player);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d vec3d = targetEntity.func_213322_ci();
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).func_233627_a_((float)i * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        player.func_213317_d(player.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        player.func_70031_b(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a((LivingEntity)player) * f;
                        for (LivingEntity livingentity : player.field_70170_p.func_217357_a(LivingEntity.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (livingentity == player || livingentity == targetEntity || player.func_184191_r((Entity)livingentity) || livingentity instanceof ArmorStandEntity && ((ArmorStandEntity)livingentity).func_181026_s() || !(player.func_70068_e((Entity)livingentity) < 9.0)) continue;
                            livingentity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                            livingentity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), f3);
                        }
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_184810_cG();
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(vec3d);
                    }
                    if (flag2) {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_71009_b(targetEntity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.func_184586_b(hand);
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPartEntity) {
                        entity = ((EnderDragonPartEntity)targetEntity).field_213852_b;
                    }
                    if (!player.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((LivingEntity)entity, player);
                        if (itemstack1.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).func_110143_aJ();
                        player.func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (player.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.func_71020_j(0.1f);
                } else {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }
}

