/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMysticStaffMahoujinEntity
extends EntityRenderer<MysticStaffMahoujinEntity> {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");

    public RenderMysticStaffMahoujinEntity(EntityRendererManager p_i46179_1_) {
        super(p_i46179_1_);
    }

    public ResourceLocation getEntityTexture(MysticStaffMahoujinEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(MysticStaffMahoujinEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
    }

    public static void renderCircle(MysticStaffMahoujinEntity entity, double x, double y, double z, MatrixStack matrix, float partialTicks) {
        float prevYaw;
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        int life = entity.getLife();
        float size = entity.getCircleSize();
        float yaw = entity.field_70177_z % 360.0f;
        float roll = entity.getRotationRoll();
        float pitch = entity.getRotationPitch();
        boolean renderBeam = entity.hasBeam();
        if (life < 20) {
            size = ((float)life + partialTicks) / 20.0f * size;
        }
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((prevYaw = entity.field_70126_B % 360.0f) < 0.0f) {
            prevYaw += 360.0f;
        }
        if (prevYaw - yaw > 300.0f) {
            yaw += 360.0f;
        }
        if (prevYaw - yaw < 300.0f && prevYaw - yaw > 0.0f) {
            prevYaw = yaw;
        }
        yaw = entity.field_70126_B + partialTicks * (yaw - prevYaw);
        matrix.func_227862_a_(size, size, size);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, true));
        int lightmapX = 240;
        int lightmapY = 240;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder bb = buf.getBuffer((RenderType)type);
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        bb.func_227888_a_(m, -0.5f, 0.0f, -0.5f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, -0.5f, 0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f, 0.0f, 0.5f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f, 0.0f, -0.5f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        buf.func_228462_a_((RenderType)type);
        if (renderBeam) {
            float beamSize = MysticStaff.getBeamSize(entity, partialTicks);
            matrix.func_227862_a_(1.0f / size, 1.0f / size, 1.0f / size);
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
            if (colors[1] < 0.26f) {
                colors[1] = (float)((double)colors[1] + 0.33);
            }
            matrix.func_227861_a_(0.5, 0.0, 0.5);
            RenderMysticStaffMahoujinEntity.renderBeamSegment(matrix, buf, (int)entity.getBeamOffset(), (int)entity.getBeamLength(), beamSize, (double)beamSize + 0.2, r, g, b);
        }
        matrix.func_227865_b_();
    }

    public static void renderBeamSegment(MatrixStack matrix, IRenderTypeBuffer.Impl buf, int yOffset, int height, double beamRadius, double glowRadius, float r, float g, float b) {
        CullWrappedRenderLayer beamtype1 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(beam, 0));
        CullWrappedRenderLayer beamtype2 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(beam, 1));
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        int lightmapX = 240;
        int lightmapY = 240;
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, (double)(-yOffset), 90.0f, (float)Math.max(0.0, beamRadius - (double)0.1f), (float)height, 64, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 0.99f, beamtype1);
        buf.func_228462_a_((RenderType)beamtype1);
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, (double)(-yOffset), 90.0f, (float)glowRadius, (float)height, 64, lightmapX, lightmapY, r, g, b, 0.3f, beamtype2);
        buf.func_228462_a_((RenderType)beamtype2);
        RenderUtils.rotateQ(-180.0f, 1.0f, 0.0f, 0.0f, matrix);
    }
}

