/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.networking.MysticCodeSwitchPacket;
import stepsword.mahoutsukai.networking.PacketHandler;

public class WheelGui
extends Screen {
    private int NUM_SECTORS = 3;
    int slotSelected = -1;
    ItemStack stack;
    World world;

    public WheelGui(World w, ItemStack i) {
        super((ITextComponent)new StringTextComponent(""));
        this.world = w;
        this.stack = i;
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        int maxRadius = 80;
        double angle = WheelGui.mouseAngle(x, y, mouseX, mouseY);
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)this.NUM_SECTORS;
        this.slotSelected = -1;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        GlStateManager.func_227605_A_();
        GlStateManager.func_227621_I_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227762_u_((int)7425);
        buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < this.NUM_SECTORS; ++i) {
            boolean mouseInSector = (double)(degPer * (float)i) < angle && angle < (double)(degPer * (float)(i + 1));
            float radius = maxRadius;
            if (mouseInSector) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (i % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (i == 0) {
                buf.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            if (mouseInSector) {
                this.slotSelected = i;
                b = 255;
                g = 255;
                r = 255;
            }
            for (float j = 0.0f; j < degPer + step / 2.0f; j += step) {
                float rad = j + (float)i * degPer;
                float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
                float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
                if (j == 0.0f) {
                    buf.func_225582_a_((double)xp, (double)yp, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                }
                buf.func_225582_a_((double)xp, (double)yp, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
        }
        tess.func_78381_a();
        GlStateManager.func_227762_u_((int)7424);
        GlStateManager.func_227619_H_();
        if (stack != null) {
            for (int j = 0; j < this.NUM_SECTORS; ++j) {
                String name;
                boolean mouseInSector = (double)(degPer * (float)j) < angle && angle < (double)(degPer * (float)(j + 1));
                float radius = maxRadius;
                if (mouseInSector) {
                    radius *= 1.025f;
                }
                float rad = ((float)j + 0.25f) * degPer;
                float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
                float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
                float xsp = xp - 4.0f;
                float ysp = yp;
                if (this.stack.func_77973_b() instanceof MysticCode) {
                    name = ((MysticCode)this.stack.func_77973_b()).getSlotsForWheel(this.stack).get(j);
                    if (name.startsWith("Scroll of the")) {
                        name = name.substring("Scroll of the".length());
                    } else if (name.startsWith("Scroll of")) {
                        name = name.substring("Scroll of".length());
                    }
                } else {
                    name = "SLOT EMPTY";
                }
                int width = this.field_230712_o_.func_78256_a(name);
                double mod = 0.6;
                int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
                int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
                if (xsp < (float)x) {
                    xsp -= (float)(width - 8);
                }
                if (ysp < (float)y) {
                    ysp -= 9.0f;
                }
                this.field_230712_o_.func_238405_a_(stack, name, xsp, ysp, 0xFFFFFF);
                mod = 0.8;
                xdp = (int)((double)(xp - (float)x) * mod + (double)x);
                ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            }
        }
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (MathHelper.func_181159_b((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)Keybinds.changeMysticCode.getKey().func_197937_c())) {
            this.field_230706_i_.func_147108_a(null);
            if (this.slotSelected != -1) {
                int slot = this.slotSelected;
                MysticCodeSwitchPacket message = new MysticCodeSwitchPacket(slot);
                PacketHandler.sendToServer(message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_230706_i_.field_71474_y.field_74351_w, (Object)this.field_230706_i_.field_71474_y.field_74370_x, (Object)this.field_230706_i_.field_71474_y.field_74368_y, (Object)this.field_230706_i_.field_71474_y.field_74366_z, (Object)this.field_230706_i_.field_71474_y.field_228046_af_, (Object)this.field_230706_i_.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_230706_i_.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_197980_a((InputMappings.Input)k.getKey(), (boolean)k.func_151470_d());
        }
    }
}

