/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.fluids.MurkyWater;
import stepsword.mahoutsukai.fluids.MurkyWaterTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderPowerConsolidation {
    public static float distanceToMurkyWater(Entity entity) {
        int r = (int)(MTConfig.POWER_CONSOLIDATION_FOG_RADIUS - 2.0);
        BlockPos minPos = entity.func_233580_cy_().func_177982_a(-r, -r, -r);
        BlockPos maxPos = entity.func_233580_cy_().func_177982_a(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        float ret = -1.0f;
        try {
            for (int x = minCPos.field_77276_a; x < maxCPos.field_77276_a + 1; ++x) {
                for (int z = minCPos.field_77275_b; z < maxCPos.field_77275_b + 1; ++z) {
                    for (TileEntity te : entity.field_70170_p.func_212866_a_(x, z).func_177434_r().values()) {
                        if (!(te instanceof MurkyWaterTileEntity) || Math.abs(te.func_174877_v().func_177958_n() - entity.func_233580_cy_().func_177958_n()) >= r || Math.abs(te.func_174877_v().func_177952_p() - entity.func_233580_cy_().func_177952_p()) >= r || Math.abs(te.func_174877_v().func_177956_o() - entity.func_233580_cy_().func_177956_o()) >= r) continue;
                        float d = (float)entity.func_213303_ch().func_72438_d(EffectUtil.fromBlockPos(te.func_174877_v()).func_72441_c(0.5, 0.5, 0.5));
                        if (ret == -1.0f) {
                            ret = d;
                        }
                        if (!(ret > d)) continue;
                        ret = d;
                    }
                }
            }
        }
        catch (Exception e) {
            return -1.0f;
        }
        return ret;
    }

    public static boolean powerConsolidationFogColor(EntityViewRenderEvent.FogColors event) {
        boolean ret = false;
        double d = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.func_71410_x().func_175606_aa());
        if (Utils.isInMurkyWater(Minecraft.func_71410_x().func_175606_aa())) {
            event.setRed(0.0f);
            event.setGreen(0.15686275f);
            event.setBlue(0.0f);
            ret = true;
        } else if (d <= MTConfig.POWER_CONSOLIDATION_FOG_RADIUS && d >= 0.0) {
            event.setRed(0.7058824f);
            event.setGreen(0.7058824f);
            event.setBlue(0.7058824f);
            ret = true;
        }
        return ret;
    }

    public static boolean powerConsolidationBlockOverlay(RenderBlockOverlayEvent event) {
        return Minecraft.func_71410_x().func_175606_aa() != null && Utils.isInMurkyWater(Minecraft.func_71410_x().func_175606_aa());
    }

    public static boolean powerConsolidationRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        boolean ret = RenderPowerConsolidation.doFog(event.getFarPlaneDistance());
        if (ret) {
            event.setResult(Event.Result.ALLOW);
        }
        return ret;
    }

    public static void powerConsolidationFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (Utils.isInMurkyWater(Minecraft.func_71410_x().func_175606_aa())) {
            event.setDensity(0.5f);
            event.setCanceled(true);
            RenderSystem.fog((int)2918, (float)((float)MurkyWater.COLOR.getRed() / 255.0f), (float)((float)MurkyWater.COLOR.getGreen() / 255.0f), (float)((float)MurkyWater.COLOR.getBlue() / 255.0f), (float)1.0f);
        }
    }

    public static boolean doFog(float farPlane) {
        double f = RenderPowerConsolidation.distanceToMurkyWater(Minecraft.func_71410_x().func_175606_aa());
        double top = MTConfig.POWER_CONSOLIDATION_FOG_RADIUS;
        float bottom = 4.0f;
        float offset = 1.0f;
        if ((f = Math.min(f, top)) > 0.0) {
            f = Math.max(f, (double)bottom);
            float f1 = (float)((f - (double)bottom) / (top - (double)bottom));
            float oldstart = farPlane * 0.75f;
            f1 = f1 * (oldstart - offset) + offset;
            float fogStart = Math.min(oldstart, f1);
            RenderSystem.enableFog();
            float fogEnd = Math.min(farPlane, 4.0f * f1);
            float fg = 0.7058824f;
            RenderSystem.fog((int)2918, (float)fg, (float)fg, (float)fg, (float)1.0f);
            RenderSystem.fogStart((float)fogStart);
            RenderSystem.fogEnd((float)fogEnd);
            return true;
        }
        return false;
    }
}

