/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;

public class InvisibleBarrierBlockRenderer
extends TileEntityRenderer<InvisibleBarrierBlockTileEntity> {
    public static Color fullyLit = new Color(25, 243, 255, 255);

    public InvisibleBarrierBlockRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(InvisibleBarrierBlockTileEntity te, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int v1, int v2) {
        matrixStack.func_227860_a_();
        long[] times = new long[6];
        Direction[] facings = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.UP, Direction.DOWN};
        times[0] = te.getTimeSinceCollision(Direction.NORTH);
        times[1] = te.getTimeSinceCollision(Direction.EAST);
        times[2] = te.getTimeSinceCollision(Direction.WEST);
        times[3] = te.getTimeSinceCollision(Direction.SOUTH);
        times[4] = te.getTimeSinceCollision(Direction.UP);
        times[5] = te.getTimeSinceCollision(Direction.DOWN);
        int cmp = 20;
        for (int i = 0; i < facings.length; ++i) {
            if (times[i] >= (long)cmp) continue;
            float percent = 1.0f * (float)((long)cmp - times[i]);
            percent /= (float)cmp * 1.0f;
            percent = MathHelper.func_76131_a((float)percent, (float)0.0f, (float)1.0f);
            this.renderSide(matrixStack, percent, facings[i]);
        }
        matrixStack.func_227865_b_();
    }

    public void renderSide(MatrixStack matrix, float percent, Direction facing) {
        float a2;
        float b2;
        float c2;
        float d2;
        float c1;
        float d1;
        float b3;
        float c3;
        float a1;
        float b1;
        float a3;
        float d3;
        System.out.println(percent);
        Color c = new Color((int)Math.floor((float)fullyLit.getRed() * percent), (int)Math.floor((float)fullyLit.getGreen() * percent), (int)Math.floor((float)fullyLit.getBlue() * percent), (int)Math.floor((float)fullyLit.getAlpha() * percent));
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        float z1 = 0.0f;
        float y1 = 0.0f;
        float x1 = 0.0f;
        float x2 = x1 + 1.0f;
        float y2 = y1 + 1.0f;
        float z2 = z1 + 1.0f;
        RenderType type = MahoujinRenderType.createMahoujinRenderType(new ResourceLocation("mahoutsukai:textures/block/barrier_hit.png"), 0, false);
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        switch (facing) {
            case UP: {
                a3 = d3 = z1;
                a1 = b1 = x1;
                b3 = c3 = z2;
                c1 = d1 = x2;
                c2 = d2 = y2;
                b2 = d2;
                a2 = d2;
                break;
            }
            case DOWN: {
                b3 = c3 = z1;
                a1 = b1 = x1;
                a3 = d3 = z2;
                c1 = d1 = x2;
                c2 = d2 = y1;
                b2 = d2;
                a2 = d2;
                break;
            }
            case EAST: {
                d3 = c3 = z1;
                b2 = c2 = y1;
                a3 = b3 = z2;
                a2 = d2 = y2;
                c1 = d1 = x2;
                b1 = d1;
                a1 = d1;
                break;
            }
            case WEST: {
                a3 = b3 = z1;
                b2 = c2 = y1;
                d3 = c3 = z2;
                a2 = d2 = y2;
                c1 = d1 = x1;
                b1 = d1;
                a1 = d1;
                break;
            }
            case SOUTH: {
                a1 = b1 = x1;
                b2 = c2 = y1;
                c1 = d1 = x2;
                a2 = d2 = y2;
                c3 = d3 = z2;
                b3 = d3;
                a3 = d3;
                break;
            }
            case NORTH: {
                c1 = d1 = x1;
                b2 = c2 = y1;
                a1 = b1 = x2;
                a2 = d2 = y2;
                c3 = d3 = z1;
                b3 = d3;
                a3 = d3;
                break;
            }
            default: {
                throw new IllegalArgumentException(facing.toString());
            }
        }
        int lx = 240;
        int ly = 240;
        IVertexBuilder buf = buffer.getBuffer(type);
        buf.func_227888_a_(positionMatrix, a1, a2, a3).func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_227888_a_(positionMatrix, b1, b2, b3).func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_227888_a_(positionMatrix, c1, c2, c3).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_227888_a_(positionMatrix, d1, d2, d3).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        buffer.func_228461_a_();
        buf = buffer.getBuffer(type);
        buf.func_227888_a_(positionMatrix, a1, a2, a3).func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_227888_a_(positionMatrix, d1, d2, d3).func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_227888_a_(positionMatrix, c1, c2, c3).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_227888_a_(positionMatrix, b1, b2, b3).func_225586_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        buffer.func_228461_a_();
    }
}

