/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.tile.mystic.CupOfHeavenMahoujinTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahoujinRenderer
extends TileEntityRenderer<MahoujinTileEntity> {
    public static ResourceLocation location = new ResourceLocation("mahoutsukai:textures/block/mahoujin_changeable.png");
    public static ResourceLocation location_fay = new ResourceLocation("mahoutsukai:textures/block/mahoujin_changeable_fae.png");
    ResourceLocation spellClothLocation = new ResourceLocation("mahoutsukai:textures/block/spell_cloth.png");
    HashMap<ArrayList<String>, MahoujinData> loadedMahoujin = new HashMap();
    public static int SIDE_SIZE = 256;
    public static int S_WIDTH = 256;
    public static int S_HEIGHT = 256;
    public static int PIXEL_COUNT = SIDE_SIZE * SIDE_SIZE;
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    private static final ResourceLocation runes = new ResourceLocation("mahoutsukai:textures/block/runes.png");

    public MahoujinRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(MahoujinTileEntity mahoujin, float partialTicks, MatrixStack matrix, IRenderTypeBuffer iRenderTypeBuffer, int v1, int v2) {
        MahoujinData displayMe;
        UnorderedList catalysts = mahoujin.getCatalysts();
        if (catalysts == null) {
            catalysts = new UnorderedList();
        }
        ArrayList<String> orderM = catalysts.getOrder();
        ArrayList<String> order = new ArrayList<String>();
        if (orderM != null) {
            for (String s : orderM) {
                order.add(s);
            }
        }
        if (mahoujin.isFay()) {
            order.add("fay");
        }
        if (this.loadedMahoujin.containsKey(order)) {
            displayMe = this.loadedMahoujin.get(order);
        } else {
            int side_size;
            if (mahoujin.isFay()) {
                RenderUtils.bindTexture(location_fay);
            } else {
                RenderUtils.bindTexture(location);
            }
            S_WIDTH = side_size = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4096);
            S_HEIGHT = side_size = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4097);
            PIXEL_COUNT = S_WIDTH * S_HEIGHT;
            displayMe = new MahoujinData(order);
            this.loadedMahoujin.put(order, displayMe);
            displayMe.changeMahoujin(order);
            MahoujinData image = new MahoujinData(order);
            try {
                InputStream io = mahoujin.isFay() ? Minecraft.func_71410_x().func_195551_G().func_199002_a(location_fay).func_199027_b() : Minecraft.func_71410_x().func_195551_G().func_199002_a(location).func_199027_b();
                image.colors = NativeImage.func_195713_a((InputStream)io);
                image.changeMahoujin(order);
                displayMe = image;
                this.loadedMahoujin.put(order, displayMe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        displayMe.render(mahoujin, matrix, iRenderTypeBuffer);
        if (mahoujin instanceof CupOfHeavenMahoujinTileEntity && MTConfig.HEAVENS_CUP_CLIENT_CIRCLE) {
            CupOfHeavenMahoujinTileEntity cup = (CupOfHeavenMahoujinTileEntity)mahoujin;
            MahoujinRenderer.cupRender(cup, partialTicks, matrix, iRenderTypeBuffer, v1, v2);
        }
        if (mahoujin instanceof ScryingMahoujinTileEntity) {
            ScryingMahoujinTileEntity scry = (ScryingMahoujinTileEntity)mahoujin;
            MahoujinRenderer.scryingRender(scry, partialTicks, matrix, iRenderTypeBuffer, v1, v2);
        }
    }

    public static void scryingRender(ScryingMahoujinTileEntity scrying, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int v1, int v2) {
        LivingEntity e = scrying.getScryTarget();
        stack.func_227860_a_();
        if (e != null) {
            float offset;
            BlockPos pos = scrying.func_174877_v();
            float xx = offset = 0.5f;
            float yy = offset;
            float zz = offset;
            float scale = 0.2f;
            double scaleall = 0.2;
            double invscaleall = 1.0 / scaleall;
            stack.func_227861_a_((double)xx, (double)yy, (double)zz);
            stack.func_227862_a_(scale, scale, scale);
            float f = MathHelper.func_219799_g((float)partialTicks, (float)e.field_70126_B, (float)e.field_70177_z);
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)e, 0.0, 0.0, 0.0, partialTicks, f, stack, buffer, v1);
            stack.func_227861_a_(invscaleall * -0.125, 0.0, invscaleall * -0.125);
            if (scrying.targetPos != null) {
                stack.func_227861_a_(-0.5 * (scrying.targetPos.field_72450_a - Math.floor(scrying.targetPos.field_72450_a)), -0.5 * (scrying.targetPos.field_72448_b - Math.floor(scrying.targetPos.field_72448_b)), -0.5 * (scrying.targetPos.field_72449_c - Math.floor(scrying.targetPos.field_72449_c)));
            }
            if (scrying.lst != null && scrying.lst.size() > 0) {
                int index = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 2 && index < scrying.lst.size(); ++index, ++k) {
                            ScryingMahoujinTileEntity.BlockPosInfo info = scrying.lst.get(index);
                            if (info.state == null || info.state.func_177230_c() == Blocks.field_150350_a || info.state.func_177230_c() == Blocks.field_201941_jj || info.state.func_177230_c() == Blocks.field_201940_ji || info.te != null) continue;
                            stack.func_227861_a_((double)i, (double)k, (double)j);
                            try {
                                Minecraft.func_71410_x().func_175602_ab().func_228791_a_(info.state, stack, buffer, v1, v2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            stack.func_227861_a_((double)(-i), (double)(-k), (double)(-j));
                        }
                    }
                }
            }
        }
        stack.func_227865_b_();
    }

    public static void cupRender(CupOfHeavenMahoujinTileEntity cup, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int v1, int v2) {
        float size;
        matrix.func_227860_a_();
        float yv = cup.func_174877_v().func_177956_o();
        if (yv <= 0.0f) {
            yv = 1.0f;
        }
        float offsetx = 0.0f;
        float offsety = 120.0f - yv;
        float offsetz = 0.0f;
        float time = cup.func_145831_w().func_72820_D() % 24000L;
        if (time > 18000.0f) {
            time -= 24000.0f;
        }
        float timeColor = Math.abs(time - 6000.0f) / 12000.0f;
        float r1 = 0.19215687f;
        float g1 = 0.007843138f;
        float b1 = 0.8901961f;
        float a1 = 1.0f;
        float r2 = 0.47058824f;
        float g2 = 0.83137256f;
        float b2 = 1.0f;
        float a2 = 1.0f;
        float r = r1 + (r2 - r1) * timeColor;
        float g = g1 + (g2 - g1) * timeColor;
        float b = b1 + (b2 - b1) * timeColor;
        float a = a1 + (a2 - a1) * timeColor;
        float rotation = cup.func_145831_w().func_72820_D();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float ring = 0.0f;
        int twopower = 0;
        rotation = rotation - 1.0f + partialTicks;
        if (yv > 80.0f) {
            size = 2.0f;
        } else {
            while (yv > 2.0f) {
                yv /= 2.0f;
                ++twopower;
            }
            size = 20.0f / (float)twopower;
        }
        if (size < 0.4f) {
            size = 0.4f;
        }
        matrix.func_227861_a_((double)offsetx + 0.5, (double)offsety, (double)offsetz + 0.5);
        matrix.func_227862_a_(size, size, size);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
        int lightmapX = 240;
        int lightmapY = 240;
        RenderType type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, true);
        IVertexBuilder bb = buffer.getBuffer(type);
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        bb.func_227888_a_(m, -0.5f * size, 0.0f, -0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, -0.5f * size, 0.0f, 0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f * size, 0.0f, 0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        bb.func_227888_a_(m, 0.5f * size, 0.0f, -0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
        RenderUtils.renderRing(matrix, buffer, 0.0, ring, size / 2.0f + 0.125f, 0.125f, 128, lightmapX, lightmapY, r, g, b, a, 0);
        matrix.func_227865_b_();
    }

    public boolean isGlobalRenderer(MahoujinTileEntity te) {
        return true;
    }

    public int getColor(int alpha, int colorValue) {
        int i = alpha;
        int j = colorValue >> 16 & 0xFF;
        int k = colorValue >> 8 & 0xFF;
        int l = colorValue & 0xFF;
        return i << 24 | l << 16 | k << 8 | j;
    }

    class MahoujinData {
        NativeImage colors;
        public final Color first = new Color(0, 0, 255, 255);
        public final Color second = new Color(0, 255, 0, 255);
        public final Color third = new Color(255, 255, 0, 255);
        public String texName = "mahoujin";
        public DynamicTexture dynamicTexture;
        public ResourceLocation texLocation;

        public MahoujinData(ArrayList<String> order) {
            for (int i = 0; i < order.size(); ++i) {
                this.texName = this.texName + "_" + order.get(i);
            }
            this.dynamicTexture = new DynamicTexture(S_WIDTH, S_HEIGHT, true);
            this.texLocation = ((MahoujinRenderer)MahoujinRenderer.this).field_228858_b_.field_147553_e.func_110578_a("mahoutsukai/" + this.texName, this.dynamicTexture);
            this.colors = this.dynamicTexture.func_195414_e();
        }

        public void changeMahoujin(ArrayList<String> order) {
            Color newFirst = new Color(0, 0, 0, 0);
            Color newSecond = new Color(0, 0, 0, 0);
            Color newThird = new Color(0, 0, 0, 0);
            if (order.size() > 0) {
                if (!order.get(0).equals("fay")) {
                    newFirst = ModItems.catalystMap.get((Object)order.get((int)0)).COLOR;
                }
                if (order.size() > 1) {
                    if (!order.get(1).equals("fay")) {
                        newSecond = ModItems.catalystMap.get((Object)order.get((int)1)).COLOR;
                    }
                    if (order.size() > 2 && !order.get(2).equals("fay")) {
                        newThird = ModItems.catalystMap.get((Object)order.get((int)2)).COLOR;
                    }
                }
            }
            int firstRGB = MahoujinRenderer.this.getColor(this.first.getAlpha(), this.first.getRGB());
            int secondRGB = MahoujinRenderer.this.getColor(this.second.getAlpha(), this.second.getRGB());
            int thirdRGB = MahoujinRenderer.this.getColor(this.third.getAlpha(), this.third.getRGB());
            for (int i = 0; i < S_WIDTH; ++i) {
                for (int j = 0; j < S_HEIGHT; ++j) {
                    int pixel = this.colors.func_195709_a(i, j);
                    if (pixel == firstRGB) {
                        this.colors.func_195700_a(i, j, MahoujinRenderer.this.getColor(newFirst.getAlpha(), newFirst.getRGB()));
                        continue;
                    }
                    if (pixel == secondRGB) {
                        this.colors.func_195700_a(i, j, MahoujinRenderer.this.getColor(newSecond.getAlpha(), newSecond.getRGB()));
                        continue;
                    }
                    if (pixel != thirdRGB) continue;
                    this.colors.func_195700_a(i, j, MahoujinRenderer.this.getColor(newThird.getAlpha(), newThird.getRGB()));
                }
            }
            try {
                this.dynamicTexture = new DynamicTexture(this.colors);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            this.dynamicTexture.func_110564_a();
            this.texLocation = ((MahoujinRenderer)MahoujinRenderer.this).field_228858_b_.field_147553_e.func_110578_a("mahoutsukai/" + this.texName, this.dynamicTexture);
        }

        public void render(MahoujinTileEntity te, MatrixStack matrix, IRenderTypeBuffer buffer) {
            BoundaryMahoujinTileEntity mte;
            boolean renderCloth = te.hasCloth();
            int lightmapX = 128;
            int lightmapY = 240;
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.0, 0.5);
            float rr = 1.0f;
            float gg = 1.0f;
            float bb = 1.0f;
            float aa = 1.0f;
            Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
            RenderType type = MahoujinRenderType.createMahoujinRenderType(MahoujinRenderer.this.spellClothLocation, 0, false);
            IVertexBuilder b = buffer.getBuffer(type);
            if (renderCloth) {
                int clothlightX = 100;
                int clothlightY = 100;
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(clothlightX += 20, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(clothlightX, clothlightY).func_181675_d();
            }
            type = MahoujinRenderType.createMahoujinRenderType(this.texLocation, 0, false);
            b = buffer.getBuffer(type);
            if (te instanceof BoundaryMahoujinTileEntity && (mte = (BoundaryMahoujinTileEntity)te).shouldIPerformBarrier()) {
                RenderUtils.rotateQ((float)((double)mte.func_145831_w().func_72820_D() * MTConfig.BOUNDARY_SPEED % 360.0), 0.0f, 1.0f, 0.0f, matrix);
            }
            if (!renderCloth) {
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
                b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
                b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            }
            type = MahoujinRenderType.createMahoujinRenderType(this.texLocation, 1, false);
            b = buffer.getBuffer(type);
            b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, 0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            b.func_227888_a_(positionMatrix, 0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            b.func_227888_a_(positionMatrix, -0.5f, 0.0625f, -0.5f).func_227885_a_(rr, gg, bb, aa).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            matrix.func_227865_b_();
        }
    }
}

