/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.tile.SingleUseMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BoundaryMahoujinTileEntity
extends SingleUseMahoujinTileEntity
implements ITickableTileEntity {
    private static final String SWITCH_ON = "SWITCH_ON";
    private static final int TICKS_PER_SECOND = 20;
    public HashSet<UUID> entitiesInBarrier = null;
    private boolean switchOn = false;
    private boolean performBarrierFunction = false;
    private int tickCounter = 0;
    private int manaTickCounter = 0;
    private boolean livingOnly = true;

    public BoundaryMahoujinTileEntity() {
        this.livingOnly = true;
    }

    public BoundaryMahoujinTileEntity(boolean l) {
        this.livingOnly = l;
    }

    public BoundaryMahoujinTileEntity(TileEntityType type) {
        super(type);
        this.livingOnly = true;
    }

    public BoundaryMahoujinTileEntity(TileEntityType type, boolean livingOnly) {
        this(type);
        this.livingOnly = livingOnly;
    }

    public int getManaCost() {
        return 0;
    }

    public int getManaCycle() {
        return 20;
    }

    public int getBarrierCycle() {
        return 20;
    }

    public int getBarrierRadius() {
        return 10;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a(SWITCH_ON, this.switchOn);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.switchOn = compound.func_74767_n(SWITCH_ON);
        super.func_230337_a_(state, compound);
    }

    public void toggle(PlayerEntity e) {
        if (ContractMahoujinTileEntity.isImmuneToSpell(this.field_145850_b, this.getCasterUUID(), (Entity)e) || this.isFay()) {
            if (this.isFay()) {
                this.setCaster(e);
            }
            this.performBarrierFunction = this.switchOn = !this.switchOn;
            this.manaTickCounter = 0;
            this.tickCounter = 0;
            this.sendUpdates();
        }
    }

    public boolean getSwitchOn() {
        return this.switchOn;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.manaTickCounter == this.getManaCycle() * 20) {
                boolean nearbyBatteriesGaveMana;
                IMahou mahou;
                this.manaTickCounter = 0;
                PlayerEntity caster = this.getCaster();
                boolean redstoneSwitchOn = this.shouldIPerformBarrier();
                if (caster != null && redstoneSwitchOn && (mahou = Utils.getPlayerMahou((LivingEntity)caster)) != null && caster.field_70170_p.func_82737_E() - mahou.getCancelTime() < (long)(this.getManaCycle() * 20 * 3)) {
                    this.toggle(caster);
                }
                boolean bl = nearbyBatteriesGaveMana = redstoneSwitchOn && PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), this.getManaCost());
                if (!nearbyBatteriesGaveMana && caster == null && redstoneSwitchOn) {
                    redstoneSwitchOn = false;
                    this.manaTickCounter = 0;
                    this.tickCounter = 0;
                    this.sendUpdates();
                }
                this.performBarrierFunction = !redstoneSwitchOn ? false : (!nearbyBatteriesGaveMana ? PlayerManaManager.drainMana(caster, this.getManaCost(), false, true) == this.getManaCost() : true);
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
            if (this.tickCounter == this.getBarrierCycle()) {
                this.tickCounter = 0;
                if (this.performBarrierFunction) {
                    AxisAlignedBB aabb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.getBarrierRadius()), (double)(this.field_174879_c.func_177956_o() - this.getBarrierRadius()), (double)(this.field_174879_c.func_177952_p() - this.getBarrierRadius()), (double)(this.field_174879_c.func_177958_n() + this.getBarrierRadius()), (double)(this.field_174879_c.func_177956_o() + this.getBarrierRadius()), (double)(this.field_174879_c.func_177952_p() + this.getBarrierRadius()));
                    if (this.livingOnly) {
                        List entities = this.field_145850_b.func_175647_a(LivingEntity.class, aabb, null);
                        this.doBarrier(entities);
                        this.entitiesInBarrier = new HashSet(entities.stream().map(Entity::func_110124_au).collect(Collectors.toCollection(HashSet::new)));
                    } else {
                        List entities = this.field_145850_b.func_175647_a(Entity.class, aabb, null);
                        this.doBarrierNonLiving(entities);
                    }
                } else {
                    this.doNotBarrier();
                }
            }
            ++this.tickCounter;
            ++this.manaTickCounter;
        }
    }

    public void doBarrier(List<LivingEntity> lst) {
    }

    public void doNotBarrier() {
    }

    public boolean shouldIPerformBarrier() {
        boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.getCasterUUID() == null) {
            return false;
        }
        if (powered) {
            return !this.switchOn;
        }
        return this.switchOn;
    }

    public void doBarrierNonLiving(List<Entity> lst) {
    }

    public void pickupOrToggle(World worldIn, PlayerEntity playerIn) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(this.field_174879_c)) instanceof BoundaryMahoujinTileEntity) {
            BoundaryMahoujinTileEntity mte = (BoundaryMahoujinTileEntity)te;
            if (!mte.hasCloth()) {
                mte.toggle(playerIn);
            } else if (this.field_145850_b != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, EffectUtil.AIR);
            }
        }
    }
}

