/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;

public class InvisibleBarrierBlockTileEntity
extends UpdatingTileEntity {
    private UUID casterUUID;
    public BlockPos boundaryCircle;
    public long timeN = 21L;
    public long timeE = 21L;
    public long timeW = 21L;
    public long timeS = 21L;
    public long timeU = 21L;
    public long timeD = 21L;
    public static final int fadeTicks = 20;
    public static int updateWhiteListTicks = 20;
    public static final String CASTER_ID = "caster_uuid";
    public static final String TIME_SINCE_COLLISION = "time_since_last_collision";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_X = "original_boundary_circle_x";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Y = "original_boundary_circle_y";
    public static final String ORIGINAL_BOUNDARY_CIRCLE_Z = "original_boundary_circle_z";
    public static final String WHITELIST_TAG = "whitelist";
    public HashSet<UUID> whitelist;

    public InvisibleBarrierBlockTileEntity() {
        super(ModTileEntities.invisibleBarrier);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.casterUUID != null) {
            compound.func_186854_a(CASTER_ID, this.casterUUID);
        }
        compound.func_74772_a("time_since_last_collisionN", this.timeN);
        compound.func_74772_a("time_since_last_collisionE", this.timeE);
        compound.func_74772_a("time_since_last_collisionW", this.timeW);
        compound.func_74772_a("time_since_last_collisionS", this.timeS);
        compound.func_74772_a("time_since_last_collisionU", this.timeU);
        compound.func_74772_a("time_since_last_collisionD", this.timeD);
        if (this.boundaryCircle != null) {
            compound.func_74768_a(ORIGINAL_BOUNDARY_CIRCLE_X, this.boundaryCircle.func_177958_n());
            compound.func_74768_a(ORIGINAL_BOUNDARY_CIRCLE_Y, this.boundaryCircle.func_177956_o());
            compound.func_74768_a(ORIGINAL_BOUNDARY_CIRCLE_Z, this.boundaryCircle.func_177952_p());
        }
        if (this.whitelist != null) {
            CompoundNBT tmp = new CompoundNBT();
            int z = 0;
            for (UUID uuid : this.whitelist) {
                tmp.func_186854_a("MAHOUTSUKAI_WHITELIST_" + z, uuid);
            }
            compound.func_218657_a(WHITELIST_TAG, (INBT)tmp);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.casterUUID = compound.func_186855_b(CASTER_ID) ? compound.func_186857_a(CASTER_ID) : null;
        this.timeN = compound.func_74763_f("time_since_last_collisionN");
        this.timeE = compound.func_74763_f("time_since_last_collisionE");
        this.timeW = compound.func_74763_f("time_since_last_collisionW");
        this.timeS = compound.func_74763_f("time_since_last_collisionS");
        this.timeU = compound.func_74763_f("time_since_last_collisionU");
        this.timeD = compound.func_74763_f("time_since_last_collisionD");
        if (compound.func_74764_b(ORIGINAL_BOUNDARY_CIRCLE_X) && compound.func_74764_b(ORIGINAL_BOUNDARY_CIRCLE_Y) && compound.func_74764_b(ORIGINAL_BOUNDARY_CIRCLE_Z)) {
            this.boundaryCircle = new BlockPos(compound.func_74762_e(ORIGINAL_BOUNDARY_CIRCLE_X), compound.func_74762_e(ORIGINAL_BOUNDARY_CIRCLE_Y), compound.func_74762_e(ORIGINAL_BOUNDARY_CIRCLE_Z));
        }
        if (compound.func_74764_b(WHITELIST_TAG)) {
            CompoundNBT nbt;
            if (this.whitelist == null) {
                this.whitelist = new HashSet();
            }
            if ((nbt = (CompoundNBT)compound.func_74781_a(WHITELIST_TAG)) != null) {
                for (String s : nbt.func_150296_c()) {
                    this.whitelist.add(nbt.func_186857_a(s));
                }
            }
        }
        super.func_230337_a_(state, compound);
    }

    public long getTimeSinceCollision(Direction facing) {
        if (this.field_145850_b != null) {
            if (facing == Direction.NORTH) {
                return this.field_145850_b.func_82737_E() - this.timeN;
            }
            if (facing == Direction.EAST) {
                return this.field_145850_b.func_82737_E() - this.timeE;
            }
            if (facing == Direction.WEST) {
                return this.field_145850_b.func_82737_E() - this.timeW;
            }
            if (facing == Direction.SOUTH) {
                return this.field_145850_b.func_82737_E() - this.timeS;
            }
            if (facing == Direction.DOWN) {
                return this.field_145850_b.func_82737_E() - this.timeD;
            }
            if (facing == Direction.UP) {
                return this.field_145850_b.func_82737_E() - this.timeU;
            }
        }
        return 21L;
    }

    public void setTimeOfCollision(long t, Direction facing) {
        if (facing == Direction.NORTH) {
            this.timeN = t;
        }
        if (facing == Direction.EAST) {
            this.timeE = t;
        }
        if (facing == Direction.WEST) {
            this.timeW = t;
        }
        if (facing == Direction.SOUTH) {
            this.timeS = t;
        }
        if (facing == Direction.DOWN) {
            this.timeD = t;
        }
        if (facing == Direction.UP) {
            this.timeU = t;
        }
        this.sendUpdates();
    }

    public PlayerEntity getCaster() {
        try {
            PlayerEntity caster = this.field_145850_b.func_217371_b(this.casterUUID);
            return caster;
        }
        catch (Exception e) {
            return null;
        }
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setBoundaryCircle(BlockPos p) {
        this.boundaryCircle = p;
        this.sendUpdates();
    }

    public void setCaster(PlayerEntity caster) {
        this.casterUUID = caster.func_110124_au();
        this.sendUpdates();
    }
}

