/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.worldsave.MahouSavedData;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;

public class TangibleBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public List<BlockPos> lst = null;

    public TangibleBoundaryMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.tangibleBoundary);
    }

    @Override
    public int getManaCost() {
        return MTConfig.TANGIBLE_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.TANGIBLE_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.TANGIBLE_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.TANGIBLE_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        if (this.lst == null) {
            this.lst = TangibleBoundaryMahoujinTileEntity.getBox(this.field_174879_c, this.getBarrierRadius()).map(a -> new BlockPos((Vector3i)a)).filter(a -> a.func_177958_n() == this.field_174879_c.func_177958_n() - this.getBarrierRadius() || a.func_177958_n() == this.field_174879_c.func_177958_n() + this.getBarrierRadius() || a.func_177956_o() == this.field_174879_c.func_177956_o() - this.getBarrierRadius() || a.func_177956_o() == this.field_174879_c.func_177956_o() + this.getBarrierRadius() || a.func_177952_p() == this.field_174879_c.func_177952_p() - this.getBarrierRadius() || a.func_177952_p() == this.field_174879_c.func_177952_p() + this.getBarrierRadius()).collect(Collectors.toList());
        }
        this.placeAllBarriers(this.lst);
    }

    public static Stream<BlockPos> getBox(BlockPos pos, int radius) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius));
    }

    public static void removeAllBarriers(BlockPos pos, int radius, World world) {
        ChunkPos chunkBottom = new ChunkPos(pos.func_177982_a(-radius, -radius, -radius));
        ChunkPos chunkTop = new ChunkPos(pos.func_177982_a(radius, radius, radius));
        HashSet toremove = new HashSet();
        for (int i = chunkBottom.field_77276_a; i <= chunkTop.field_77276_a; ++i) {
            for (int j = chunkBottom.field_77275_b; j <= chunkTop.field_77275_b; ++j) {
                Chunk c = world.func_212866_a_(i, j);
                for (Map.Entry entry : c.func_177434_r().entrySet()) {
                    if (!(entry.getValue() instanceof InvisibleBarrierBlockTileEntity)) continue;
                    toremove.add(entry.getKey());
                }
            }
        }
        for (BlockPos p : toremove) {
            world.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public void doNotBarrier() {
        TangibleBoundaryMahoujinTileEntity.removeAllBarriers(this.field_174879_c, this.getBarrierRadius(), this.field_145850_b);
    }

    public void placeAllBarriers(List<BlockPos> box) {
        HashSet<UUID> wl = this.getWhitelist();
        box.forEach(tmp -> {
            if (tmp.func_177958_n() == this.field_174879_c.func_177958_n() - this.getBarrierRadius() || tmp.func_177958_n() == this.field_174879_c.func_177958_n() + this.getBarrierRadius() || tmp.func_177956_o() == this.field_174879_c.func_177956_o() - this.getBarrierRadius() || tmp.func_177956_o() == this.field_174879_c.func_177956_o() + this.getBarrierRadius() || tmp.func_177952_p() == this.field_174879_c.func_177952_p() - this.getBarrierRadius() || tmp.func_177952_p() == this.field_174879_c.func_177952_p() + this.getBarrierRadius()) {
                Block b = this.field_145850_b.func_180495_p(tmp).func_177230_c();
                TileEntity te = this.field_145850_b.func_175625_s(tmp);
                if (b instanceof AirBlock || b instanceof TallGrassBlock || b instanceof FlowerBlock) {
                    this.field_145850_b.func_175656_a(tmp, ModBlocks.invisibleBarrierBlock.func_176223_P());
                    te = this.field_145850_b.func_175625_s(tmp);
                    if (te != null) {
                        ((InvisibleBarrierBlockTileEntity)te).setCasterUUID(this.getCasterUUID());
                        ((InvisibleBarrierBlockTileEntity)te).setBoundaryCircle(this.field_174879_c);
                        ((InvisibleBarrierBlockTileEntity)te).whitelist = wl;
                    }
                } else if (te instanceof InvisibleBarrierBlockTileEntity && !wl.equals(((InvisibleBarrierBlockTileEntity)te).whitelist)) {
                    ((InvisibleBarrierBlockTileEntity)te).whitelist = wl;
                    ((InvisibleBarrierBlockTileEntity)te).sendUpdates();
                }
            }
        });
    }

    public HashSet<UUID> getWhitelist() {
        MahouSavedData save = new MahouSavedData(this.field_145850_b);
        HashSet<UUID> ret = new HashSet<UUID>();
        if (save != null && save.playerContracts != null && save.playerContracts.containsKey((Object)this.getCasterUUID())) {
            ret = new HashSet(save.playerContracts.get((Object)this.getCasterUUID()));
        }
        return ret;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((IItemProvider)ModItems.boundaryTangibleScroll);
    }
}

