/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class AlchemicalExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private int tickCounter = 0;
    private long placedTime = 0L;
    private int processingLayer = 0;
    private static final String PLACED_TIME_TAG = "MAHOUTSUKAI_PLACED_TIME_TAG";
    private static final String PROCESSING_LAYER_TAG = "MAHOUTSUKAI_PROCESSING_LAYER_TAG";
    private static HashSet<BlockState> dirtClass = new HashSet();
    private static HashSet<BlockState> stoneClass = new HashSet();
    private static HashSet<BlockState> gemClass = new HashSet();
    private static HashSet<BlockState> metalClass = new HashSet();
    private static HashSet<BlockState> clayClass = new HashSet();
    private static HashSet<BlockState> woodClass = new HashSet();
    private static HashSet<BlockState> grassClass = new HashSet();
    private static HashSet<BlockState> specialClass = new HashSet();
    private static HashSet<BlockState> fluidClass = new HashSet();
    private static HashSet<BlockState> movingFluidClass = new HashSet();
    private static ArrayList<HashSet> blockClasses = new ArrayList();
    private ArrayList<Integer> indices = null;

    public AlchemicalExchangeMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.alchemicalExchange);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter == MTConfig.ALCHEMICAL_EXCHANGE_BLOCK_CYCLE) {
                this.transformLayers();
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void setPlacedTime(long t) {
        this.placedTime = t;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a(PROCESSING_LAYER_TAG, this.processingLayer);
        compound.func_74772_a(PLACED_TIME_TAG, this.placedTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.placedTime = compound.func_74763_f(PLACED_TIME_TAG);
        this.processingLayer = compound.func_74762_e(PROCESSING_LAYER_TAG);
        super.func_230337_a_(state, compound);
    }

    public void transformLayers() {
        long p = this.field_145850_b.func_72820_D() % 24000L;
        if (p < 0L) {
            p += 24000L;
        }
        p -= p % 20L;
        if (this.indices == null) {
            this.indices = this.generateIndices(blockClasses, this.getCaster());
        }
        if (p == this.placedTime) {
            this.processingLayer = 1;
            this.transformLayer(this.processingLayer, this.indices, this.getCaster());
        } else if (this.processingLayer > 0) {
            this.transformLayer(this.processingLayer, this.indices, this.getCaster());
            ++this.processingLayer;
            if (this.processingLayer >= MTConfig.ALCHEMICAL_EXCHANGE_HEIGHT) {
                this.processingLayer = 0;
                this.indices = null;
            }
        }
    }

    public ArrayList<Integer> generateIndices(ArrayList<HashSet> lengths, PlayerEntity player) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int z = 0; z < lengths.size(); ++z) {
            ret.add(this.field_145850_b.field_73012_v.nextInt(lengths.get(z).size()));
        }
        return ret;
    }

    public boolean transformLayer(int layer, ArrayList<Integer> indices, PlayerEntity player) {
        Stream layerBlocks = BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-2, -layer, -2), (BlockPos)this.field_174879_c.func_177982_a(2, -layer, 2));
        layerBlocks.forEach(tmp -> {
            Block b = this.field_145850_b.func_180495_p(tmp).func_177230_c();
            if (!Utils.isBlockAir(this.field_145850_b, tmp)) {
                boolean nearbyBatteriesGaveMana;
                int liquid = this.field_145850_b.field_73012_v.nextInt(2);
                BlockState tb = null;
                if (b instanceof FlowingFluidBlock) {
                    tb = new ArrayList<BlockState>(fluidClass).get(liquid);
                } else {
                    for (int i = 0; i < blockClasses.size(); ++i) {
                        int target;
                        HashSet s = blockClasses.get(i);
                        if (!s.contains(this.field_145850_b.func_180495_p(tmp)) || (target = i < indices.size() ? (Integer)indices.get(i) : 0) >= s.size()) continue;
                        tb = (BlockState)new ArrayList(s).get(target);
                        break;
                    }
                }
                if (tb != null && ((nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST)) || player != null && PlayerManaManager.drainMana(player, MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST, false, false) == MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST)) {
                    EffectUtil.tryChangeBlockState(false, tmp, tb, this.field_145850_b, this.getCaster());
                    if (player != null) {
                        PlayerManaManager.updateClientMahou((ServerPlayerEntity)player, Utils.getPlayerMahou((LivingEntity)player));
                    }
                }
            }
        });
        return true;
    }

    public static Block getBlockFromRegistryName(String registryName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
    }

    public static void init() {
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(dirtClass, MTConfig.ALCHEMICAL_DIRT_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(stoneClass, MTConfig.ALCHEMICAL_STONE_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(metalClass, MTConfig.ALCHEMICAL_METAL_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(gemClass, MTConfig.ALCHEMICAL_GEM_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(clayClass, MTConfig.ALCHEMICAL_CLAY_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(woodClass, MTConfig.ALCHEMICAL_WOOD_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(specialClass, MTConfig.ALCHEMICAL_SPECIAL_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(grassClass, MTConfig.ALCHEMICAL_GRASS_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(fluidClass, MTConfig.ALCHEMICAL_FLUID_CLASS);
        AlchemicalExchangeMahoujinTileEntity.addBlocksToList(movingFluidClass, MTConfig.ALCHEMICAL_MOVING_FLUID_CLASS);
        blockClasses.add(dirtClass);
        blockClasses.add(stoneClass);
        blockClasses.add(metalClass);
        blockClasses.add(gemClass);
        blockClasses.add(clayClass);
        blockClasses.add(woodClass);
        blockClasses.add(specialClass);
        blockClasses.add(grassClass);
    }

    public static void addBlocksToList(HashSet<BlockState> lst, List<String> registryNames) {
        for (int i = 0; i < registryNames.size(); ++i) {
            String s = registryNames.get(i);
            String[] variant = s.split("@");
            if (variant.length <= 0) continue;
            Block b = AlchemicalExchangeMahoujinTileEntity.getBlockFromRegistryName(variant[0]);
            if (b == null || b == Blocks.field_150350_a) {
                System.out.println("Mahou Tsukai Alchemical Exchange: Registry block " + s + " not found.");
                continue;
            }
            BlockState bs = b.func_176223_P();
            lst.add(bs);
        }
    }
}

