/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class JmUI
extends Screen {
    protected final String title;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected Screen returnDisplay;
    protected int scaleFactor = 1;
    protected TextureImpl logo = TextureCache.getTexture(TextureCache.Logo);

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, Screen returnDisplay) {
        super((ITextComponent)new StringTextComponent(title));
        this.title = title;
        this.returnDisplay = returnDisplay;
        if (this.returnDisplay != null && this.returnDisplay instanceof JmUI) {
            JmUI jmReturnDisplay = (JmUI)this.returnDisplay;
            if (jmReturnDisplay.returnDisplay instanceof JmUI) {
                jmReturnDisplay.returnDisplay = null;
            }
        }
    }

    public Minecraft getMinecraft() {
        this.minecraft = Minecraft.func_71410_x();
        return this.minecraft;
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        this.scaleFactor = (int)minecraft.func_228018_at_().func_198100_s();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public FontRenderer getFontRenderer() {
        return this.font;
    }

    public void sizeDisplay(boolean scaled) {
        int glwidth = scaled ? this.width : this.minecraft.func_228018_at_().func_198105_m();
        int glheight = scaled ? this.height : this.minecraft.func_228018_at_().func_198083_n();
        DrawUtil.sizeDisplay(glwidth, glheight);
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.buttons.size(); ++k) {
            Button button;
            net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.buttons.get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseEvent) {
        return super.mouseReleased(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo() {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n());
        DrawUtil.drawImage(this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(this.width, this.height);
    }

    protected void drawTitle() {
        DrawUtil.drawRectangle(0.0, 0.0, this.width, 35.0, 0, 0.4f);
        DrawUtil.drawLabel(this.title, this.width / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v1.5-SNAPSHOT";
        DrawUtil.drawLabel(apiVersion, this.width - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void init() {
        this.buttons.clear();
    }

    public void renderBackground() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            this.drawGradientRect(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            super.renderBackground();
        }
    }

    protected abstract void layoutButtons();

    public List getButtonList() {
        return this.buttons;
    }

    public void render(int x, int y, float par3) {
        try {
            this.renderBackground();
            this.layoutButtons();
            this.drawTitle();
            this.drawLogo();
            List<String> tooltip = null;
            for (int k = 0; k < this.buttons.size(); ++k) {
                Button button;
                net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.buttons.get(k);
                guibutton.render(x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderTooltip(tooltip, x, y, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        super.fillGradient(p_73733_1_, p_73733_2_, p_73733_3_, p_73733_4_, p_73733_5_, p_73733_6_);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (this.returnDisplay == null) {
            if (this.minecraft.field_71441_e != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            if (this.returnDisplay instanceof JmUI) {
                ((JmUI)this.returnDisplay).returnDisplay = null;
            }
            UIManager.INSTANCE.open(this.returnDisplay);
        }
    }

    public boolean charTyped(char c, int i) {
        return super.charTyped(c, i);
    }

    public boolean keyPressed(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.keyPressed(key, value, modifier);
    }

    public void renderTooltip(String[] tooltip, int mouseX, int mouseY) {
        this.renderTooltip(Arrays.asList(tooltip), mouseX, mouseY, this.getFontRenderer());
    }

    public Screen getReturnDisplay() {
        return this.returnDisplay;
    }

    public void renderTooltip(List tooltip, int mouseX, int mouseY, FontRenderer fontRenderer) {
        if (!tooltip.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int maxLineWidth = 0;
            for (String line : tooltip) {
                int lineWidth = fontRenderer.func_78256_a(line);
                if (fontRenderer.func_78260_a()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.width) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.height) {
                drawY = this.height - boxHeight - 6;
            }
            this.setBlitOffset(300);
            this.itemRenderer.field_77023_b = 300.0f;
            int j1 = -267386864;
            this.drawGradientRect(drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1);
            this.drawGradientRect(drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1);
            this.drawGradientRect(drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1);
            this.drawGradientRect(drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                String line = (String)tooltip.get(i2);
                if (fontRenderer.func_78260_a()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.func_78256_a(line) * 1.1);
                    fontRenderer.func_175063_a(line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1);
                } else {
                    fontRenderer.func_175063_a(line, (float)drawX, (float)drawY, -1);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            this.setBlitOffset(0);
            this.itemRenderer.field_77023_b = 0.0f;
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderHelper.func_227780_a_();
            GL11.glEnable((int)32826);
        }
    }
}

