/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.mirror;

import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.multiple.DoubleWideFurnitureStorage;
import com.mcwfurnitures.kikoz.storage.FurnitureTileEntityDouble;
import com.mcwfurnitures.kikoz.util.parts.DoubleWidePart;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DoubleWideFurnitureMirror
extends DoubleWideFurnitureStorage
implements IWaterLoggable {
    private static final EnumProperty<DoubleWidePart> PART = EnumProperty.func_177709_a((String)"part", DoubleWidePart.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    private static final Map<Direction, VoxelShape> FURN_BOTTOM = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> ROOF_RIGHT = new HashMap<Direction, VoxelShape>();
    String infoname;
    boolean hasTextInfo = true;

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        DoubleWidePart part = (DoubleWidePart)((Object)state.func_177229_b(PART));
        if (part == DoubleWidePart.BOTTOM) {
            return FURN_BOTTOM.get(state.func_177229_b((IProperty)FACING));
        }
        if (part == DoubleWidePart.MIDDLE) {
            return ROOF_RIGHT.get(state.func_177229_b((IProperty)FACING));
        }
        return FURN_BOTTOM.get(state.func_177229_b((IProperty)FACING));
    }

    @Override
    public void place(World world, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)DoubleWidePart.BOTTOM))).func_206870_a((IProperty)FACING, (Comparable)direction);
        world.func_180501_a(pos, state, 3);
        this.place(world, pos, state, direction.func_176734_d());
    }

    @Override
    public void place(World world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos RoofBottomRightPos = this.getRoofBottomRightPos(pos, direction);
        IFluidState bottomEastFluidState = world.func_204610_c(pos.func_177974_f());
        world.func_180501_a(RoofBottomRightPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)DoubleWidePart.MIDDLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(bottomEastFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            this.place(world, pos, state, entity.func_174811_aO());
        }
    }

    @Override
    public void remove(World world, BlockPos pos, BlockState state) {
        BlockPos RoofPartPos;
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos RoofPos = this.getRoofPos(pos, (DoubleWidePart)((Object)state.func_177229_b(PART)), facing);
        BlockState RoofBlockState = world.func_180495_p(RoofPos);
        if (RoofBlockState.func_177230_c() == this && !pos.equals((Object)RoofPos)) {
            this.removePart(world, RoofPos, RoofBlockState);
        }
        if ((RoofBlockState = world.func_180495_p(RoofPartPos = this.getRoofBottomLeftPos(RoofPos, facing))).func_177230_c() == this && !pos.equals((Object)RoofPartPos)) {
            this.removePart(world, RoofPartPos, RoofBlockState);
        }
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.remove(world, pos, state);
        super.func_176208_a(world, pos, state, player);
    }

    private BlockPos getRoofBottomLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177976_e();
            }
            case EAST: {
                return base.func_177978_c();
            }
            case SOUTH: {
                return base.func_177974_f();
            }
            case WEST: {
                return base.func_177968_d();
            }
        }
        return base.func_177974_f();
    }

    private BlockPos getRoofBottomRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177974_f();
            }
            case EAST: {
                return base.func_177968_d();
            }
            case SOUTH: {
                return base.func_177976_e();
            }
            case WEST: {
                return base.func_177978_c();
            }
        }
        return base.func_177976_e();
    }

    private BlockPos getRoofPos(BlockPos pos, DoubleWidePart part, Direction facing) {
        if (part == DoubleWidePart.BOTTOM) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177974_f();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177968_d();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177976_e();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177978_c();
                    }
                }
                return null;
            }
        }
        return null;
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        IFluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos RoofBottomLeftPos = this.getRoofBottomLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos RoofBottomRightPos = this.getRoofBottomRightPos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && RoofBottomLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(RoofBottomLeftPos).func_196953_a(context) && RoofBottomRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(RoofBottomRightPos).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a(PART, (Comparable)((Object)DoubleWidePart.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext context) {
        boolean flag1;
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        BlockPos blockpos1 = blockpos.func_177984_a();
        Direction direction1 = direction.func_176735_f();
        BlockPos blockpos2 = blockpos.func_177972_a(direction1);
        BlockState blockstate = iblockreader.func_180495_p(blockpos2);
        BlockPos blockpos3 = blockpos1.func_177972_a(direction1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos3);
        Direction direction2 = direction.func_176746_e();
        BlockPos blockpos4 = blockpos.func_177972_a(direction2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos4);
        BlockPos blockpos5 = blockpos1.func_177972_a(direction2);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos5);
        int i = (blockstate.func_224756_o((IBlockReader)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.func_224756_o((IBlockReader)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.func_224756_o((IBlockReader)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.func_224756_o((IBlockReader)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.func_177230_c() == this && blockstate.func_177229_b(PART) == DoubleWidePart.BOTTOM;
        boolean bl = flag1 = blockstate2.func_177230_c() == this && blockstate2.func_177229_b(PART) == DoubleWidePart.MIDDLE;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.func_82601_c();
                int k = direction.func_82599_e();
                Vec3d vector3d = context.func_221532_j();
                double d0 = vector3d.field_72450_a - (double)blockpos.func_177958_n();
                double d1 = vector3d.field_72449_c - (double)blockpos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.STORAGE_CHEST.get()).func_200968_a();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            TileEntity tilenorth = worldIn.func_175625_s(pos.func_177985_f(-1));
            TileEntity tileeast = worldIn.func_175625_s(pos.func_177964_d(-1));
            TileEntity tilesouth = worldIn.func_175625_s(pos.func_177985_f(1));
            TileEntity tilewest = worldIn.func_175625_s(pos.func_177964_d(1));
            DoubleWidePart part = (DoubleWidePart)((Object)state.func_177229_b(PART));
            if (tile instanceof FurnitureTileEntityDouble) {
                if (part == DoubleWidePart.BOTTOM) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tile), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == DoubleWidePart.MIDDLE && state.func_177229_b((IProperty)FACING) == Direction.NORTH) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilenorth), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == DoubleWidePart.MIDDLE && state.func_177229_b((IProperty)FACING) == Direction.EAST) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tileeast), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == DoubleWidePart.MIDDLE && state.func_177229_b((IProperty)FACING) == Direction.SOUTH) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilesouth), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == DoubleWidePart.MIDDLE && state.func_177229_b((IProperty)FACING) == Direction.WEST) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilewest), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.FAIL;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntityDouble) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((FurnitureTileEntityDouble)te).func_190576_q());
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PART, HINGE, FACING, WATERLOGGED});
    }

    public DoubleWideFurnitureMirror() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)DoubleWidePart.BOTTOM)));
    }

    static {
        FURN_BOTTOM.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURN_BOTTOM.put(Direction.EAST, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURN_BOTTOM.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURN_BOTTOM.put(Direction.WEST, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        ROOF_RIGHT.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        ROOF_RIGHT.put(Direction.EAST, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        ROOF_RIGHT.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        ROOF_RIGHT.put(Direction.WEST, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }
}

