/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.multiple;

import com.mcwfurnitures.kikoz.objects.FurnitureBase;
import com.mcwfurnitures.kikoz.util.parts.LargeFurniturePart;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TwoByTwoFurniture
extends FurnitureBase
implements IWaterLoggable {
    private static final EnumProperty<LargeFurniturePart> PART = EnumProperty.func_177709_a((String)"part", LargeFurniturePart.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> FURNITURE_MIDDLE = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_MIDDLE_LEFT = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_BOTTOM = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_BOTTOM_LEFT = new HashMap<Direction, VoxelShape>();
    String infoname;
    boolean hasTextInfo = true;

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        LargeFurniturePart part = (LargeFurniturePart)((Object)state.func_177229_b(PART));
        if (part == LargeFurniturePart.BOTTOM) {
            return FURNITURE_BOTTOM.get(state.func_177229_b((IProperty)FACING));
        }
        if (part == LargeFurniturePart.BOTTOM_LEFT) {
            return FURNITURE_BOTTOM_LEFT.get(state.func_177229_b((IProperty)FACING));
        }
        if (part == LargeFurniturePart.MIDDLE) {
            return FURNITURE_MIDDLE.get(state.func_177229_b((IProperty)FACING));
        }
        if (part == LargeFurniturePart.MIDDLE_LEFT) {
            return FURNITURE_MIDDLE_LEFT.get(state.func_177229_b((IProperty)FACING));
        }
        return FURNITURE_MIDDLE.get(state.func_177229_b((IProperty)FACING));
    }

    public void place(World world, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM))).func_206870_a((IProperty)FACING, (Comparable)direction);
        world.func_180501_a(pos, state, 3);
        this.place(world, pos, state, direction.func_176734_d());
    }

    public void place(World world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos FurnitureMiddleLeftPos = this.getFurnitureMiddleLeftPos(pos, direction);
        BlockPos FurnitureBottomLeftPos = this.getFurnitureBottomLeftPos(pos, direction);
        IFluidState middleFluidState = world.func_204610_c(pos.func_177984_a());
        IFluidState middleWestFluidState = world.func_204610_c(pos.func_177984_a().func_177976_e());
        IFluidState bottomWestFluidState = world.func_204610_c(pos.func_177976_e());
        world.func_180501_a(FurnitureBottomLeftPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM_LEFT))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(bottomWestFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.MIDDLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(middleFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        world.func_180501_a(FurnitureMiddleLeftPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.MIDDLE_LEFT))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(middleWestFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            this.place(world, pos, state, entity.func_174811_aO());
        }
    }

    public void remove(World world, BlockPos pos, BlockState state) {
        BlockPos FurniturePartPos;
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos FurniturePos = this.getFurniturePos(pos, (LargeFurniturePart)((Object)state.func_177229_b(PART)), facing);
        BlockState FurnitureBlockState = world.func_180495_p(FurniturePos);
        if (FurnitureBlockState.func_177230_c() == this && !pos.equals((Object)FurniturePos)) {
            this.removePart(world, FurniturePos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddleLeftPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddleRightPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureBottomLeftPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureBottomRightPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.remove(world, pos, state);
        super.func_176208_a(world, pos, state, player);
    }

    private BlockPos getFurnitureMiddlePos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a();
            }
            case EAST: {
                return base.func_177984_a();
            }
            case SOUTH: {
                return base.func_177984_a();
            }
            case WEST: {
                return base.func_177984_a();
            }
        }
        return base.func_177984_a();
    }

    private BlockPos getFurnitureMiddleLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a().func_177976_e();
            }
            case EAST: {
                return base.func_177984_a().func_177978_c();
            }
            case SOUTH: {
                return base.func_177984_a().func_177974_f();
            }
            case WEST: {
                return base.func_177984_a().func_177968_d();
            }
        }
        return base.func_177984_a().func_177974_f();
    }

    private BlockPos getFurnitureMiddleRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a().func_177974_f();
            }
            case EAST: {
                return base.func_177984_a().func_177968_d();
            }
            case SOUTH: {
                return base.func_177984_a().func_177976_e();
            }
            case WEST: {
                return base.func_177984_a().func_177978_c();
            }
        }
        return base.func_177984_a().func_177976_e();
    }

    private BlockPos getFurnitureBottomLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177976_e();
            }
            case EAST: {
                return base.func_177978_c();
            }
            case SOUTH: {
                return base.func_177974_f();
            }
            case WEST: {
                return base.func_177968_d();
            }
        }
        return base.func_177974_f();
    }

    private BlockPos getFurnitureBottomRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177974_f();
            }
            case EAST: {
                return base.func_177968_d();
            }
            case SOUTH: {
                return base.func_177976_e();
            }
            case WEST: {
                return base.func_177978_c();
            }
        }
        return base.func_177976_e();
    }

    private BlockPos getFurniturePos(BlockPos pos, LargeFurniturePart part, Direction facing) {
        if (part == LargeFurniturePart.BOTTOM) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177976_e();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177976_e();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177978_c();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177978_c();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177974_f();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177974_f();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177968_d();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177968_d();
                    }
                }
                return null;
            }
        }
        return null;
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        IFluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos FurnitureMiddlePos = this.getFurnitureMiddlePos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureMiddleLeftPos = this.getFurnitureMiddleLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureMiddleRightPos = this.getFurnitureMiddleRightPos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureBottomLeftPos = this.getFurnitureBottomLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureBottomRightPos = this.getFurnitureBottomRightPos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && FurnitureMiddlePos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context) && FurnitureMiddleLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureMiddleLeftPos).func_196953_a(context) && FurnitureMiddleRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureMiddleRightPos).func_196953_a(context) && FurnitureBottomLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureBottomLeftPos).func_196953_a(context) && FurnitureBottomRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureBottomRightPos).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PART, FACING, WATERLOGGED});
    }

    public TwoByTwoFurniture() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM)));
    }

    static {
        FURNITURE_MIDDLE.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }
}

