/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class MBConfig {
    public static ForgeConfigSpec.IntValue mutantCreeperSpawnWeight;
    public static ForgeConfigSpec.IntValue mutantEndermanSpawnWeight;
    public static ForgeConfigSpec.IntValue mutantSkeletonSpawnWeight;
    public static ForgeConfigSpec.IntValue mutantZombieSpawnWeight;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> biomeWhitelist;

    MBConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Common configuration settings").push("common");
        mutantCreeperSpawnWeight = builder.comment(new String[]{"Mutant Creeper spawn weight", "Requires game restart"}).worldRestart().defineInRange("mutantCreeperSpawnWeight", 4, 0, 100);
        mutantEndermanSpawnWeight = builder.comment(new String[]{"Mutant Enderman spawn weight", "Requires game restart"}).worldRestart().defineInRange("mutantEndermanSpawnWeight", 3, 0, 100);
        mutantSkeletonSpawnWeight = builder.comment(new String[]{"Mutant Skeleton spawn weight", "Requires game restart"}).worldRestart().defineInRange("mutantSkeletonSpawnWeight", 4, 0, 100);
        mutantZombieSpawnWeight = builder.comment(new String[]{"Mutant Zombie spawn weight", "Requires game restart"}).worldRestart().defineInRange("mutantZombieSpawnWeight", 4, 0, 100);
        biomeWhitelist = builder.comment(new String[]{"Mutants will only spawn in the biomes from the given mod IDs", "Example - \"minecraft\", \"midnight\"", "You can see a mod's ID by clicking the 'Mods' button on the main screen and clicking on the mod's name on the left", "Requires game restart"}).defineList("biomeWhitelist", Arrays.asList("minecraft", "biomesoplenty", "byg", "omni"), String.class::isInstance);
        builder.pop();
    }
}

