/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.BodyPartEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEggEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.SkullSpiritEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.item.ChemicalXItem;
import chumbanotz.mutantbeasts.item.CreeperShardItem;
import chumbanotz.mutantbeasts.item.EndersoulHandItem;
import chumbanotz.mutantbeasts.item.HulkHammerItem;
import chumbanotz.mutantbeasts.item.MBArmorMaterial;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.item.SkeletonArmorItem;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mutantbeasts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    private static final Map<EntityType<? extends MobEntity>, SpawnEggItem> SPAWN_EGGS = new HashMap<EntityType<? extends MobEntity>, SpawnEggItem>();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.setRegistryName("chemical_x", new ChemicalXItem(RegistryHandler.defaultProperty().func_208103_a(Rarity.EPIC))), RegistryHandler.setRegistryName("creeper_minion_tracker", new Item(RegistryHandler.defaultProperty().func_200917_a(1))), RegistryHandler.setRegistryName("creeper_shard", new CreeperShardItem(RegistryHandler.defaultProperty().func_208103_a(Rarity.UNCOMMON))), RegistryHandler.setRegistryName("endersoul_hand", new EndersoulHandItem(RegistryHandler.defaultProperty().func_208103_a(Rarity.EPIC))), RegistryHandler.setRegistryName("hulk_hammer", new HulkHammerItem(RegistryHandler.defaultProperty().func_208103_a(Rarity.UNCOMMON))), RegistryHandler.setRegistryName("mutant_skeleton_arms", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("mutant_skeleton_limb", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("mutant_skeleton_pelvis", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("mutant_skeleton_rib", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("mutant_skeleton_rib_cage", new Item(RegistryHandler.defaultProperty())), RegistryHandler.setRegistryName("mutant_skeleton_shoulder_pad", new Item(RegistryHandler.defaultProperty())), (Item)RegistryHandler.setRegistryName("mutant_skeleton_skull", new SkeletonArmorItem(MBArmorMaterial.MUTANT_SKELETON, EquipmentSlotType.HEAD, RegistryHandler.defaultProperty().func_208103_a(Rarity.UNCOMMON))), (Item)RegistryHandler.setRegistryName("mutant_skeleton_chestplate", new SkeletonArmorItem(MBArmorMaterial.MUTANT_SKELETON, EquipmentSlotType.CHEST, RegistryHandler.defaultProperty())), (Item)RegistryHandler.setRegistryName("mutant_skeleton_leggings", new SkeletonArmorItem(MBArmorMaterial.MUTANT_SKELETON, EquipmentSlotType.LEGS, RegistryHandler.defaultProperty())), (Item)RegistryHandler.setRegistryName("mutant_skeleton_boots", new SkeletonArmorItem(MBArmorMaterial.MUTANT_SKELETON, EquipmentSlotType.FEET, RegistryHandler.defaultProperty()))});
        RegistryHandler.build("creeper_minion", EntityType.Builder.func_220322_a(CreeperMinionEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3f, 0.84f), 894731, 0xB7B7B7);
        RegistryHandler.build("endersoul_clone", EntityType.Builder.func_220322_a(EndersoulCloneEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.9f), 15027455, 15027455);
        RegistryHandler.build("mutant_creeper", EntityType.Builder.func_220322_a(MutantCreeperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.95f, 2.8f), 5349438, 11013646);
        RegistryHandler.build("mutant_enderman", EntityType.Builder.func_220322_a(MutantEndermanEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 4.2f), 0x161616, 8860812);
        RegistryHandler.build("mutant_skeleton", EntityType.Builder.func_220322_a(MutantSkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 3.6f), 0xC1C1C1, 6310217);
        RegistryHandler.build("mutant_snow_golem", EntityType.Builder.func_220322_a(MutantSnowGolemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.2f, 2.2f), 0xE5FFFF, 16753434);
        RegistryHandler.build("mutant_zombie", EntityType.Builder.func_220322_a(MutantZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.8f, 3.2f), 7969893, 44975);
        RegistryHandler.build("spider_pig", EntityType.Builder.func_220322_a(SpiderPigEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 0.9f), 3419431, 15771042);
        for (SpawnEggItem spawnEggItem : SPAWN_EGGS.values()) {
            event.getRegistry().register((IForgeRegistryEntry)spawnEggItem);
        }
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<? extends MobEntity> entityType : SPAWN_EGGS.keySet()) {
            event.getRegistry().register(entityType);
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{RegistryHandler.build("body_part", EntityType.Builder.func_220322_a(BodyPartEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(BodyPartEntity::new).setTrackingRange(4).setUpdateInterval(10).func_220321_a(0.7f, 0.7f)), RegistryHandler.build("chemical_x", EntityType.Builder.func_220322_a(ChemicalXEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ChemicalXEntity::new).setTrackingRange(10).setUpdateInterval(10).func_220321_a(0.25f, 0.25f)), RegistryHandler.build("creeper_minion_egg", EntityType.Builder.func_220322_a(CreeperMinionEggEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(CreeperMinionEggEntity::new).setTrackingRange(10).setUpdateInterval(20).func_220321_a(0.5625f, 0.75f)), RegistryHandler.build("endersoul_fragment", EntityType.Builder.func_220322_a(EndersoulFragmentEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(EndersoulFragmentEntity::new).setTrackingRange(64).setUpdateInterval(10).func_220321_a(0.75f, 0.75f)), RegistryHandler.build("mutant_arrow", EntityType.Builder.func_220322_a(MutantArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(MutantArrowEntity::new)), RegistryHandler.build("skull_spirit", EntityType.Builder.func_220322_a(SkullSpiritEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(SkullSpiritEntity::new).setTrackingRange(10).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).func_220321_a(0.1f, 0.1f)), RegistryHandler.build("throwable_block", EntityType.Builder.func_220322_a(ThrowableBlockEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ThrowableBlockEntity::new).setTrackingRange(4).setUpdateInterval(100).func_220321_a(1.0f, 1.0f))});
    }

    private static <T extends MobEntity> EntityType<T> build(String name, EntityType.Builder<T> builder, int eggPrimaryColor, int eggSecondaryColor) {
        EntityType<T> entityType = RegistryHandler.build(name, builder);
        SPAWN_EGGS.put(entityType, RegistryHandler.setRegistryName(name + "_spawn_egg", new SpawnEggItem(entityType, eggPrimaryColor, eggSecondaryColor, RegistryHandler.defaultProperty())));
        return entityType;
    }

    private static <T extends Entity> EntityType<T> build(String name, EntityType.Builder<T> builder) {
        ResourceLocation registryName = MutantBeasts.prefix(name);
        EntityType entityType = builder.func_206830_a(registryName.toString());
        entityType.setRegistryName(registryName);
        return entityType;
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ParticleType[]{(ParticleType)RegistryHandler.setRegistryName("endersoul", new BasicParticleType(false)), (ParticleType)RegistryHandler.setRegistryName("skull_spirit", new BasicParticleType(true))});
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegistryHandler.createSoundEvent("entity.creeper_minion.ambient"), RegistryHandler.createSoundEvent("entity.creeper_minion.death"), RegistryHandler.createSoundEvent("entity.creeper_minion.hurt"), RegistryHandler.createSoundEvent("entity.creeper_minion.primed"), RegistryHandler.createSoundEvent("entity.creeper_minion_egg.hatch"), RegistryHandler.createSoundEvent("entity.endersoul_clone.death"), RegistryHandler.createSoundEvent("entity.endersoul_clone.teleport"), RegistryHandler.createSoundEvent("entity.endersoul_fragment.explode"), RegistryHandler.createSoundEvent("entity.mutant_creeper.ambient"), RegistryHandler.createSoundEvent("entity.mutant_creeper.charge"), RegistryHandler.createSoundEvent("entity.mutant_creeper.death"), RegistryHandler.createSoundEvent("entity.mutant_creeper.hurt"), RegistryHandler.createSoundEvent("entity.mutant_creeper.primed"), RegistryHandler.createSoundEvent("entity.mutant_enderman.ambient"), RegistryHandler.createSoundEvent("entity.mutant_enderman.death"), RegistryHandler.createSoundEvent("entity.mutant_enderman.hurt"), RegistryHandler.createSoundEvent("entity.mutant_enderman.morph"), RegistryHandler.createSoundEvent("entity.mutant_enderman.scream"), RegistryHandler.createSoundEvent("entity.mutant_enderman.stare"), RegistryHandler.createSoundEvent("entity.mutant_enderman.teleport"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.ambient"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.death"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.hurt"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.step"), RegistryHandler.createSoundEvent("entity.mutant_snow_golem.death"), RegistryHandler.createSoundEvent("entity.mutant_snow_golem.hurt"), RegistryHandler.createSoundEvent("entity.mutant_zombie.ambient"), RegistryHandler.createSoundEvent("entity.mutant_zombie.attack"), RegistryHandler.createSoundEvent("entity.mutant_zombie.death"), RegistryHandler.createSoundEvent("entity.mutant_zombie.grunt"), RegistryHandler.createSoundEvent("entity.mutant_zombie.hurt"), RegistryHandler.createSoundEvent("entity.mutant_zombie.roar"), RegistryHandler.createSoundEvent("entity.spider_pig.ambient"), RegistryHandler.createSoundEvent("entity.spider_pig.death"), RegistryHandler.createSoundEvent("entity.spider_pig.hurt")});
    }

    private static SoundEvent createSoundEvent(String name) {
        ResourceLocation registryName = MutantBeasts.prefix(name);
        return (SoundEvent)new SoundEvent(registryName).setRegistryName(registryName);
    }

    @SubscribeEvent
    public static void remapParticleTypes(RegistryEvent.MissingMappings<ParticleType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.toString().equals("mutantbeasts:large_portal")) continue;
            mapping.remap((IForgeRegistryEntry)MBParticleTypes.ENDERSOUL);
        }
    }

    @SubscribeEvent
    public static void remapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String path = mapping.key.func_110623_a();
            if (!path.equals("mutant_skeleton_skull") && !path.equals("mutant_skeleton_wall_skull")) continue;
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public static void remapTileEntityTypes(RegistryEvent.MissingMappings<TileEntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().equals("skull")) continue;
            mapping.ignore();
        }
    }

    public static void registerDispenseBehavior() {
        DefaultDispenseItemBehavior defaultdispenseitembehavior = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (SpawnEggItem spawnEggItem : SPAWN_EGGS.values()) {
            DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)defaultdispenseitembehavior);
        }
        SPAWN_EGGS.clear();
        DispenserBlock.func_199774_a((IItemProvider)MBItems.CHEMICAL_X, (blockSource, itemStack) -> new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (IProjectile)Util.func_200696_a((Object)((Object)new ChemicalXEntity(position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), worldIn)), e -> e.func_213884_b(stackIn));
            }

            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        }.dispense(blockSource, itemStack));
    }

    private static Item.Properties defaultProperty() {
        return new Item.Properties().func_200916_a(MutantBeasts.ITEM_GROUP);
    }

    private static <T extends IForgeRegistryEntry<?>> T setRegistryName(String name, T entry) {
        entry.setRegistryName(MutantBeasts.prefix(name));
        return entry;
    }
}

