/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.gui.screen.CreeperMinionTrackerScreen;
import chumbanotz.mutantbeasts.client.particle.EndersoulParticle;
import chumbanotz.mutantbeasts.client.particle.SkullSpiritParticle;
import chumbanotz.mutantbeasts.client.renderer.entity.BodyPartRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.CreeperMinionEggRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.CreeperMinionRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.EndersoulCloneRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.EndersoulFragmentRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantArrowRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantCreeperRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantEndermanRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantSkeletonRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantSnowGolemRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantZombieRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.SpiderPigRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.ThrowableBlockRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperMinionShoulderLayer;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="mutantbeasts", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public enum ClientEventHandler {
    INSTANCE;

    private BipedModel<?> mutantSkeletonArmor;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            for (PlayerRenderer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
                renderer.func_177094_a(new CreeperMinionShoulderLayer(renderer));
            }
        });
        ClientRegistry.registerEntityShader(CreeperMinionEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/creeper.json"));
        ClientRegistry.registerEntityShader(EndersoulCloneEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/invert.json"));
        ClientRegistry.registerEntityShader(MutantCreeperEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/creeper.json"));
        ClientRegistry.registerEntityShader(MutantEndermanEntity.class, (ResourceLocation)new ResourceLocation("shaders/post/invert.json"));
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.BODY_PART, BodyPartRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.CHEMICAL_X, render -> new SpriteRenderer(render, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.CREEPER_MINION, CreeperMinionRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.CREEPER_MINION_EGG, CreeperMinionEggRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.ENDERSOUL_CLONE, EndersoulCloneRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.ENDERSOUL_FRAGMENT, EndersoulFragmentRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_ARROW, MutantArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_CREEPER, MutantCreeperRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_ENDERMAN, MutantEndermanRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_SKELETON, MutantSkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_SNOW_GOLEM, MutantSnowGolemRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.MUTANT_ZOMBIE, MutantZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.SKULL_SPIRIT, manager -> new EntityRenderer<Entity>(manager){

            public ResourceLocation func_110775_a(Entity entity) {
                return null;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.SPIDER_PIG, SpiderPigRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MBEntityType.THROWABLE_BLOCK, ThrowableBlockRenderer::new);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(MutantBeasts.prefix("endersoul_hand_model"), "inventory"));
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map map = event.getModelRegistry();
        ModelResourceLocation endersoulHand = new ModelResourceLocation(MBItems.ENDERSOUL_HAND.getRegistryName(), "inventory");
        ModelResourceLocation endersoulHandModel = new ModelResourceLocation(MutantBeasts.prefix("endersoul_hand_model"), "inventory");
        final IBakedModel specialItemModel_default = (IBakedModel)map.get(endersoulHand);
        final IBakedModel specialItemModel_hand = (IBakedModel)map.get(endersoulHandModel);
        BakedModelWrapper<IBakedModel> specialItemModel_wrapper = new BakedModelWrapper<IBakedModel>(specialItemModel_default){

            public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack mat) {
                IBakedModel modelToUse = specialItemModel_default;
                switch (transformType) {
                    case FIRST_PERSON_LEFT_HAND: 
                    case FIRST_PERSON_RIGHT_HAND: 
                    case THIRD_PERSON_LEFT_HAND: 
                    case THIRD_PERSON_RIGHT_HAND: {
                        modelToUse = specialItemModel_hand;
                    }
                }
                return ForgeHooksClient.handlePerspective((IBakedModel)modelToUse, (ItemCameraTransforms.TransformType)transformType, (MatrixStack)mat);
            }
        };
        map.put(endersoulHand, specialItemModel_wrapper);
    }

    @SubscribeEvent
    public static void onParticleFactoryRegistry(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)MBParticleTypes.ENDERSOUL, EndersoulParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)MBParticleTypes.SKULL_SPIRIT, SkullSpiritParticle.Factory::new);
    }

    public void displayCreeperMinionTrackerGUI(CreeperMinionEntity creeperMinion) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CreeperMinionTrackerScreen(creeperMinion));
    }

    public BipedModel<?> getMutantSkeletonArmor() {
        if (this.mutantSkeletonArmor == null) {
            this.mutantSkeletonArmor = new BipedModel(1.0f);
            this.mutantSkeletonArmor.field_78116_c = new ModelRenderer(64, 32, 0, 0);
            this.mutantSkeletonArmor.field_78116_c.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.4f);
            ModelRenderer jaw = new ModelRenderer(64, 32, 32, 0);
            jaw.func_228301_a_(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, 0.7f);
            jaw.func_78793_a(0.0f, -0.2f, 3.5f);
            jaw.field_78795_f = 0.09817477f;
            this.mutantSkeletonArmor.field_78116_c.func_78792_a(jaw);
            this.mutantSkeletonArmor.field_178720_f = new ModelRenderer(this.mutantSkeletonArmor);
        }
        return this.mutantSkeletonArmor;
    }
}

