/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.animationapi;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.client.animationapi.Transform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class Animator {
    private int tempTick;
    private int prevTempTick;
    private boolean correctAnim;
    private IAnimatedEntity animEntity;
    private final Map<ModelRenderer, Transform> transformMap = new HashMap<ModelRenderer, Transform>();
    private final Map<ModelRenderer, Transform> prevTransformMap = new HashMap<ModelRenderer, Transform>();
    private float partialTick;

    public IAnimatedEntity getEntity() {
        return this.animEntity;
    }

    public void update(IAnimatedEntity entity, float partialTick) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.animEntity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
        this.partialTick = partialTick;
    }

    public boolean setAnimation(Animation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.animEntity.getAnimation() == animation;
        return this.correctAnim;
    }

    public void startKeyframe(int duration) {
        if (this.correctAnim) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void setStaticKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe(true);
    }

    public void resetKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe();
    }

    public void rotate(ModelRenderer box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).addRotation(x, y, z);
        }
    }

    public void move(ModelRenderer box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).addOffset(x, y, z);
        }
    }

    private Transform getTransform(ModelRenderer box) {
        return this.transformMap.computeIfAbsent(box, b -> new Transform());
    }

    public void endKeyframe() {
        this.endKeyframe(false);
    }

    private void endKeyframe(boolean stationary) {
        if (this.correctAnim) {
            int animTick = this.animEntity.getAnimationTick();
            if (animTick >= this.prevTempTick && animTick < this.tempTick) {
                if (stationary) {
                    for (ModelRenderer model : this.prevTransformMap.keySet()) {
                        Transform transform = this.prevTransformMap.get(model);
                        transform.addRotateAngle(model, 1.0f);
                        transform.addRotationPoint(model, 1.0f);
                    }
                } else {
                    Transform transform;
                    float tick = ((float)(animTick - this.prevTempTick) + this.partialTick) / (float)(this.tempTick - this.prevTempTick);
                    float inc = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    float dec = 1.0f - inc;
                    for (ModelRenderer model : this.prevTransformMap.keySet()) {
                        transform = this.prevTransformMap.get(model);
                        transform.addRotateAngle(model, dec);
                        transform.addRotationPoint(model, dec);
                    }
                    for (ModelRenderer model : this.transformMap.keySet()) {
                        transform = this.transformMap.get(model);
                        transform.addRotateAngle(model, inc);
                        transform.addRotationPoint(model, inc);
                    }
                }
            }
            if (!stationary) {
                this.prevTransformMap.clear();
                this.prevTransformMap.putAll(this.transformMap);
                this.transformMap.clear();
            }
        }
    }

    public static void addRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f += x;
        model.field_78796_g += y;
        model.field_78808_h += z;
    }

    public static void resetAngles(ModelRenderer ... boxes) {
        for (ModelRenderer box : boxes) {
            Animator.resetAngles(box);
        }
    }

    public static void resetAngles(ModelRenderer box) {
        box.field_78795_f = 0.0f;
        box.field_78796_g = 0.0f;
        box.field_78808_h = 0.0f;
    }
}

