/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.animationapi;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.packet.AnimationPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public interface IAnimatedEntity
extends IEntityAdditionalSpawnData {
    public Animation getAnimation();

    public void setAnimation(Animation var1);

    public Animation[] getAnimations();

    public int getAnimationTick();

    public void setAnimationTick(int var1);

    default public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeByte(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        buffer.func_150787_b(this.getAnimationTick());
    }

    default public void readSpawnData(PacketBuffer additionalData) {
        byte animation = additionalData.readByte();
        this.setAnimation(animation == -1 ? Animation.NONE : this.getAnimations()[additionalData.readByte()]);
        this.setAnimationTick(additionalData.func_150792_a());
    }

    public static <T extends Entity> void sendAnimationPacket(T entity, Animation animation) {
        if (!entity.field_70170_p.field_72995_K) {
            ((IAnimatedEntity)entity).setAnimation(animation);
            ((IAnimatedEntity)entity).setAnimationTick(0);
            MBPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new AnimationPacket(entity.func_145782_y(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation), 0));
        }
    }
}

