/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.gui.screen;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.packet.CreeperMinionTrackerPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class CreeperMinionTrackerScreen
extends Screen {
    private static final ResourceLocation TEXTURE = MutantBeasts.prefix("textures/gui/creeper_minion_tracker.png");
    private final int xSize = 176;
    private final int ySize = 166;
    private int guiX;
    private int guiY;
    private final CreeperMinionEntity creeperMinion;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;

    public CreeperMinionTrackerScreen(CreeperMinionEntity creeperMinion) {
        super(creeperMinion.func_145748_c_());
        this.creeperMinion = creeperMinion;
    }

    protected void init() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.func_174833_aM();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.guiX = (this.width - this.xSize) / 2;
        this.guiY = (this.height - this.ySize) / 2;
        int buttonWidth = this.xSize / 2 - 10;
        this.addButton((Widget)new Button(this.guiX + 8, this.guiY + this.ySize - 78, buttonWidth * 2 + 4, 20, this.canDestroyBlocks(), button -> {
            this.canDestroyBlocks = !this.canDestroyBlocks;
            MBPacketHandler.INSTANCE.sendToServer((Object)new CreeperMinionTrackerPacket(this.creeperMinion, 0, this.canDestroyBlocks));
            button.setMessage(this.canDestroyBlocks());
        }));
        this.addButton((Widget)new Button(this.guiX + 8, this.guiY + this.ySize - 54, buttonWidth * 2 + 4, 20, this.alwaysShowName(), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MBPacketHandler.INSTANCE.sendToServer((Object)new CreeperMinionTrackerPacket(this.creeperMinion, 1, this.alwaysShowName));
            button.setMessage(this.alwaysShowName());
        }));
        this.addButton((Widget)new Button(this.guiX + 8, this.guiY + this.ySize - 30, buttonWidth * 2 + 4, 20, this.canRideOnShoulder(), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MBPacketHandler.INSTANCE.sendToServer((Object)new CreeperMinionTrackerPacket(this.creeperMinion, 2, this.canRideOnShoulder));
            button.setMessage(this.canRideOnShoulder());
        }));
        if (!this.creeperMinion.func_152114_e((LivingEntity)this.minecraft.field_71439_g)) {
            for (Widget widget : this.buttons) {
                widget.active = false;
            }
        }
    }

    public void tick() {
        if (!this.creeperMinion.func_70089_S()) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    private String alwaysShowName() {
        return CreeperMinionTrackerScreen.format("show_name", new Object[0]) + ": " + I18n.func_135052_a((String)(this.alwaysShowName ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String canDestroyBlocks() {
        return CreeperMinionTrackerScreen.format("destroys_blocks", new Object[0]) + ": " + I18n.func_135052_a((String)(this.canDestroyBlocks ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String canRideOnShoulder() {
        return CreeperMinionTrackerScreen.format("ride_on_shoulder", new Object[0]) + ": " + I18n.func_135052_a((String)(this.canRideOnShoulder ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    public void render(int screenX, int screenY, float elapsedPartialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.field_71446_o.func_110577_a(TEXTURE);
        this.blit(this.guiX, this.guiY, 0, 0, this.xSize, this.ySize);
        int health = (int)(this.creeperMinion.func_110143_aJ() * 150.0f / this.creeperMinion.func_110138_aP());
        this.blit(this.guiX + 13, this.guiY + 16, 0, 166, health, 6);
        this.font.func_211126_b(this.title.func_150254_d(), (float)(this.guiX + 13), (float)(this.guiY + 5), 0x404040);
        this.font.func_211126_b(CreeperMinionTrackerScreen.format("health", new Object[0]), (float)(this.guiX + 13), (float)(this.guiY + 28), 0x404040);
        this.font.func_211126_b(CreeperMinionTrackerScreen.format("explosion", new Object[0]), (float)(this.guiX + 13), (float)(this.guiY + 48), 0x404040);
        this.font.func_211126_b(CreeperMinionTrackerScreen.format("blast_radius", new Object[0]), (float)(this.guiX + 13), (float)(this.guiY + 68), 0x404040);
        StringBuilder sb = new StringBuilder();
        sb.append(this.creeperMinion.func_110143_aJ() / 2.0f).append(" / ").append(this.creeperMinion.func_110138_aP() / 2.0f);
        this.drawCenteredString(this.font, sb.toString(), this.guiX + this.xSize / 2 + 38, this.guiY + 30, 0xFFFFFF);
        this.drawCenteredString(this.font, this.creeperMinion.canExplodeContinuously() ? CreeperMinionTrackerScreen.format("explosion.continuous", new Object[0]) : CreeperMinionTrackerScreen.format("explosion.one_time", new Object[0]), this.guiX + this.xSize / 2 + 38, this.guiY + 50, 0xFFFFFF);
        int temp = (int)(this.creeperMinion.getExplosionRadius() * 10.0f);
        sb = new StringBuilder().append((float)temp / 10.0f);
        this.drawCenteredString(this.font, sb.toString(), this.guiX + this.xSize / 2 + 38, this.guiY + 70, 0xFFFFFF);
        super.render(screenX, screenY, elapsedPartialTicks);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static String format(String key, Object ... parameters) {
        return I18n.func_135052_a((String)("gui.mutantbeasts.creeper_minion_tracker." + key), (Object[])parameters);
    }
}

