/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperChargeLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantCreeperModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class MutantCreeperRenderer
extends MobRenderer<MutantCreeperEntity, MutantCreeperModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_creeper");

    public MutantCreeperRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new MutantCreeperModel(), 1.5f);
        this.func_177094_a(new DeathLayer((IEntityRenderer<MutantCreeperEntity, MutantCreeperModel>)this));
        this.func_177094_a(new CreeperChargeLayer(this, new MutantCreeperModel(2.0f)));
    }

    protected void preRenderCallback(MutantCreeperEntity livingEntity, MatrixStack matrixStackIn, float partialTickTime) {
        float scale = 1.2f;
        if (livingEntity.field_70725_aQ > 0) {
            float f = (float)livingEntity.field_70725_aQ / 100.0f;
            scale -= f * 0.4f;
        }
        matrixStackIn.func_227862_a_(scale, scale, scale);
    }

    protected float getOverlayProgress(MutantCreeperEntity livingEntityIn, float partialTicks) {
        float overlay = livingEntityIn.getOverlayColor(partialTicks);
        return livingEntityIn.isJumpAttacking() && livingEntityIn.field_70725_aQ == 0 ? ((int)(overlay * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)overlay, (float)0.5f, (float)1.0f)) : overlay;
    }

    protected float getDeathMaxRotation(MutantCreeperEntity livingEntity) {
        return 0.0f;
    }

    protected RenderType func_230042_a_(MutantCreeperEntity p_230042_1_, boolean p_230042_2_, boolean p_230042_3_) {
        return p_230042_1_.field_70725_aQ > 0 ? null : super.func_230042_a_((LivingEntity)p_230042_1_, p_230042_2_, p_230042_3_);
    }

    public ResourceLocation getEntityTexture(MutantCreeperEntity entity) {
        return TEXTURE;
    }

    static class DeathLayer
    extends LayerRenderer<MutantCreeperEntity, MutantCreeperModel> {
        public DeathLayer(IEntityRenderer<MutantCreeperEntity, MutantCreeperModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantCreeperEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.field_70725_aQ > 0 && !livingEntity.func_82150_aj()) {
                IVertexBuilder vertexBuilder = bufferIn.getBuffer(((MutantCreeperModel)this.func_215332_c()).func_228282_a_(TEXTURE));
                ((MutantCreeperModel)this.func_215332_c()).func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.func_229200_a_((float)livingEntity.getOverlayColor(partialTicks), (livingEntity.field_70737_aN > 0 ? 1 : 0) != 0), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

