/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.model;

import chumbanotz.mutantbeasts.client.animationapi.Animator;
import chumbanotz.mutantbeasts.client.renderer.model.ScalableModelRenderer;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class MutantEndermanModel
extends EntityModel<MutantEndermanEntity> {
    private final ModelRenderer pelvis;
    private final ModelRenderer abdomen;
    private final ModelRenderer chest;
    private final ModelRenderer neck;
    private final ModelRenderer head;
    private final ModelRenderer mouth;
    private final Arm rightArm;
    private final Arm leftArm;
    private final Arm lowerRightArm;
    private final Arm lowerLeftArm;
    private final ModelRenderer legjoint1;
    private final ModelRenderer legjoint2;
    private final ModelRenderer leg1;
    private final ModelRenderer leg2;
    private final ModelRenderer foreleg1;
    private final ModelRenderer foreleg2;
    private float partialTick;

    public MutantEndermanModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.pelvis = new ModelRenderer((Model)this);
        this.pelvis.func_78793_a(0.0f, -15.5f, 8.0f);
        this.abdomen = new ModelRenderer((Model)this, 32, 0);
        this.abdomen.func_228300_a_(-4.0f, -10.0f, -2.0f, 8.0f, 10.0f, 4.0f);
        this.pelvis.func_78792_a(this.abdomen);
        this.chest = new ModelRenderer((Model)this, 50, 8);
        this.chest.func_228300_a_(-5.0f, -16.0f, -3.0f, 10.0f, 16.0f, 6.0f);
        this.chest.func_78793_a(0.0f, -8.0f, 0.0f);
        this.abdomen.func_78792_a(this.chest);
        this.neck = new ModelRenderer((Model)this, 32, 14);
        this.neck.func_228300_a_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f);
        this.neck.func_78793_a(0.0f, -15.0f, 0.0f);
        this.chest.func_78792_a(this.neck);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78784_a(0, 0).func_228301_a_(-4.0f, -4.0f, -8.0f, 8.0f, 6.0f, 8.0f, 0.5f);
        this.head.func_78784_a(0, 14).func_228301_a_(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f, 0.5f);
        this.head.func_78793_a(0.0f, -5.0f, 3.0f);
        this.neck.func_78792_a(this.head);
        this.mouth = new ModelRenderer((Model)this, 0, 24);
        this.mouth.func_228300_a_(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f);
        this.head.func_78792_a(this.mouth);
        this.rightArm = new Arm((Model)this, this.chest, true);
        this.leftArm = new Arm((Model)this, this.chest, false);
        this.lowerRightArm = new Arm((Model)this, this.chest, true);
        this.lowerRightArm.arm.field_78797_d += 6.0f;
        this.lowerLeftArm = new Arm((Model)this, this.chest, false);
        this.lowerLeftArm.arm.field_78797_d += 6.0f;
        this.legjoint1 = new ModelRenderer((Model)this);
        this.legjoint1.func_78793_a(-1.5f, 0.0f, 0.75f);
        this.abdomen.func_78792_a(this.legjoint1);
        this.legjoint2 = new ModelRenderer((Model)this);
        this.legjoint2.func_78793_a(1.5f, 0.0f, 0.75f);
        this.abdomen.func_78792_a(this.legjoint2);
        this.leg1 = new ModelRenderer((Model)this, 0, 34);
        this.leg1.func_228301_a_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, 0.5f);
        this.leg1.func_78793_a(0.0f, -2.0f, 0.0f);
        this.legjoint1.func_78792_a(this.leg1);
        this.leg2 = new ModelRenderer((Model)this, 0, 34);
        this.leg2.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, 0.5f, true);
        this.leg2.func_78793_a(0.0f, -2.0f, 0.0f);
        this.legjoint2.func_78792_a(this.leg2);
        this.foreleg1 = new ModelRenderer((Model)this, 12, 34);
        this.foreleg1.func_228301_a_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, 0.5f);
        this.foreleg1.func_78793_a(0.0f, 23.0f, 0.0f);
        this.leg1.func_78792_a(this.foreleg1);
        this.foreleg2 = new ModelRenderer((Model)this, 12, 34);
        this.foreleg2.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, 0.5f, true);
        this.foreleg2.func_78793_a(0.0f, 23.0f, 0.0f);
        this.leg2.func_78792_a(this.foreleg2);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.pelvis.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setRotationAngles(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.lowerRightArm.arm.setScale(entityIn.getArmScale(this.partialTick));
        this.lowerLeftArm.arm.setScale(entityIn.getArmScale(this.partialTick));
    }

    private void setAngles() {
        this.pelvis.field_78797_d = -15.5f;
        this.abdomen.field_78795_f = 0.31415927f;
        this.chest.field_78795_f = 0.3926991f;
        this.chest.field_78796_g = 0.0f;
        this.chest.field_78808_h = 0.0f;
        this.neck.field_78795_f = 0.19634955f;
        this.neck.field_78808_h = 0.0f;
        this.head.field_78795_f = -0.7853982f;
        this.head.field_78796_g = 0.0f;
        this.head.field_78808_h = 0.0f;
        this.mouth.field_78795_f = 0.0f;
        this.rightArm.setAngles();
        this.leftArm.setAngles();
        this.lowerRightArm.setAngles();
        this.lowerRightArm.arm.field_78795_f += 0.1f;
        this.lowerRightArm.arm.field_78808_h -= 0.2f;
        this.lowerLeftArm.setAngles();
        this.lowerLeftArm.arm.field_78795_f += 0.1f;
        this.lowerLeftArm.arm.field_78808_h += 0.2f;
        this.legjoint1.field_78795_f = 0.0f;
        this.legjoint2.field_78795_f = 0.0f;
        this.leg1.field_78795_f = -0.8975979f;
        this.leg1.field_78796_g = 0.0f;
        this.leg1.field_78808_h = 0.2617994f;
        this.leg2.field_78795_f = -0.8975979f;
        this.leg2.field_78796_g = 0.0f;
        this.leg2.field_78808_h = -0.2617994f;
        this.foreleg1.field_78795_f = 0.7853982f;
        this.foreleg1.field_78808_h = -0.1308997f;
        this.foreleg2.field_78795_f = 0.7853982f;
        this.foreleg2.field_78808_h = 0.1308997f;
    }

    private void animate(MutantEndermanEntity enderman, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float scale;
        int arm;
        float walkSpeed = 0.3f;
        float walkAnim1 = (MathHelper.func_76126_a((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float walkAnim2 = -(MathHelper.func_76126_a((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim3 = (MathHelper.func_76126_a((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim4 = -(MathHelper.func_76126_a((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float[] walkAnim = new float[5];
        Arrays.fill(walkAnim, MathHelper.func_76126_a((float)(limbSwing * walkSpeed)) * limbSwingAmount);
        float breatheAnim = MathHelper.func_76126_a((float)(ageInTicks * 0.15f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        for (arm = 1; arm < enderman.heldBlock.length; ++arm) {
            if (enderman.heldBlock[arm] == 0) continue;
            this.animateHoldBlock(enderman.heldBlockTick[arm], arm, enderman.hasTarget > 0);
            int n = arm;
            walkAnim[n] = walkAnim[n] * 0.4f;
        }
        if (enderman.getAnimation() == MutantEndermanEntity.MELEE_ANIMATION) {
            arm = enderman.getActiveArm();
            this.animateMelee(enderman.getAnimationTick(), arm);
            walkAnim[arm] = 0.0f;
        }
        if (enderman.getAnimation() == MutantEndermanEntity.THROW_ANIMATION) {
            arm = enderman.getActiveArm();
            this.animateThrowBlock(enderman.getAnimationTick(), arm);
        }
        if (enderman.getAnimation() == MutantEndermanEntity.SCREAM_ANIMATION) {
            this.animateScream(enderman.getAnimationTick());
            scale = 1.0f - MathHelper.func_76131_a((float)((float)enderman.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        if (enderman.getAnimation() == MutantEndermanEntity.TELESMASH_ANIMATION) {
            this.animateTeleSmash(enderman.getAnimationTick());
        }
        if (enderman.getAnimation() == MutantEndermanEntity.DEATH_ANIMATION) {
            this.animateDeath(enderman.field_70725_aQ);
            scale = 1.0f - MathHelper.func_76131_a((float)((float)enderman.field_70725_aQ / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        this.head.field_78795_f += facePitch * 0.5f;
        this.head.field_78796_g += faceYaw * 0.7f;
        this.head.field_78808_h -= faceYaw * 0.7f;
        this.neck.field_78795_f += facePitch * 0.3f;
        this.chest.field_78795_f += facePitch * 0.2f;
        this.mouth.field_78795_f += breatheAnim * 0.02f + 0.02f;
        this.neck.field_78795_f -= breatheAnim * 0.02f;
        this.rightArm.arm.field_78808_h += breatheAnim * 0.004f;
        this.leftArm.arm.field_78808_h -= breatheAnim * 0.004f;
        for (ModelRenderer finger : this.rightArm.finger) {
            finger.field_78808_h += breatheAnim * 0.05f;
        }
        this.rightArm.thumb.field_78808_h -= breatheAnim * 0.05f;
        for (ModelRenderer finger : this.leftArm.finger) {
            finger.field_78808_h -= breatheAnim * 0.05f;
        }
        this.leftArm.thumb.field_78808_h += breatheAnim * 0.05f;
        this.lowerRightArm.arm.field_78808_h += breatheAnim * 0.002f;
        this.lowerLeftArm.arm.field_78808_h -= breatheAnim * 0.002f;
        for (ModelRenderer finger : this.lowerRightArm.finger) {
            finger.field_78808_h += breatheAnim * 0.02f;
        }
        this.lowerRightArm.thumb.field_78808_h -= breatheAnim * 0.02f;
        for (ModelRenderer finger : this.lowerLeftArm.finger) {
            finger.field_78808_h -= breatheAnim * 0.02f;
        }
        this.lowerLeftArm.thumb.field_78808_h += breatheAnim * 0.02f;
        this.pelvis.field_78797_d -= Math.abs(walkAnim[0]);
        this.chest.field_78796_g -= walkAnim[0] * 0.06f;
        this.rightArm.arm.field_78795_f -= walkAnim[1] * 0.6f;
        this.leftArm.arm.field_78795_f += walkAnim[2] * 0.6f;
        this.rightArm.forearm.field_78795_f -= walkAnim[1] * 0.2f;
        this.leftArm.forearm.field_78795_f += walkAnim[2] * 0.2f;
        this.lowerRightArm.arm.field_78795_f -= walkAnim[3] * 0.3f;
        this.lowerLeftArm.arm.field_78795_f += walkAnim[4] * 0.3f;
        this.lowerRightArm.forearm.field_78795_f -= walkAnim[3] * 0.1f;
        this.lowerLeftArm.forearm.field_78795_f += walkAnim[4] * 0.1f;
        this.legjoint1.field_78795_f += walkAnim1 * 0.6f;
        this.legjoint2.field_78795_f += walkAnim2 * 0.6f;
        this.foreleg1.field_78795_f += walkAnim3 * 0.3f;
        this.foreleg2.field_78795_f += walkAnim4 * 0.3f;
    }

    private void animateHoldBlock(int fullTick, int armID, boolean hasTarget) {
        float tick = ((float)fullTick + this.partialTick) / 10.0f;
        if (!hasTarget) {
            tick = fullTick == 0 ? 0.0f : ((float)fullTick - this.partialTick) / 10.0f;
        }
        float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
        if (armID == 1) {
            this.rightArm.arm.field_78808_h += f * 0.8f;
            this.rightArm.forearm.field_78808_h += f * 0.6f;
            this.rightArm.hand.field_78796_g += f * 0.8f;
            this.rightArm.finger[0].field_78795_f += -f * 0.2f;
            this.rightArm.finger[2].field_78795_f += f * 0.2f;
            for (ModelRenderer finger : this.rightArm.finger) {
                finger.field_78808_h += f * 0.6f;
            }
            this.rightArm.thumb.field_78808_h += -f * 0.4f;
        } else if (armID == 2) {
            this.leftArm.arm.field_78808_h += -f * 0.8f;
            this.leftArm.forearm.field_78808_h += -f * 0.6f;
            this.leftArm.hand.field_78796_g += -f * 0.8f;
            this.leftArm.finger[0].field_78795_f += -f * 0.2f;
            this.leftArm.finger[2].field_78795_f += f * 0.2f;
            for (ModelRenderer finger : this.leftArm.finger) {
                finger.field_78808_h += -f * 0.6f;
            }
            this.leftArm.thumb.field_78808_h += f * 0.4f;
        } else if (armID == 3) {
            this.lowerRightArm.arm.field_78808_h += f * 0.5f;
            this.lowerRightArm.forearm.field_78808_h += f * 0.4f;
            this.lowerRightArm.hand.field_78796_g += f * 0.4f;
            this.lowerRightArm.finger[0].field_78795_f += -f * 0.2f;
            this.lowerRightArm.finger[2].field_78795_f += f * 0.2f;
            for (ModelRenderer finger : this.lowerRightArm.finger) {
                finger.field_78808_h += f * 0.6f;
            }
            this.lowerRightArm.thumb.field_78808_h += -f * 0.4f;
        } else if (armID == 4) {
            this.lowerLeftArm.arm.field_78808_h += -f * 0.5f;
            this.lowerLeftArm.forearm.field_78808_h += -f * 0.4f;
            this.lowerLeftArm.hand.field_78796_g += -f * 0.4f;
            this.lowerLeftArm.finger[0].field_78795_f += -f * 0.2f;
            this.lowerLeftArm.finger[2].field_78795_f += f * 0.2f;
            for (ModelRenderer finger : this.lowerLeftArm.finger) {
                finger.field_78808_h += -f * 0.6f;
            }
            this.lowerLeftArm.thumb.field_78808_h += f * 0.4f;
        }
    }

    private void animateMelee(int fullTick, int armID) {
        int right = (armID & 1) == 1 ? 1 : -1;
        Arm arm = this.getArmFromID(armID);
        if (fullTick < 2) {
            float tick = ((float)fullTick + this.partialTick) / 2.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            arm.arm.field_78795_f += f * 0.2f;
            arm.finger[0].field_78808_h += f * 0.3f * (float)right;
            arm.finger[1].field_78808_h += f * 0.3f * (float)right;
            arm.finger[2].field_78808_h += f * 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -f * 0.5f * (float)right;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 2) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78796_g += -f1 * 0.1f * (float)right;
            arm.arm.field_78795_f += f * 1.1f - 1.1f;
            arm.forearm.field_78795_f += -f * 0.4f;
            arm.finger[0].field_78808_h += 0.3f * (float)right;
            arm.finger[1].field_78808_h += 0.3f * (float)right;
            arm.finger[2].field_78808_h += 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -0.5f * (float)right;
        } else if (fullTick < 6) {
            this.chest.field_78796_g += -0.1f * (float)right;
            arm.arm.field_78795_f += -1.1f;
            arm.forearm.field_78795_f += -0.4f;
            arm.finger[0].field_78808_h += 0.3f * (float)right;
            arm.finger[1].field_78808_h += 0.3f * (float)right;
            arm.finger[2].field_78808_h += 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -0.5f * (float)right;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 6) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78796_g += -f * 0.1f * (float)right;
            arm.arm.field_78795_f += -f * 1.1f;
            arm.forearm.field_78795_f += -f * 0.4f;
            arm.finger[0].field_78808_h += f * 0.3f * (float)right;
            arm.finger[1].field_78808_h += f * 0.3f * (float)right;
            arm.finger[2].field_78808_h += f * 0.3f * (float)right;
            arm.foreFinger[0].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[1].field_78808_h += -f * 0.5f * (float)right;
            arm.foreFinger[2].field_78808_h += -f * 0.5f * (float)right;
        }
    }

    private void animateThrowBlock(int fullTick, int armID) {
        if (armID == 1) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.field_78795_f += -f1 * 1.5f;
                this.rightArm.arm.field_78808_h += f * 0.8f;
                this.rightArm.forearm.field_78808_h += f * 0.6f;
                this.rightArm.hand.field_78796_g += f * 0.8f;
                this.rightArm.finger[0].field_78795_f += -f * 0.2f;
                this.rightArm.finger[2].field_78795_f += f * 0.2f;
                for (ModelRenderer finger : this.rightArm.finger) {
                    finger.field_78808_h += f * 0.6f;
                }
                this.rightArm.thumb.field_78808_h += -f * 0.4f;
            } else if (fullTick < 7) {
                this.rightArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.field_78795_f += -f * 1.5f;
            }
        } else if (armID == 2) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.field_78795_f += -f1 * 1.5f;
                this.leftArm.arm.field_78808_h += -f * 0.8f;
                this.leftArm.forearm.field_78808_h += -f * 0.6f;
                this.leftArm.hand.field_78796_g += -f * 0.8f;
                this.leftArm.finger[0].field_78795_f += -f * 0.2f;
                this.leftArm.finger[2].field_78795_f += f * 0.2f;
                for (ModelRenderer finger : this.leftArm.finger) {
                    finger.field_78808_h += -f * 0.6f;
                }
                this.leftArm.thumb.field_78808_h += f * 0.4f;
            } else if (fullTick < 7) {
                this.leftArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.field_78795_f += -f * 1.5f;
            }
        } else if (armID == 3) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.field_78795_f += -f1 * 1.5f;
                this.lowerRightArm.arm.field_78808_h += f * 0.5f;
                this.lowerRightArm.forearm.field_78808_h += f * 0.4f;
                this.lowerRightArm.hand.field_78796_g += f * 0.4f;
                this.lowerRightArm.finger[0].field_78795_f += -f * 0.2f;
                this.lowerRightArm.finger[2].field_78795_f += f * 0.2f;
                for (ModelRenderer finger : this.lowerRightArm.finger) {
                    finger.field_78808_h += f * 0.6f;
                }
                this.lowerRightArm.thumb.field_78808_h += -f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerRightArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.field_78795_f += -f * 1.5f;
            }
        } else if (armID == 4) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.field_78795_f += -f1 * 1.5f;
                this.lowerLeftArm.arm.field_78808_h += -f * 0.5f;
                this.lowerLeftArm.forearm.field_78808_h += -f * 0.4f;
                this.lowerLeftArm.hand.field_78796_g += -f * 0.4f;
                this.lowerLeftArm.finger[0].field_78795_f += -f * 0.2f;
                this.lowerLeftArm.finger[2].field_78795_f += f * 0.2f;
                for (ModelRenderer finger : this.lowerLeftArm.finger) {
                    finger.field_78808_h += -f * 0.6f;
                }
                this.lowerLeftArm.thumb.field_78808_h += f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerLeftArm.arm.field_78795_f += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.field_78795_f += -f * 1.5f;
            }
        }
    }

    private void animateScream(int fullTick) {
        if (fullTick < 35) {
            int i;
            float tick = ((float)fullTick + this.partialTick) / 35.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += f * 0.3f;
            this.chest.field_78795_f += f * 0.4f;
            this.neck.field_78795_f += f * 0.2f;
            this.head.field_78795_f += f * 0.3f;
            this.rightArm.arm.field_78795_f += -f * 0.6f;
            this.rightArm.arm.field_78796_g += f * 0.4f;
            this.rightArm.forearm.field_78795_f += -f * 0.8f;
            this.rightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_78808_h += f * 0.3f;
                this.rightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.leftArm.arm.field_78795_f += -f * 0.6f;
            this.leftArm.arm.field_78796_g += -f * 0.4f;
            this.leftArm.forearm.field_78795_f += -f * 0.8f;
            this.leftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_78808_h += -f * 0.3f;
                this.leftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
            this.lowerRightArm.arm.field_78795_f += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += f * 0.2f;
            this.lowerRightArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerRightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += f * 0.3f;
                this.lowerRightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.lowerLeftArm.arm.field_78795_f += -f * 0.4f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerLeftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
        } else if (fullTick < 40) {
            int i;
            this.abdomen.field_78795_f += 0.3f;
            this.chest.field_78795_f += 0.4f;
            this.neck.field_78795_f += 0.2f;
            this.head.field_78795_f += 0.3f;
            this.rightArm.arm.field_78795_f += -0.6f;
            this.rightArm.arm.field_78796_g += 0.4f;
            this.rightArm.forearm.field_78795_f += -0.8f;
            this.rightArm.hand.field_78808_h += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_78808_h += 0.3f;
                this.rightArm.foreFinger[i].field_78808_h += -0.5f;
            }
            this.leftArm.arm.field_78795_f += -0.6f;
            this.leftArm.arm.field_78796_g += -0.4f;
            this.leftArm.forearm.field_78795_f += -0.8f;
            this.leftArm.hand.field_78808_h += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_78808_h += -0.3f;
                this.leftArm.foreFinger[i].field_78808_h += 0.5f;
            }
            this.lowerRightArm.arm.field_78795_f += -0.4f;
            this.lowerRightArm.arm.field_78796_g += 0.2f;
            this.lowerRightArm.forearm.field_78795_f += -0.8f;
            this.lowerRightArm.hand.field_78808_h += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += 0.3f;
                this.lowerRightArm.foreFinger[i].field_78808_h += -0.5f;
            }
            this.lowerLeftArm.arm.field_78795_f += -0.4f;
            this.lowerLeftArm.arm.field_78796_g += -0.2f;
            this.lowerLeftArm.forearm.field_78795_f += -0.8f;
            this.lowerLeftArm.hand.field_78808_h += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -0.3f;
                this.lowerLeftArm.foreFinger[i].field_78808_h += 0.5f;
            }
        } else if (fullTick < 44) {
            int i;
            float tick = ((float)(fullTick - 40) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += -f * 0.1f + 0.4f;
            this.chest.field_78795_f += f * 0.1f + 0.3f;
            this.chest.field_78808_h += f1 * 0.5f;
            this.neck.field_78795_f += f * 0.2f;
            this.neck.field_78808_h += f1 * 0.2f;
            this.head.field_78795_f += f * 1.2f - 0.8f;
            this.head.field_78808_h += f1 * 0.4f;
            this.mouth.field_78795_f += f1 * 0.6f;
            this.rightArm.arm.field_78795_f += -f * 0.6f;
            this.rightArm.arm.field_78796_g += 0.4f;
            this.rightArm.forearm.field_78795_f += -f * 0.8f;
            this.rightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].field_78808_h += f * 0.3f;
                this.rightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.leftArm.arm.field_78795_f += -f * 0.6f;
            this.leftArm.arm.field_78796_g += -0.4f;
            this.leftArm.forearm.field_78795_f += -f * 0.8f;
            this.leftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].field_78808_h += -f * 0.3f;
                this.leftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
            this.lowerRightArm.arm.field_78795_f += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += -f * 0.1f + 0.3f;
            this.lowerRightArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerRightArm.hand.field_78808_h += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].field_78808_h += f * 0.3f;
                this.lowerRightArm.foreFinger[i].field_78808_h += -f * 0.5f;
            }
            this.lowerLeftArm.arm.field_78795_f += -f * 0.4f;
            this.lowerLeftArm.arm.field_78796_g += f * 0.1f - 0.3f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 0.8f;
            this.lowerLeftArm.hand.field_78808_h += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].field_78808_h += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].field_78808_h += f * 0.5f;
            }
            this.leg1.field_78808_h += f1 * 0.1f;
            this.leg2.field_78808_h += -f1 * 0.1f;
        } else if (fullTick < 155) {
            float tick = ((float)(fullTick - 44) + this.partialTick) / 111.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += 0.4f;
            this.chest.field_78795_f += 0.3f;
            this.chest.field_78808_h += f * 1.0f - 0.5f;
            this.neck.field_78808_h += f * 0.4f - 0.2f;
            this.head.field_78795_f += -0.8f;
            this.head.field_78808_h += f * 0.8f - 0.4f;
            this.mouth.field_78795_f += 0.6f;
            this.rightArm.arm.field_78796_g += 0.4f;
            this.leftArm.arm.field_78796_g += -0.4f;
            this.lowerRightArm.arm.field_78796_g += 0.3f;
            this.lowerLeftArm.arm.field_78796_g += -0.3f;
            this.leg1.field_78808_h += 0.1f;
            this.leg2.field_78808_h += -0.1f;
        } else if (fullTick < 160) {
            float tick = ((float)(fullTick - 155) + this.partialTick) / 5.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += f * 0.4f;
            this.chest.field_78795_f += f * 0.3f;
            this.chest.field_78808_h += -f * 0.5f;
            this.neck.field_78808_h += -f * 0.2f;
            this.head.field_78795_f += -f * 0.8f;
            this.head.field_78808_h += -f * 0.4f;
            this.mouth.field_78795_f += f * 0.6f;
            this.rightArm.arm.field_78796_g += f * 0.4f;
            this.leftArm.arm.field_78796_g += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += f * 0.3f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.3f;
            this.leg1.field_78808_h += f * 0.1f;
            this.leg2.field_78808_h += -f * 0.1f;
        }
    }

    private void animateTeleSmash(int fullTick) {
        if (fullTick < 18) {
            float tick = ((float)fullTick + this.partialTick) / 18.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78795_f += -f * 0.3f;
            this.rightArm.arm.field_78796_g += f * 0.2f;
            this.rightArm.arm.field_78808_h += f * 0.8f;
            this.rightArm.hand.field_78796_g += f * 1.7f;
            this.leftArm.arm.field_78796_g += -f * 0.2f;
            this.leftArm.arm.field_78808_h += -f * 0.8f;
            this.leftArm.hand.field_78796_g += -f * 1.7f;
            this.lowerRightArm.arm.field_78796_g += f * 0.2f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.hand.field_78796_g += f * 1.7f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.hand.field_78796_g += -f * 1.7f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 18) + this.partialTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.chest.field_78795_f += -f * 0.3f;
            this.rightArm.arm.field_78795_f += -f1 * 0.8f;
            this.rightArm.arm.field_78796_g += 0.2f;
            this.rightArm.arm.field_78808_h += 0.8f;
            this.rightArm.hand.field_78796_g += 1.0f;
            this.leftArm.arm.field_78795_f += -f1 * 0.8f;
            this.leftArm.arm.field_78796_g += -0.2f;
            this.leftArm.arm.field_78808_h += -0.8f;
            this.leftArm.hand.field_78796_g += -1.7f;
            this.lowerRightArm.arm.field_78795_f += -f1 * 0.9f;
            this.lowerRightArm.arm.field_78796_g += 0.2f;
            this.lowerRightArm.arm.field_78808_h += 0.6f;
            this.lowerRightArm.hand.field_78796_g += 1.0f;
            this.lowerLeftArm.arm.field_78795_f += -f1 * 0.9f;
            this.lowerLeftArm.arm.field_78796_g += -0.2f;
            this.lowerLeftArm.arm.field_78808_h += -0.6f;
            this.lowerLeftArm.hand.field_78796_g += -1.7f;
        } else if (fullTick < 24) {
            this.rightArm.arm.field_78795_f += -0.8f;
            this.rightArm.arm.field_78796_g += 0.2f;
            this.rightArm.arm.field_78808_h += 0.8f;
            this.rightArm.hand.field_78796_g += 1.0f;
            this.leftArm.arm.field_78795_f += -0.8f;
            this.leftArm.arm.field_78796_g += -0.2f;
            this.leftArm.arm.field_78808_h += -0.8f;
            this.leftArm.hand.field_78796_g += -1.7f;
            this.lowerRightArm.arm.field_78795_f += -0.9f;
            this.lowerRightArm.arm.field_78796_g += 0.2f;
            this.lowerRightArm.arm.field_78808_h += 0.6f;
            this.lowerRightArm.hand.field_78796_g += 1.0f;
            this.lowerLeftArm.arm.field_78795_f += -0.9f;
            this.lowerLeftArm.arm.field_78796_g += -0.2f;
            this.lowerLeftArm.arm.field_78808_h += -0.6f;
            this.lowerLeftArm.hand.field_78796_g += -1.7f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 24) + this.partialTick) / 6.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.rightArm.arm.field_78795_f += -f * 0.8f;
            this.rightArm.arm.field_78796_g += f * 0.2f;
            this.rightArm.arm.field_78808_h += f * 0.8f;
            this.rightArm.hand.field_78796_g += f * 1.7f;
            this.leftArm.arm.field_78795_f += -f * 0.8f;
            this.leftArm.arm.field_78796_g += -f * 0.2f;
            this.leftArm.arm.field_78808_h += -f * 0.8f;
            this.leftArm.hand.field_78796_g += -f * 1.7f;
            this.lowerRightArm.arm.field_78795_f += -f * 0.9f;
            this.lowerRightArm.arm.field_78796_g += f * 0.2f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.hand.field_78796_g += f * 1.7f;
            this.lowerLeftArm.arm.field_78795_f += -f * 0.9f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.hand.field_78796_g += -f * 1.7f;
        }
    }

    private void animateDeath(int deathTick) {
        if (deathTick < 80) {
            float tick = ((float)deathTick + this.partialTick) / 80.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.head.field_78795_f += f * 0.4f;
            this.neck.field_78795_f += f * 0.3f;
            this.pelvis.field_78797_d += -f * 12.0f;
            this.rightArm.arm.field_78795_f += -f * 0.4f;
            this.rightArm.arm.field_78796_g += f * 0.4f;
            this.rightArm.arm.field_78808_h += f * 0.6f;
            this.rightArm.forearm.field_78795_f += -f * 1.2f;
            this.leftArm.arm.field_78795_f += -f * 0.4f;
            this.leftArm.arm.field_78796_g += -f * 0.2f;
            this.leftArm.arm.field_78808_h += -f * 0.6f;
            this.leftArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerRightArm.arm.field_78795_f += -f * 0.4f;
            this.lowerRightArm.arm.field_78796_g += f * 0.4f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerLeftArm.arm.field_78795_f += -f * 0.4f;
            this.lowerLeftArm.arm.field_78796_g += -f * 0.2f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 1.2f;
            this.leg1.field_78795_f += -f * 0.9f;
            this.leg1.field_78796_g += f * 0.3f;
            this.leg2.field_78795_f += -f * 0.9f;
            this.leg2.field_78796_g += -f * 0.3f;
            this.foreleg1.field_78795_f += f * 1.6f;
            this.foreleg2.field_78795_f += f * 1.6f;
        } else if (deathTick < 84) {
            float tick = ((float)(deathTick - 80) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.head.field_78795_f += f * 0.4f;
            this.mouth.field_78795_f += f1 * 0.6f;
            this.neck.field_78795_f += f * 0.4f - 0.1f;
            this.chest.field_78795_f += -f1 * 0.8f;
            this.abdomen.field_78795_f += -f1 * 0.2f;
            this.pelvis.field_78797_d += -12.0f;
            this.rightArm.arm.field_78795_f += -f * 0.4f;
            this.rightArm.arm.field_78796_g += -f * 1.4f + 1.8f;
            this.rightArm.arm.field_78808_h += f * 0.6f;
            this.rightArm.forearm.field_78795_f += -f * 1.2f;
            this.leftArm.arm.field_78795_f += -f * 0.4f;
            this.leftArm.arm.field_78796_g += f * 1.6f - 1.8f;
            this.leftArm.arm.field_78808_h += -f * 0.6f;
            this.leftArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerRightArm.arm.field_78795_f += -f * 0.5f + 0.1f;
            this.lowerRightArm.arm.field_78796_g += -f * 1.1f + 1.5f;
            this.lowerRightArm.arm.field_78808_h += f * 0.6f;
            this.lowerRightArm.forearm.field_78795_f += -f * 1.2f;
            this.lowerLeftArm.arm.field_78795_f += -f * 0.5f + 0.1f;
            this.lowerLeftArm.arm.field_78796_g += f * 1.1f - 1.5f;
            this.lowerLeftArm.arm.field_78808_h += -f * 0.6f;
            this.lowerLeftArm.forearm.field_78795_f += -f * 1.2f;
            this.leg1.field_78795_f += -f * 1.7f + 0.8f;
            this.leg1.field_78796_g += f * 0.3f;
            this.leg1.field_78808_h += f1 * 0.2f;
            this.leg2.field_78795_f += -f * 1.7f + 0.8f;
            this.leg2.field_78796_g += -f * 0.3f;
            this.leg2.field_78808_h += -f1 * 0.2f;
            this.foreleg1.field_78795_f += f * 1.6f;
            this.foreleg2.field_78795_f += f * 1.6f;
        } else {
            this.mouth.field_78795_f += 0.6f;
            this.neck.field_78795_f += -0.1f;
            this.chest.field_78795_f += -0.8f;
            this.abdomen.field_78795_f += -0.2f;
            this.pelvis.field_78797_d += -12.0f;
            this.rightArm.arm.field_78796_g += 1.0f;
            this.leftArm.arm.field_78796_g += -1.8f;
            this.lowerRightArm.arm.field_78795_f += 0.1f;
            this.lowerRightArm.arm.field_78796_g += 1.0f;
            this.lowerLeftArm.arm.field_78795_f += 0.1f;
            this.lowerLeftArm.arm.field_78796_g += -1.5f;
            this.leg1.field_78795_f += 0.8f;
            this.leg1.field_78808_h += 0.2f;
            this.leg2.field_78795_f += 0.8f;
            this.leg2.field_78808_h += -0.2f;
        }
    }

    private Arm getArmFromID(int armID) {
        return armID == 1 ? this.rightArm : (armID == 2 ? this.leftArm : (armID == 3 ? this.lowerRightArm : this.lowerLeftArm));
    }

    public void translateRotateArm(MatrixStack matrixStackIn, int armID) {
        this.pelvis.func_228307_a_(matrixStackIn);
        this.abdomen.func_228307_a_(matrixStackIn);
        this.chest.func_228307_a_(matrixStackIn);
        this.getArmFromID(armID).translateRotate(matrixStackIn);
    }

    public void setLivingAnimations(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    static class Arm {
        final ScalableModelRenderer arm;
        final ModelRenderer forearm;
        final ModelRenderer hand;
        final ModelRenderer[] finger;
        final ModelRenderer[] foreFinger;
        final ModelRenderer thumb;
        final boolean right;

        private Arm(Model model, ModelRenderer connect, boolean right) {
            int i;
            this.right = right;
            this.finger = new ModelRenderer[3];
            this.foreFinger = new ModelRenderer[3];
            this.arm = new ScalableModelRenderer(model, 92, 0);
            this.arm.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 22.0f, 3.0f, 0.1f, !this.right);
            this.arm.func_78793_a(this.right ? -4.0f : 4.0f, -14.0f, 0.0f);
            connect.func_78792_a((ModelRenderer)this.arm);
            this.forearm = new ModelRenderer(model, 104, 0);
            this.forearm.func_228304_a_(-1.5f, 0.0f, -1.5f, 3.0f, 18.0f, 3.0f, !this.right);
            this.forearm.func_78793_a(0.0f, 21.0f, 1.0f);
            this.arm.func_78792_a(this.forearm);
            this.hand = new ModelRenderer(model);
            this.hand.func_78793_a(0.0f, 17.5f, 0.0f);
            this.forearm.func_78792_a(this.hand);
            float fingerScale = 0.6f;
            for (i = 0; i < this.finger.length; ++i) {
                this.finger[i] = new ModelRenderer(model, 76, 0);
                this.finger[i].func_228303_a_(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, fingerScale, !this.right);
            }
            this.finger[0].func_78793_a(this.right ? -0.5f : 0.5f, 0.0f, -1.0f);
            this.finger[1].func_78793_a(this.right ? -0.5f : 0.5f, 0.0f, 0.0f);
            this.finger[2].func_78793_a(this.right ? -0.5f : 0.5f, 0.0f, 1.0f);
            for (i = 0; i < this.foreFinger.length; ++i) {
                this.foreFinger[i] = new ModelRenderer(model, 76, 0);
                this.foreFinger[i].func_228303_a_(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, fingerScale - 0.01f, !this.right);
                this.foreFinger[i].func_78793_a(0.0f, 0.5f + (float)(i == 1 ? 6 : 5), 0.0f);
            }
            for (i = 0; i < this.finger.length; ++i) {
                this.hand.func_78792_a(this.finger[i]);
                this.finger[i].func_78792_a(this.foreFinger[i]);
            }
            this.thumb = new ModelRenderer(model, 76, 0);
            this.thumb.func_228303_a_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, fingerScale, this.right);
            this.thumb.func_78793_a(this.right ? 0.5f : -0.5f, 0.0f, -0.5f);
            this.hand.func_78792_a(this.thumb);
        }

        private void setAngles() {
            Animator.resetAngles((ModelRenderer)this.arm);
            Animator.resetAngles(this.forearm);
            Animator.resetAngles(this.hand);
            for (int i = 0; i < this.finger.length; ++i) {
                Animator.resetAngles(this.finger[i]);
                Animator.resetAngles(this.foreFinger[i]);
            }
            Animator.resetAngles(this.thumb);
            if (this.right) {
                this.arm.field_78795_f = -0.5235988f;
                this.arm.field_78808_h = 0.5235988f;
                this.forearm.field_78795_f = -0.62831855f;
                this.hand.field_78796_g = -0.3926991f;
                this.finger[0].field_78795_f = -0.2617994f;
                this.finger[1].field_78808_h = 0.17453294f;
                this.finger[2].field_78795_f = 0.2617994f;
                this.foreFinger[0].field_78808_h = -0.2617994f;
                this.foreFinger[1].field_78808_h = -0.3926991f;
                this.foreFinger[2].field_78808_h = -0.2617994f;
                this.thumb.field_78795_f = -0.62831855f;
                this.thumb.field_78808_h = -0.3926991f;
            } else {
                this.arm.field_78795_f = -0.5235988f;
                this.arm.field_78808_h = -0.5235988f;
                this.forearm.field_78795_f = -0.62831855f;
                this.hand.field_78796_g = 0.3926991f;
                this.finger[0].field_78795_f = -0.2617994f;
                this.finger[1].field_78808_h = -0.17453294f;
                this.finger[2].field_78795_f = 0.2617994f;
                this.foreFinger[0].field_78808_h = 0.2617994f;
                this.foreFinger[1].field_78808_h = 0.3926991f;
                this.foreFinger[2].field_78808_h = 0.2617994f;
                this.thumb.field_78795_f = -0.62831855f;
                this.thumb.field_78808_h = 0.3926991f;
            }
        }

        private void translateRotate(MatrixStack matrixStackIn) {
            this.arm.func_228307_a_(matrixStackIn);
            this.forearm.func_228307_a_(matrixStackIn);
            this.hand.func_228307_a_(matrixStackIn);
        }
    }
}

