/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.BodyPartEntity;
import chumbanotz.mutantbeasts.entity.ai.controller.FixedBodyController;
import chumbanotz.mutantbeasts.entity.ai.goal.AnimationGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.HurtByNearestTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MutantSkeletonEntity
extends MonsterEntity
implements IAnimatedEntity {
    public static final Animation MELEE_ANIMATION = new Animation(14);
    public static final Animation CONSTRICT_RIBS_ANIMATION = new Animation(20);
    public static final Animation SHOOT_ANIMATION = new Animation(32);
    public static final Animation MULTI_SHOT_ANIMATION = new Animation(30);
    private static final Animation[] ANIMATIONS = new Animation[]{MELEE_ANIMATION, CONSTRICT_RIBS_ANIMATION, SHOOT_ANIMATION, MULTI_SHOT_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;

    public MutantSkeletonEntity(EntityType<? extends MutantSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new ShootGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MultiShotGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new ConstrictRibsGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.1).setMaxAttackTick(10));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByNearestTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WolfEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(5.0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.25f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    protected BodyController func_184650_s() {
        return new FixedBodyController((MobEntity)this);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_213623_ec() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.animation != Animation.NONE) {
            ++this.animationTick;
        }
        if (this.field_70170_p.func_226690_K_() && this.field_70173_aa % 100 == 0 && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.animation == Animation.NONE) {
            this.animation = this.field_70146_Z.nextInt(4) != 0 ? MELEE_ANIMATION : CONSTRICT_RIBS_ANIMATION;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !(source.func_76346_g() instanceof MutantSkeletonEntity) && super.func_70097_a(source, amount);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && entityIn instanceof LivingEntity;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.field_70133_I = true;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (LivingEntity livingEntity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0))) {
                livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 7.0f);
            }
            for (int i = 0; i < 18; ++i) {
                int j = i;
                if (i >= 3) {
                    j = i + 1;
                }
                if (j >= 4) {
                    ++j;
                }
                if (j >= 5) {
                    ++j;
                }
                if (j >= 6) {
                    ++j;
                }
                if (j >= 9) {
                    ++j;
                }
                if (j >= 10) {
                    ++j;
                }
                if (j >= 11) {
                    ++j;
                }
                if (j >= 12) {
                    ++j;
                }
                if (j >= 15) {
                    ++j;
                }
                if (j >= 16) {
                    ++j;
                }
                if (j >= 17) {
                    ++j;
                }
                if (j >= 18) {
                    ++j;
                }
                if (j >= 20) {
                    ++j;
                }
                BodyPartEntity part = new BodyPartEntity(this.field_70170_p, (MobEntity)this, j);
                part.func_213317_d(part.func_213322_ci().func_72441_c((double)(this.field_70146_Z.nextFloat() * 0.8f * 2.0f - 0.8f), (double)(this.field_70146_Z.nextFloat() * 0.25f + 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.8f * 2.0f - 0.8f)));
                this.field_70170_p.func_217376_c((Entity)part);
            }
        }
        this.field_70725_aQ = 19;
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_SKELETON_STEP, 0.15f, 1.0f);
    }

    static class MultiShotGoal
    extends AnimationGoal<MutantSkeletonEntity> {
        private final List<MutantArrowEntity> shots = new ArrayList<MutantArrowEntity>();
        private LivingEntity attackTarget;

        public MultiShotGoal(MutantSkeletonEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public Animation getAnimation() {
            return MULTI_SHOT_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantSkeletonEntity)this.mob).func_70638_az();
            return this.attackTarget != null && ((MutantSkeletonEntity)this.mob).animation == Animation.NONE && ((((MutantSkeletonEntity)this.mob).field_70122_E || ((MutantSkeletonEntity)this.mob).func_184218_aH() || ((MutantSkeletonEntity)this.mob).func_180799_ab()) && ((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(26) == 0 && ((MutantSkeletonEntity)this.mob).func_70635_at().func_75522_a((Entity)this.attackTarget) || this.attackTarget == ((MutantSkeletonEntity)this.mob).func_184187_bx());
        }

        public void func_75246_d() {
            ((MutantSkeletonEntity)this.mob).func_70661_as().func_75499_g();
            ((MutantSkeletonEntity)this.mob).func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (((MutantSkeletonEntity)this.mob).animationTick == 10) {
                ((MutantSkeletonEntity)this.mob).func_184210_p();
                double x = this.attackTarget.func_226277_ct_() - ((MutantSkeletonEntity)this.mob).func_226277_ct_();
                double z = this.attackTarget.func_226281_cx_() - ((MutantSkeletonEntity)this.mob).func_226281_cx_();
                float scale = 0.06f + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.03f;
                if (((MutantSkeletonEntity)this.mob).func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_()) < 16.0) {
                    x *= -1.0;
                    z *= -1.0;
                    scale = (float)((double)scale * 5.0);
                }
                ((MutantSkeletonEntity)this.mob).field_213328_B = Vec3d.field_186680_a;
                ((MutantSkeletonEntity)this.mob).func_213293_j(x * (double)scale, 1.1f, z * (double)scale);
            }
            if (((MutantSkeletonEntity)this.mob).animationTick == 15) {
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_219615_bG, 1.0f, 1.0f);
            }
            if (((MutantSkeletonEntity)this.mob).animationTick == 20) {
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_219610_bB, 1.0f, 1.0f / (((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
            if (((MutantSkeletonEntity)this.mob).animationTick >= 24 && ((MutantSkeletonEntity)this.mob).animationTick < 28) {
                if (!this.shots.isEmpty()) {
                    Iterator<MutantArrowEntity> iterator = this.shots.iterator();
                    while (iterator.hasNext()) {
                        MutantArrowEntity arrowEntity;
                        MutantArrowEntity shot = arrowEntity = iterator.next();
                        ((MutantSkeletonEntity)this.mob).field_70170_p.func_217376_c((Entity)arrowEntity);
                    }
                    this.shots.clear();
                }
                for (int i = 0; i < 6; ++i) {
                    MutantArrowEntity shot = new MutantArrowEntity(((MutantSkeletonEntity)this.mob).field_70170_p, (LivingEntity)this.mob, this.attackTarget);
                    shot.setSpeed(1.2f - ((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.1f);
                    shot.setClones(2);
                    shot.randomize(3.0f);
                    shot.setDamage(5 + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(5));
                    this.shots.add(shot);
                }
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.25f);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.shots.clear();
            this.attackTarget = null;
        }
    }

    static class ShootGoal
    extends AnimationGoal<MutantSkeletonEntity> {
        private LivingEntity attackTarget;

        public ShootGoal(MutantSkeletonEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public Animation getAnimation() {
            return SHOOT_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantSkeletonEntity)this.mob).func_70638_az();
            return this.attackTarget != null && ((MutantSkeletonEntity)this.mob).animation == Animation.NONE && ((MutantSkeletonEntity)this.mob).func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_()) > 4.0 && ((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(12) == 0 && ((MutantSkeletonEntity)this.mob).func_70635_at().func_75522_a((Entity)this.attackTarget);
        }

        public void func_75246_d() {
            ((MutantSkeletonEntity)this.mob).func_70661_as().func_75499_g();
            ((MutantSkeletonEntity)this.mob).func_70625_a((Entity)this.attackTarget, 30.0f, 30.0f);
            ((MutantSkeletonEntity)this.mob).func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (((MutantSkeletonEntity)this.mob).animationTick == 5) {
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_219614_bF, 1.0f, 1.0f);
            }
            if (((MutantSkeletonEntity)this.mob).animationTick == 20) {
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_219610_bB, 1.0f, 1.0f / (((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
            if (((MutantSkeletonEntity)this.mob).animationTick == 26 && this.attackTarget.func_70089_S()) {
                MutantArrowEntity arrowEntity = new MutantArrowEntity(((MutantSkeletonEntity)this.mob).field_70170_p, (LivingEntity)this.mob, this.attackTarget);
                if (((MutantSkeletonEntity)this.mob).field_70737_aN > 0 && ((MutantSkeletonEntity)this.mob).field_110153_bc > 0.0f) {
                    arrowEntity.randomize((float)((MutantSkeletonEntity)this.mob).field_70737_aN / 2.0f);
                }
                if (((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new EffectInstance(Effects.field_76436_u, 80 + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(60), 0));
                }
                if (((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new EffectInstance(Effects.field_76438_s, 120 + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(60), 1));
                }
                if (((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new EffectInstance(Effects.field_76421_d, 120 + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(60), 1));
                }
                ((MutantSkeletonEntity)this.mob).field_70170_p.func_217376_c((Entity)arrowEntity);
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.25f);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.attackTarget = null;
        }
    }

    static class ConstrictRibsGoal
    extends AnimationGoal<MutantSkeletonEntity> {
        private LivingEntity attackTarget;

        public ConstrictRibsGoal(MutantSkeletonEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public Animation getAnimation() {
            return CONSTRICT_RIBS_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantSkeletonEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        public void func_75246_d() {
            ((MutantSkeletonEntity)this.mob).func_70661_as().func_75499_g();
            if (((MutantSkeletonEntity)this.mob).animationTick == 6) {
                this.attackTarget.func_184210_p();
                float attackDamage = (float)((MutantSkeletonEntity)this.mob).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2.25f;
                if (this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob), attackDamage)) {
                    ((MutantSkeletonEntity)this.mob).func_174815_a((LivingEntity)this.mob, (Entity)this.attackTarget);
                } else if (this.attackTarget instanceof PlayerEntity && this.attackTarget.func_184585_cz()) {
                    ((PlayerEntity)this.attackTarget).func_190777_m(false);
                }
                this.attackTarget.func_213293_j((double)((1.0f + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.4f) * (float)(((MutantSkeletonEntity)this.mob).field_70146_Z.nextBoolean() ? 1 : -1)), (double)(0.4f + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.8f), (double)((1.0f + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.4f) * (float)(((MutantSkeletonEntity)this.mob).field_70146_Z.nextBoolean() ? 1 : -1)));
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_187539_bB, 0.5f, 0.8f + ((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.4f);
                EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.attackTarget = null;
        }
    }

    static class MeleeGoal
    extends AnimationGoal<MutantSkeletonEntity> {
        public MeleeGoal(MutantSkeletonEntity mob) {
            super(mob);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public Animation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void func_75246_d() {
            ((MutantSkeletonEntity)this.mob).func_70661_as().func_75499_g();
            if (((MutantSkeletonEntity)this.mob).func_70638_az() != null && ((MutantSkeletonEntity)this.mob).func_70638_az().func_70089_S()) {
                ((MutantSkeletonEntity)this.mob).func_70671_ap().func_75651_a((Entity)((MutantSkeletonEntity)this.mob).func_70638_az(), 30.0f, 30.0f);
            }
            if (((MutantSkeletonEntity)this.mob).animationTick == 3) {
                for (Entity entity : ((MutantSkeletonEntity)this.mob).field_70170_p.func_72839_b((Entity)this.mob, ((MutantSkeletonEntity)this.mob).func_174813_aQ().func_186662_g(4.0))) {
                    if (entity instanceof MutantSkeletonEntity) continue;
                    double dist = ((MutantSkeletonEntity)this.mob).func_70032_d(entity);
                    double x = ((MutantSkeletonEntity)this.mob).func_226277_ct_() - entity.func_226277_ct_();
                    double z = ((MutantSkeletonEntity)this.mob).func_226281_cx_() - entity.func_226281_cx_();
                    if (!(dist <= 3.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 60.0f)) continue;
                    float power = 1.8f + (float)((MutantSkeletonEntity)this.mob).field_70146_Z.nextInt(5) * 0.15f;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob), (float)((MutantSkeletonEntity)this.mob).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    entity.func_213293_j(-x / dist * (double)power, Math.max((double)0.28f, entity.func_213322_ci().field_72448_b), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
                ((MutantSkeletonEntity)this.mob).func_184185_a(SoundEvents.field_187721_dT, 1.0f, 1.0f / (((MutantSkeletonEntity)this.mob).field_70146_Z.nextFloat() * 0.4f + 1.2f));
            }
        }
    }
}

