/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.ai.controller.FixedBodyController;
import chumbanotz.mutantbeasts.entity.ai.goal.AnimationGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.FleeRainGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.HurtByNearestTargetGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantSnowGolemEntity
extends GolemEntity
implements IRangedAttackMob,
IAnimatedEntity,
IShearable {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final Animation THROW_ANIMATION = new Animation(20);
    private Animation animation = Animation.NONE;
    private int animationTick;

    public MutantSnowGolemEntity(EntityType<? extends MutantSnowGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimJumpGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeRainGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new ThrowIceGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.1, 30, 12.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 6.0f, 0.01f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByNearestTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, entity -> entity instanceof IMob));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.26f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(STATUS, (Object)1);
    }

    @Nullable
    public PlayerEntity getOwner() {
        UUID uuid = this.getOwnerId();
        return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean hasJackOLantern() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    public void setJackOLantern(boolean jackOLantern) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(jackOLantern ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJumping) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(swimJumping ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn).setAvoidRain(true);
    }

    protected BodyController func_184650_s() {
        return new FixedBodyController((MobEntity)this);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.0f;
    }

    public boolean func_213336_c(LivingEntity target) {
        return target instanceof IMob;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animation != Animation.NONE) {
            ++this.animationTick;
        }
        if (this.field_70170_p.field_72995_K && this.getSwimJump()) {
            EntityUtil.spawnParticlesAtEntity((LivingEntity)this, (IParticleData)ParticleTypes.field_197593_D, 6);
            EntityUtil.spawnParticlesAtEntity((LivingEntity)this, (IParticleData)ParticleTypes.field_218422_X, 6);
        }
        if (this.field_70173_aa % 20 == 0 && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.field_73011_w.func_177495_o()) {
            if (this.field_70146_Z.nextFloat() > Math.min(80.0f, this.func_110143_aJ()) * 0.01f) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, this.func_226282_d_(0.6), this.func_226279_cv_() - 0.15, this.func_226287_g_(0.6), 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 60 == 0 && !this.func_70644_a(Effects.field_76426_n)) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
        } else if (!this.field_70170_p.field_72995_K && this.field_70122_E && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            BlockPos.Mutable pos = new BlockPos.Mutable();
            BlockPos.Mutable posDown = new BlockPos.Mutable();
            BlockPos.Mutable posAbove = new BlockPos.Mutable();
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    pos.func_189535_a((Entity)this).func_196234_d(i, 0, j);
                    posDown.func_189533_g((Vec3i)pos).func_196234_d(0, -1, 0);
                    posAbove.func_189533_g((Vec3i)pos).func_196234_d(0, 1, 0);
                    boolean placeSnow = this.field_70170_p.func_175623_d((BlockPos)pos) && this.field_70170_p.func_226691_t_((BlockPos)pos).func_225486_c((BlockPos)pos) < 0.95f && Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)this.field_70170_p, (BlockPos)pos);
                    boolean placeIce = this.field_70170_p.func_201671_F((BlockPos)posDown);
                    if (this.field_70170_p.func_204610_c((BlockPos)pos).func_206886_c() == Fluids.field_207212_b) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (this.field_70170_p.func_204610_c((BlockPos)posAbove).func_206886_c() == Fluids.field_207212_b) {
                        this.field_70170_p.func_175656_a((BlockPos)posAbove, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(6) != 0)) continue;
                    if (placeSnow) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150433_aE.func_176223_P());
                    }
                    if (!placeIce) continue;
                    this.field_70170_p.func_175656_a((BlockPos)posDown, Blocks.field_150432_aD.func_176223_P());
                }
            }
        }
        if (this.field_70173_aa % 40 == 0 && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.isSnowingAt(this.func_180425_c())) {
            this.func_70691_i(1.0f);
        }
    }

    private boolean isSnowingAt(BlockPos position) {
        if (!this.field_70170_p.func_72896_J()) {
            return false;
        }
        if (!this.field_70170_p.func_226660_f_(position)) {
            return false;
        }
        if (this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        Biome biome = this.field_70170_p.func_226691_t_(position);
        return biome.func_201851_b() == Biome.RainType.SNOW && biome.func_225486_c(position) < 0.15f;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{THROW_ANIMATION};
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected void func_70619_bc() {
        if (this.func_110167_bD()) {
            return;
        }
        PlayerEntity owner = this.getOwner();
        if (owner != null && owner.func_70089_S() && !owner.func_175149_v()) {
            this.func_213390_a(owner.func_180425_c(), this.func_70638_az() == null ? 8 : 16);
        } else if (this.func_213394_dL()) {
            this.func_213390_a(BlockPos.field_177992_a, -1);
        }
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 2 || id == 33 || id == 36 || id == 37 || id == 44) {
            EntityUtil.spawnParticlesAtEntity((LivingEntity)this, (IParticleData)ParticleTypes.field_197593_D, 30);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof SnowballEntity) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70691_i(1.0f);
                }
                EntityUtil.spawnParticlesAtEntity((LivingEntity)this, (IParticleData)ParticleTypes.field_197633_z, 1);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.animation != THROW_ANIMATION) {
            this.animation = THROW_ANIMATION;
        }
    }

    public static boolean canHarm(LivingEntity attacker, Entity target) {
        if (target instanceof MutantSnowGolemEntity) {
            return false;
        }
        if (target instanceof CreeperMinionEntity) {
            return !((CreeperMinionEntity)target).func_70909_n();
        }
        if (target instanceof MobEntity) {
            return target instanceof IMob || ((MobEntity)target).func_70638_az() == attacker;
        }
        return attacker instanceof MutantSnowGolemEntity && ((MutantSnowGolemEntity)attacker).func_70638_az() == target;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_111282_a(player, (LivingEntity)this, hand)) {
            return true;
        }
        if (this.getOwnerId() == null || player == this.getOwner()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setOwnerId(this.getOwnerId() == null ? player.func_110124_au() : null);
            }
            return true;
        }
        return false;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return this.func_70089_S() && this.hasJackOLantern();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        if (!this.field_70170_p.field_72995_K) {
            this.setJackOLantern(false);
        }
        return Collections.singletonList(new ItemStack((IItemProvider)Items.field_221697_cK));
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.getOwner() instanceof ServerPlayerEntity) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(cause);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("JackOLantern", this.hasJackOLantern());
        if (this.getOwnerId() != null) {
            compound.func_186854_a("OwnerUUID", this.getOwnerId());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin") || compound.func_74767_n("JackOLantern")) {
            this.setJackOLantern(compound.func_74767_n("Pumpkin") || compound.func_74767_n("JackOLantern"));
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerId(compound.func_186857_a("OwnerUUID"));
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187815_fJ, 0.15f, 1.0f);
    }

    static class ThrowIceGoal
    extends AnimationGoal<MutantSnowGolemEntity> {
        private LivingEntity attackTarget;

        public ThrowIceGoal(MutantSnowGolemEntity mob) {
            super(mob);
        }

        @Override
        public Animation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean func_75250_a() {
            this.attackTarget = ((MutantSnowGolemEntity)this.mob).func_70638_az();
            return this.attackTarget != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ((MutantSnowGolemEntity)this.mob).field_70699_by.func_75499_g();
        }

        public void func_75246_d() {
            ((MutantSnowGolemEntity)this.mob).field_70761_aq = ((MutantSnowGolemEntity)this.mob).field_70177_z;
            if (((MutantSnowGolemEntity)this.mob).animationTick == 7) {
                ThrowableBlockEntity block = new ThrowableBlockEntity((MutantSnowGolemEntity)this.mob, ((MutantSnowGolemEntity)this.mob).field_70170_p);
                block.func_70107_b(block.func_226277_ct_(), block.func_226278_cu_() + 1.0, block.func_226281_cx_());
                double x = this.attackTarget.func_226277_ct_() - block.func_226277_ct_();
                double y = this.attackTarget.func_226278_cu_() - block.func_226278_cu_();
                double z = this.attackTarget.func_226281_cx_() - block.func_226281_cx_();
                double xz = Math.sqrt(x * x + z * z);
                block.func_70186_c(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                ((MutantSnowGolemEntity)this.mob).field_70170_p.func_217376_c((Entity)block);
            }
        }
    }

    static class SwimJumpGoal
    extends Goal {
        private final MutantSnowGolemEntity golem;
        private int jumpTick;
        private boolean waterReplaced;
        private BlockPos.Mutable prevPos;

        public SwimJumpGoal(MutantSnowGolemEntity golem) {
            this.golem = golem;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            this.golem.field_70699_by.func_212239_d(true);
        }

        public boolean func_75250_a() {
            return this.golem.func_203005_aq();
        }

        public void func_75249_e() {
            this.prevPos = new BlockPos.Mutable(this.golem.func_226277_ct_(), this.golem.func_174813_aQ().field_72338_b - 1.0, this.golem.func_226281_cx_());
            this.golem.func_213293_j((this.golem.field_70146_Z.nextFloat() - this.golem.field_70146_Z.nextFloat()) * 0.9f, 1.5, (this.golem.field_70146_Z.nextFloat() - this.golem.field_70146_Z.nextFloat()) * 0.9f);
            this.golem.func_70097_a(DamageSource.field_76369_e, 16.0f);
            this.golem.setSwimJump(true);
        }

        public boolean func_75253_b() {
            return this.jumpTick > 0;
        }

        public void func_75246_d() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.func_203005_aq() && this.jumpTick < 17 && ForgeEventFactory.getMobGriefingEvent((World)this.golem.field_70170_p, (Entity)this.golem)) {
                this.prevPos.func_185336_p(this.getWaterSurfaceHeight(this.golem.field_70170_p, (BlockPos)this.prevPos));
                if ((double)this.prevPos.func_177956_o() > this.golem.func_226278_cu_()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos pos;
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2) || !this.golem.field_70170_p.func_175623_d(pos = this.prevPos.func_177982_a(x, y, z)) && !this.golem.field_70170_p.func_201671_F(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.field_70146_Z.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.field_70146_Z.nextInt(3) == 0)) continue;
                            this.golem.field_70170_p.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                        }
                    }
                }
                BlockPos topBlockPos = this.prevPos.func_177981_b(2);
                if (this.golem.field_70170_p.func_175623_d(topBlockPos)) {
                    this.golem.field_70170_p.func_175656_a(topBlockPos, Blocks.field_150432_aD.func_176223_P());
                }
                this.waterReplaced = true;
            }
        }

        public void func_75251_c() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.prevPos = null;
            this.golem.setSwimJump(false);
        }

        private int getWaterSurfaceHeight(World world, BlockPos coord) {
            int y = coord.func_177956_o();
            while (world.func_201671_F(new BlockPos(coord.func_177958_n(), y, coord.func_177952_p()))) {
                ++y;
            }
            return y;
        }
    }
}

