/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.controller.FixedBodyController;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.HurtByNearestTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.OwnerTargetGoal;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class SpiderPigEntity
extends TameableEntity
implements IJumpingMount {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(SpiderPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151147_al, Items.field_151070_bp});
    private int leapCooldown;
    private int leapTick;
    private boolean isLeaping;
    private float chargePower;
    private int chargingTick;
    private int chargeExhaustion;
    private boolean chargeExhausted;
    private final List<WebPos> webList = new ArrayList<WebPos>();

    public SpiderPigEntity(EntityType<? extends SpiderPigEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.1).setMaxAttackTick(15));
        this.field_70714_bg.func_75776_a(2, (Goal)new LeapAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.1, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByNearestTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NonTamedTargetGoal((TameableEntity)this, MobEntity.class, true, SpiderPigEntity::isPigOrSpider));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)false);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    private void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public boolean isSaddled() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    private void setSaddled(boolean saddled) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        this.field_70180_af.func_187227_b(field_184755_bv, (Object)(saddled ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.75f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected BodyController func_184650_s() {
        return new FixedBodyController((MobEntity)this);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() != Effects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (!this.func_70631_g_()) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBesideClimbableBlock(this.field_70123_F);
        if (this.chargeExhaustion >= 120) {
            this.chargeExhausted = true;
        }
        if (this.chargeExhaustion <= 0) {
            this.chargeExhausted = false;
        }
        this.chargeExhaustion = Math.max(0, this.chargeExhaustion - 1);
        if (!this.field_70170_p.field_72995_K) {
            this.leapCooldown = Math.max(0, this.leapCooldown - 1);
            if (this.leapTick > 10 && this.field_70122_E) {
                this.isLeaping = false;
            }
            this.updateWebList(false);
            this.updateChargeState();
            if (this.func_70089_S() && this.func_70909_n() && this.field_70173_aa % 600 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    private void updateWebList(boolean onlyCheckSize) {
        WebPos first;
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webList.size(); ++i) {
                WebPos coord = this.webList.get(i);
                if (this.field_70170_p.func_180495_p((BlockPos)coord) != Blocks.field_196553_aF.func_176223_P()) {
                    this.webList.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webList.isEmpty() && (first = this.webList.get(0)).timeLeft < 0) {
                this.webList.remove(0);
                this.removeWeb(first);
            }
        }
        while (this.webList.size() > 12) {
            first = this.webList.remove(0);
            this.removeWeb(first);
        }
    }

    private void removeWeb(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos) == Blocks.field_196553_aF.func_176223_P()) {
            this.field_70170_p.func_175655_b(pos, false);
        }
    }

    private void updateChargeState() {
        if (this.chargingTick > 0) {
            for (LivingEntity livingEntity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ(), EntityPredicates.func_200820_b((Entity)this))) {
                if (livingEntity == this || livingEntity == this.func_70902_q() || !livingEntity.func_190631_cK()) continue;
                this.func_70652_k((Entity)livingEntity);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (itemstack.func_222117_E() && this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(itemstack.func_77973_b().func_219967_s().func_221466_a());
                this.func_175505_a(player, itemstack);
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151141_av) {
                if (!(player.func_213453_ef() || this.isSaddled() || this.func_70631_g_())) {
                    this.setSaddled(true);
                    this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                    this.func_175505_a(player, itemstack);
                    return true;
                }
            } else if (this.isSaddled() && !this.func_184207_aI()) {
                if (!player.func_213453_ef()) {
                    if (!this.field_70170_p.field_72995_K) {
                        player.func_184220_m((Entity)this);
                        this.field_70699_by.func_75499_g();
                        this.func_70604_c(null);
                        this.func_70624_b(null);
                    }
                    return true;
                }
                if (this.func_152114_e((LivingEntity)player)) {
                    this.setSaddled(false);
                    this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_199703_a((IItemProvider)Items.field_151141_av);
                    }
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        return EntityUtil.shouldAttackEntity(this, target, owner, false);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.isLeaping = false;
        if (this.field_70146_Z.nextInt(2) == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            double dx = entityIn.func_226277_ct_() - entityIn.field_70169_q;
            double dz = entityIn.func_226281_cx_() - entityIn.field_70166_s;
            BlockPos pos = new BlockPos((int)(entityIn.func_226277_ct_() + dx * 0.5), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), (int)(entityIn.func_226281_cx_() + dz * 0.5));
            Material material = this.field_70170_p.func_180495_p(pos).func_185904_a();
            if (!material.func_76220_a() && !material.func_76224_d() && material != Material.field_151569_G) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_196553_aF.func_176223_P());
                this.webList.add(new WebPos(pos, this.func_184207_aI() ? 600 : 1200));
                this.updateWebList(true);
                this.func_213293_j(0.0, Math.max(0.25, this.func_213322_ci().field_72448_b), 0.0);
                this.field_70143_R = 0.0f;
            }
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.field_70170_p.func_72875_a(entityIn.func_174813_aQ(), Material.field_151569_G) && !(entityIn instanceof SpiderEntity) && !(entityIn instanceof SpiderPigEntity)) {
            damage += 4.0f;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_184776_b() {
        return this.isSaddled() && !this.chargeExhausted && !this.field_70123_F;
    }

    public void func_110206_u(int jumpPowerIn) {
        this.chargeExhaustion += 50 * jumpPowerIn / 100;
        this.chargePower = 1.0f * (float)jumpPowerIn / 100.0f;
    }

    public void func_184775_b(int jumpPowerIn) {
        this.chargingTick = 8 * jumpPowerIn / 100;
    }

    public void func_184777_r_() {
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_184207_aI() && this.isSaddled();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public void func_213352_e(Vec3d vec3d) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            LivingEntity passenger = (LivingEntity)this.func_184179_bs();
            this.field_70138_W = 1.0f;
            this.field_70177_z = this.field_70759_as = passenger.field_70177_z;
            this.field_70126_B = this.field_70759_as;
            this.field_70127_C = this.field_70125_A = passenger.field_70125_A * 0.4f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            while (this.field_70761_aq > this.field_70759_as + 180.0f) {
                this.field_70761_aq -= 360.0f;
            }
            while (this.field_70761_aq < this.field_70759_as - 180.0f) {
                this.field_70761_aq += 360.0f;
            }
            if (!this.chargeExhausted && this.chargePower > 0.0f && (this.field_70122_E || !this.func_213339_cH().func_204520_s().func_206888_e())) {
                double power = (double)1.6f * (double)this.chargePower;
                Vec3d lookVector = this.func_70040_Z();
                this.func_213293_j(lookVector.field_72450_a * power, 0.3f, lookVector.field_72449_c * power);
                this.chargePower = 0.0f;
            } else {
                this.chargePower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float strafe = passenger.field_70702_br * 0.8f;
                float forward = passenger.field_191988_bg * 0.6f;
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_213352_e(new Vec3d((double)strafe, vec3d.field_72448_b, (double)forward));
            } else if (passenger instanceof PlayerEntity) {
                this.func_213317_d(Vec3d.field_186680_a);
            } else {
                double d3;
                this.field_184618_aE = this.field_70721_aZ;
                double d2 = this.func_226277_ct_() - this.field_70169_q;
                float f4 = MathHelper.func_76133_a((double)(d2 * d2 + (d3 = this.func_226281_cx_() - this.field_70166_s) * d3)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            }
        } else {
            this.field_70138_W = 0.6f;
            this.field_70747_aH = 0.02f;
            super.func_213352_e(vec3d);
        }
    }

    public void func_70074_a(LivingEntity livingEntity) {
        if (!this.field_70170_p.field_72995_K) {
            if (livingEntity instanceof CreeperMinionEntity && !this.func_70909_n()) {
                CreeperMinionEntity minion = (CreeperMinionEntity)livingEntity;
                LivingEntity owner = minion.func_70902_q();
                if (owner instanceof PlayerEntity && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)((PlayerEntity)owner))) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.func_193101_c((PlayerEntity)owner);
                    minion.func_70106_y();
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            if (SpiderPigEntity.isPigOrSpider(livingEntity)) {
                EntityUtil.convertMobWithNBT(livingEntity, MBEntityType.SPIDER_PIG, false);
            }
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_213295_a(BlockState blockState, Vec3d motionMultiplier) {
        if (blockState.func_177230_c() != Blocks.field_196553_aF) {
            super.func_213295_a(blockState, motionMultiplier);
        }
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        if (this.field_70146_Z.nextInt(20) == 0) {
            return (AgeableEntity)EntityType.field_200784_X.func_200721_a(this.field_70170_p);
        }
        SpiderPigEntity spiderPig = (SpiderPigEntity)MBEntityType.SPIDER_PIG.func_200721_a(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            spiderPig.func_184754_b(uuid);
            spiderPig.func_70903_f(true);
        }
        return spiderPig;
    }

    protected void func_213337_cE() {
        if (this.isSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
            this.setSaddled(false);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && !this.webList.isEmpty()) {
            for (WebPos webPos : this.webList) {
                this.removeWeb(webPos);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Saddled", this.isSaddled());
        if (!this.webList.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (WebPos coord : this.webList) {
                CompoundNBT compound1 = NBTUtil.func_186859_a((BlockPos)coord);
                compound1.func_74768_a("TimeLeft", coord.timeLeft);
                listnbt.add((Object)compound1);
            }
            compound.func_218657_a("Webs", (INBT)listnbt);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle") || compound.func_74767_n("Saddled"));
        ListNBT listnbt = compound.func_150295_c("Webs", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compound1 = listnbt.func_150305_b(i);
            this.webList.add(i, new WebPos(NBTUtil.func_186861_c((CompoundNBT)compound1), compound1.func_74762_e("TimeLeft")));
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_SPIDER_PIG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_SPIDER_PIG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_SPIDER_PIG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public static boolean isPigOrSpider(LivingEntity livingEntity) {
        return livingEntity.func_200600_R() == EntityType.field_200784_X || livingEntity.func_200600_R() == EntityType.field_200748_an;
    }

    static class WebPos
    extends BlockPos {
        private int timeLeft;

        public WebPos(BlockPos pos, int timeLeft) {
            super((Vec3i)pos);
            this.timeLeft = timeLeft;
        }
    }

    static class LeapAttackGoal
    extends Goal {
        private final SpiderPigEntity spiderPig;

        public LeapAttackGoal(SpiderPigEntity spiderPig) {
            this.spiderPig = spiderPig;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.spiderPig.func_70638_az();
            return target != null && this.spiderPig.leapCooldown <= 0 && (this.spiderPig.field_70122_E || this.spiderPig.field_70123_F || this.spiderPig.func_70090_H() || this.spiderPig.func_180799_ab()) && (this.spiderPig.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()) < 64.0 && this.spiderPig.field_70146_Z.nextInt(8) == 0 || this.spiderPig.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()) < 6.25);
        }

        public void func_75249_e() {
            this.spiderPig.isLeaping = true;
            this.spiderPig.leapCooldown = 15;
            LivingEntity target = this.spiderPig.func_70638_az();
            double x = target.func_226277_ct_() - this.spiderPig.func_226277_ct_();
            double y = target.func_226278_cu_() - this.spiderPig.func_226278_cu_();
            double z = target.func_226281_cx_() - this.spiderPig.func_226281_cx_();
            double d = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            double scale = 2.0f + 0.2f * this.spiderPig.field_70146_Z.nextFloat() * this.spiderPig.field_70146_Z.nextFloat();
            this.spiderPig.func_213293_j(x / d * scale, y / d * scale * 0.5 + 0.3, z / d * scale);
        }

        public boolean func_75253_b() {
            return this.spiderPig.isLeaping && this.spiderPig.leapTick < 40;
        }

        public void func_75246_d() {
            ++this.spiderPig.leapTick;
        }

        public void func_75251_c() {
            this.spiderPig.leapTick = 0;
        }
    }
}

