/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.projectile;

import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ThrowableBlockEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> HELD = EntityDataManager.func_187226_a(ThrowableBlockEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockState blockState = Blocks.field_196658_i.func_176223_P();
    private UUID ownerUUID;

    public ThrowableBlockEntity(EntityType<? extends ThrowableBlockEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrowableBlockEntity(EntityType<? extends ThrowableBlockEntity> type, LivingEntity livingEntityIn, World worldIn) {
        super(MBEntityType.THROWABLE_BLOCK, livingEntityIn, worldIn);
        this.setThrower(livingEntityIn);
    }

    public ThrowableBlockEntity(World world, MutantEndermanEntity enderman, int id) {
        this(MBEntityType.THROWABLE_BLOCK, (LivingEntity)enderman, world);
        this.blockState = Block.func_196257_b((int)enderman.heldBlock[id]);
        boolean outer = id <= 2;
        boolean right = (id & 1) == 1;
        LivingEntity attackTarget = enderman.func_70638_az();
        Vec3d forward = EntityUtil.getDirVector(this.field_70177_z, outer ? 2.7f : 1.4f);
        Vec3d strafe = EntityUtil.getDirVector(this.field_70177_z + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.func_70107_b(this.func_226277_ct_() + forward.field_72450_a + strafe.field_72450_a, this.func_226278_cu_() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.func_226281_cx_() + forward.field_72449_c + strafe.field_72449_c);
        if (attackTarget != null) {
            this.func_70186_c(attackTarget.func_226277_ct_() - this.func_226277_ct_(), attackTarget.func_226283_e_(0.5) - this.func_226278_cu_(), attackTarget.func_226281_cx_() - this.func_226281_cx_(), 1.4f, 1.0f);
        } else {
            this.throwBlock((LivingEntity)enderman);
        }
    }

    public ThrowableBlockEntity(MutantSnowGolemEntity mutantSnowGolem, World worldIn) {
        this(MBEntityType.THROWABLE_BLOCK, (LivingEntity)mutantSnowGolem, worldIn);
        this.field_70177_z = mutantSnowGolem.field_70177_z;
        this.blockState = Blocks.field_150432_aD.func_176223_P();
    }

    public ThrowableBlockEntity(World world, PlayerEntity player, BlockState blockState, BlockPos pos) {
        this(MBEntityType.THROWABLE_BLOCK, (LivingEntity)player, world);
        this.blockState = blockState;
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.setHeld(true);
    }

    public ThrowableBlockEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        this(MBEntityType.THROWABLE_BLOCK, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HELD, (Object)false);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public LivingEntity func_85052_h() {
        Entity entity;
        if (this.field_70192_c == null && this.ownerUUID != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUUID)) instanceof LivingEntity) {
            this.setThrower((LivingEntity)entity);
        }
        return this.field_70192_c;
    }

    private void setThrower(LivingEntity thrower) {
        this.field_70192_c = thrower;
        this.ownerUUID = thrower.func_110124_au();
    }

    public boolean isHeld() {
        return (Boolean)this.field_70180_af.func_187225_a(HELD);
    }

    private void setHeld(boolean held) {
        this.field_70180_af.func_187227_b(HELD, (Object)held);
    }

    protected float func_70185_h() {
        if (this.field_70192_c instanceof PlayerEntity) {
            return 0.04f;
        }
        if (this.field_70192_c instanceof MutantSnowGolemEntity) {
            return 0.06f;
        }
        return 0.01f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.isHeld() && this.func_70089_S();
    }

    public boolean func_70104_M() {
        return this.isHeld() && this.func_70089_S();
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn != this.field_70192_c) {
            super.func_70108_f(entityIn);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                double y = 0.5f + this.field_70146_Z.nextFloat() * 2.0f;
                double z = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.blockState), this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), x, y, z);
            }
        }
    }

    public void func_70071_h_() {
        if (this.isHeld()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_225510_bt_());
            }
            this.func_70030_z();
            if (this.field_70192_c == null || !this.field_70192_c.func_70089_S() || this.field_70192_c.func_175149_v() || !EndersoulFragmentEntity.isProtected((Entity)this.field_70192_c)) {
                this.setHeld(false);
            } else {
                Vec3d vec = this.field_70192_c.func_70040_Z();
                double x = this.field_70192_c.func_226277_ct_() + vec.field_72450_a * 1.6 - this.func_226277_ct_();
                double y = this.field_70192_c.func_226278_cu_() + (double)this.field_70192_c.func_70047_e() + vec.field_72448_b * 1.6 - this.func_226278_cu_();
                double z = this.field_70192_c.func_226281_cx_() + vec.field_72449_c * 1.6 - this.func_226281_cx_();
                float offset = 0.6f;
                this.func_213293_j(x * (double)offset, y * (double)offset, z * (double)offset);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            }
        } else {
            super.func_70071_h_();
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            return false;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77973_b() != MBItems.ENDERSOUL_HAND) {
            return false;
        }
        if (this.isHeld() && this.field_70192_c == player) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHeld(false);
                this.throwBlock((LivingEntity)player);
            }
            player.func_184609_a(hand);
            itemStack.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
            return true;
        }
        return false;
    }

    private void throwBlock(LivingEntity thrower) {
        this.field_70177_z = thrower.field_70177_z;
        this.field_70125_A = thrower.field_70125_A;
        float f = 0.4f;
        this.func_213293_j(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f, -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f, MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f);
        this.func_70186_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, 1.4f, 1.0f);
    }

    protected void func_70184_a(RayTraceResult result) {
        BlockPos pos;
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(pos = ((BlockRayTraceResult)result).func_216350_a()).func_196952_d((IBlockReader)this.field_70170_p, pos).func_197766_b()) {
            return;
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a().func_70028_i((Entity)this.field_70192_c)) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70192_c instanceof MutantSnowGolemEntity) {
            Object entity;
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY && (!MutantSnowGolemEntity.canHarm(this.field_70192_c, (Entity)(entity = ((EntityRayTraceResult)result).func_216348_a())) || entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70192_c), 4.0f) && entity.func_200600_R() == EntityType.field_200803_q)) {
                return;
            }
            for (LivingEntity livingEntity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(2.5, 2.0, 2.5))) {
                if (!MutantSnowGolemEntity.canHarm(this.field_70192_c, (Entity)livingEntity) || !(this.func_70092_e(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_()) <= 6.25)) continue;
                livingEntity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.field_70192_c), 4.0f + (float)this.field_70146_Z.nextInt(3));
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
            this.func_184185_a(this.blockState.func_215695_r().func_185845_c(), 0.8f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f);
        } else {
            boolean canOwnerGrief;
            pos = this.func_180425_c();
            ItemStack itemStack = new ItemStack((IItemProvider)this.blockState.func_177230_c());
            boolean bl = canOwnerGrief = this.field_70192_c == null || !(this.field_70192_c instanceof MobEntity) || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.field_70192_c);
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.func_70106_y();
                if (canOwnerGrief) {
                    BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
                    Direction direction = blockRayTraceResult.func_216354_b();
                    DirectionalPlaceContext context = new DirectionalPlaceContext(this.field_70170_p, blockRayTraceResult.func_216350_a().func_177972_a(direction), direction, itemStack, direction.func_176734_d());
                    if (itemStack.func_77973_b() instanceof BlockItem && ((BlockItem)itemStack.func_77973_b()).func_195942_a((BlockItemUseContext)context).func_226246_a_()) {
                        return;
                    }
                }
                this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.blockState));
                if (canOwnerGrief && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199701_a_(itemStack);
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                if (entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70192_c), 4.0f) && entity.func_200600_R() == EntityType.field_200803_q) {
                    return;
                }
                this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.blockState));
                if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199701_a_(itemStack);
                }
            }
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(2.0))) {
                if (!entity.func_70067_L() || entity.func_70028_i((Entity)this.field_70192_c) || !(this.func_70092_e(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()) <= 4.0)) continue;
                double x = entity.func_226277_ct_() - this.func_226277_ct_();
                double z = entity.func_226281_cx_() - this.func_226281_cx_();
                double d = Math.sqrt(x * x + z * z);
                entity.func_213293_j(x / d * (double)0.6f, (double)0.2f, z / d * (double)0.6f);
                entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.field_70192_c), 6.0f + (float)this.field_70146_Z.nextInt(3));
            }
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.blockState));
        compound.func_74757_a("Held", this.isHeld());
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("BlockState", 10)) {
            this.blockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        }
        this.setHeld(compound.func_74767_n("Held"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(Block.func_196246_j((BlockState)this.blockState));
        buffer.func_150787_b(this.field_70192_c == null ? 0 : this.field_70192_c.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.blockState = Block.func_196257_b((int)additionalData.func_150792_a());
        Entity entity = this.field_70170_p.func_73045_a(additionalData.func_150792_a());
        this.field_70192_c = entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

