/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.util.SeismicWave;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HulkHammerItem
extends Item {
    public static final Map<UUID, List<SeismicWave>> WAVES = new HashMap<UUID, List<SeismicWave>>();

    public HulkHammerItem(Item.Properties properties) {
        super(properties.func_200918_c(64));
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.MAINHAND;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        RayTraceResult result = HulkHammerItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK || ((BlockRayTraceResult)result).func_216354_b() != Direction.UP) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (!worldIn.field_72995_K) {
            ArrayList<SeismicWave> list = new ArrayList<SeismicWave>();
            Vec3d vec = Vec3d.func_189986_a((float)0.0f, (float)playerIn.field_70177_z);
            int x = MathHelper.func_76128_c((double)(playerIn.func_226277_ct_() + vec.field_72450_a * 1.5));
            int y = MathHelper.func_76128_c((double)playerIn.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)(playerIn.func_226281_cx_() + vec.field_72449_c * 1.5));
            int x1 = MathHelper.func_76128_c((double)(playerIn.func_226277_ct_() + vec.field_72450_a * 8.0));
            int z1 = MathHelper.func_76128_c((double)(playerIn.func_226281_cx_() + vec.field_72449_c * 8.0));
            SeismicWave.createWaves(worldIn, list, x, z, x1, z1, y);
            HulkHammerItem.addWave(playerIn.func_110124_au(), list);
        }
        worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.8f, 0.8f + playerIn.func_70681_au().nextFloat() * 0.4f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, 25);
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        stack.func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213334_d(handIn));
        return ActionResult.func_226248_a_((Object)stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 8.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public static void addWave(UUID name, List<SeismicWave> list) {
        List<SeismicWave> waves = null;
        Iterator<List<SeismicWave>> iterator = WAVES.values().iterator();
        while (iterator.hasNext()) {
            List<SeismicWave> waves1;
            waves = waves1 = iterator.next();
        }
        if (waves == null) {
            WAVES.put(name, list);
        } else {
            waves.addAll(list);
            WAVES.put(name, waves);
        }
    }
}

