/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.client.animationapi.Animation;
import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimationPacket {
    private final int entityId;
    private final int index;
    private final int tick;

    public AnimationPacket(int entityId, int index, int tick) {
        this.entityId = entityId;
        this.index = index;
        this.tick = tick;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.index);
        buffer.writeInt(this.tick);
    }

    AnimationPacket(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.index = buffer.readInt();
        this.tick = buffer.readInt();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.filter(ClientWorld.class::isInstance).ifPresent(world -> {
                IAnimatedEntity entity = (IAnimatedEntity)world.func_73045_a(this.entityId);
                if (entity != null) {
                    if (this.index == -1) {
                        entity.setAnimation(Animation.NONE);
                    } else {
                        entity.setAnimation(entity.getAnimations()[this.index]);
                    }
                    entity.setAnimationTick(this.tick);
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

